/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.db.mongo;

import cn.alphabets.light.Constant;
import cn.alphabets.light.Environment;
import cn.alphabets.light.Helper;
import cn.alphabets.light.db.mongo.Connection;
import cn.alphabets.light.entity.ModFile;
import cn.alphabets.light.model.ModCommon;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.atteo.evo.inflector.English;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class Model {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private MongoDatabase db;
    private MongoCollection<Document> collection;
    private String name;
    private Class<? extends ModCommon> clazz;
    public static List<String> reserved = Arrays.asList("board", "configuration", "validator", "i18n", "structure", "board", "route", "tenant", "file");

    private Model() {
    }

    public Model(String domain, String code) {
        this(domain, code, null);
    }

    public Model(String domain, String code, String table) {
        this(domain, code, table, null);
    }

    public Model(String domain, String code, String table, Class<? extends ModCommon> clazz) {
        MongoClient client = Connection.instance(Environment.instance());
        this.db = client.getDatabase(domain);
        this.name = table;
        this.clazz = clazz;
        if (table != null) {
            table = English.plural((String)table.toLowerCase());
            if (!"LightDB".equals(domain) && !StringUtils.isEmpty((CharSequence)code)) {
                table = code + '.' + table;
            }
            this.collection = this.db.getCollection(table);
        }
    }

    public <T extends ModCommon> List<T> list() {
        return this.list(null);
    }

    public <T extends ModCommon> List<T> list(Bson condition) {
        return this.list(condition, null);
    }

    public <T extends ModCommon> List<T> list(Bson condition, List<String> fieldNames) {
        return this.list(condition, fieldNames, null);
    }

    public <T extends ModCommon> List<T> list(Bson condition, List<String> fieldNames, Bson sort) {
        return this.list(condition, fieldNames, sort, 0);
    }

    public <T extends ModCommon> List<T> list(Bson condition, List<String> fieldNames, Bson sort, int skip) {
        return this.list(condition, fieldNames, sort, skip, (int)Constant.DEFAULT_LIMIT);
    }

    public <T extends ModCommon> List<T> list(Bson condition, List<String> fieldNames, Bson sort, int skip, int limit) {
        return this.list(condition, Projections.include(fieldNames), sort, skip, limit);
    }

    public <T extends ModCommon> List<T> list(Bson condition, Bson select, Bson sort, int skip, int limit) {
        FindIterable find = this.collection.find(condition).projection(select).sort(sort).skip(skip).limit(limit);
        ArrayList result = new ArrayList();
        find.forEach(document -> result.add(ModCommon.fromDocument(document, this.getModelType())));
        return result;
    }

    public List<Document> document(Document condition, List<String> fieldNames) {
        FindIterable find = this.collection.find((Bson)condition);
        FindIterable projection = find.projection(Projections.include(fieldNames));
        ArrayList<Document> result = new ArrayList<Document>();
        projection.forEach(result::add);
        return result;
    }

    public <T extends ModCommon> T get(Document condition) {
        return this.get(condition, (List<String>)null);
    }

    public <T extends ModCommon> T get(Document condition, List<String> fieldNames) {
        condition = condition == null ? new Document() : condition;
        fieldNames = fieldNames == null ? Collections.emptyList() : fieldNames;
        FindIterable find = this.collection.find((Bson)condition);
        FindIterable projection = find.projection(Projections.include(fieldNames));
        Document document = (Document)find.first();
        return ModCommon.fromDocument(document, this.getModelType());
    }

    public <T extends ModCommon> T get(Document condition, Document select) {
        FindIterable find = this.collection.find((Bson)condition).projection((Bson)select);
        Document document = (Document)find.first();
        return ModCommon.fromDocument(document, this.getModelType());
    }

    public long remove(Document condition) {
        return this.update(condition, new Document("valid", (Object)Constant.INVALID));
    }

    public long delete(Document condition) {
        return this.collection.deleteMany((Bson)condition).getDeletedCount();
    }

    public long update(Document condition, Document data) {
        return this.collection.updateMany((Bson)condition, (Bson)new Document("$set", (Object)data)).getModifiedCount();
    }

    public long count(Document condition) {
        return this.collection.count((Bson)condition);
    }

    public <T extends ModCommon> List<T> add(List<Document> document) {
        this.collection.insertMany(document);
        ArrayList result = new ArrayList();
        document.forEach(x -> result.add(ModCommon.fromDocument(x, this.getModelType())));
        return result;
    }

    public <T extends ModCommon> T add(Document document) {
        this.collection.insertOne((Object)document);
        return ModCommon.fromDocument(document, this.getModelType());
    }

    public long increase(String type) {
        Document document = (Document)this.collection.findOneAndUpdate(Filters.eq((String)"type", (Object)type), Updates.inc((String)"sequence", (Number)1L), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        return document.getLong((Object)"sequence");
    }

    public GridFSFile writeFileToGrid(String path) {
        String contentType;
        FileInputStream stream;
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        try {
            stream = new FileInputStream(file);
            contentType = Helper.getContentType(stream);
            stream.getChannel().position(0L);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return null;
        }
        return this.writeStreamToGrid(file.getName(), stream, contentType);
    }

    public GridFSFile writeFileToGrid(Document meta) {
        String name = meta.getString((Object)"filename");
        String type = meta.getString((Object)"content_type");
        try {
            FileInputStream stream = new FileInputStream(new File(meta.getString((Object)"file")));
            return this.writeStreamToGrid(name, stream, type);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public GridFSFile writeStreamToGrid(String name, InputStream stream, String contentType) {
        GridFSBucket gridFSBucket = GridFSBuckets.create((MongoDatabase)this.db);
        Document meta = new Document("contentType", (Object)contentType);
        GridFSUploadOptions options = new GridFSUploadOptions().metadata(meta);
        ObjectId fileId = gridFSBucket.uploadFromStream(name, stream, options);
        GridFSFile fs = (GridFSFile)gridFSBucket.find((Bson)new Document("_id", (Object)fileId)).first();
        return fs;
    }

    public ModFile readStreamFromGrid(String fileId, OutputStream outputStream) {
        return this.readStreamFromGrid(new ObjectId(fileId), outputStream);
    }

    public ByteArrayOutputStream readStreamFromGrid(ObjectId fileId) {
        GridFSBucket gridFSBucket = GridFSBuckets.create((MongoDatabase)this.db);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        gridFSBucket.downloadToStream(fileId, (OutputStream)outputStream);
        return outputStream;
    }

    public ByteArrayOutputStream readStreamFromGrid(ObjectId fileId, long offset, long length) throws IOException {
        ByteArrayOutputStream outputStream;
        GridFSBucket gridFSBucket = GridFSBuckets.create((MongoDatabase)this.db);
        GridFSDownloadStream gridFSDownloadStream = gridFSBucket.openDownloadStream(fileId);
        if (IOUtils.copyLarge((InputStream)gridFSDownloadStream, (OutputStream)(outputStream = new ByteArrayOutputStream()), (long)offset, (long)length) != length) {
            gridFSDownloadStream.close();
            throw new EOFException(String.format("GridFSDownloadStream unsatisfied offset : %d ,length : %d", offset, length));
        }
        gridFSDownloadStream.close();
        return outputStream;
    }

    public ModFile readStreamFromGrid(ObjectId fileId, OutputStream outputStream) {
        GridFSBucket gridFSBucket = GridFSBuckets.create((MongoDatabase)this.db);
        gridFSBucket.downloadToStream(fileId, outputStream);
        GridFSFile fs = (GridFSFile)gridFSBucket.find((Bson)new Document("_id", (Object)fileId)).first();
        ModFile file = new ModFile();
        file.setName(fs.getFilename());
        file.setLength(fs.getLength());
        file.setContentType(fs.getMetadata().getString((Object)"contentType"));
        file.setFileId(fileId);
        return file;
    }

    public void deleteFromGrid(ObjectId fileId) {
        GridFSBuckets.create((MongoDatabase)this.db).delete(fileId);
    }

    public static Class getModelType(String structure) {
        String className = "Mod" + WordUtils.capitalize((String)structure);
        String packageName = reserved.contains(structure) ? "cn.alphabets.light.entity" : Environment.instance().getPackages() + ".entity";
        try {
            return Class.forName(packageName + "." + className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName("cn.alphabets.light.entity." + className);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private Class getModelType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        return Model.getModelType(this.name);
    }
}

