/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.db.mongo;

import cn.alphabets.light.Constant;
import cn.alphabets.light.db.mongo.Model;
import cn.alphabets.light.entity.ModFile;
import cn.alphabets.light.exception.DataRiderException;
import cn.alphabets.light.http.RequestFile;
import cn.alphabets.light.model.Entity;
import cn.alphabets.light.model.ModCommon;
import cn.alphabets.light.model.Plural;
import cn.alphabets.light.model.datarider.DBParams;
import com.mongodb.client.gridfs.model.GridFSFile;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class Controller {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);
    private DBParams params;
    private Model model;
    private String uid;

    public Controller(DBParams params) {
        this.params = params;
        this.model = new Model(params.getDomain(), params.getCode(), params.getTable(), params.getClazz());
        this.uid = params.getUid();
    }

    public <T extends ModCommon> Plural<T> list() {
        logger.debug((Object)("[LIST] DB params : " + this.params.toString()));
        List items = this.model.list((Bson)this.params.getCondition(), (Bson)this.params.getSelect(), (Bson)this.params.getSort(), this.params.getSkip(), this.params.getLimit());
        return new Plural(this.count(), items);
    }

    public <T extends ModCommon> T get() {
        logger.debug((Object)("[GET] DB params : " + this.params.toString()));
        Document condition = this.params.getCondition();
        if (condition == null || condition.size() == 0) {
            throw DataRiderException.ParameterUnsatisfied("Get condition can not be empty.");
        }
        return this.model.get(condition, this.params.getSelect());
    }

    public <T extends ModCommon> T add() {
        logger.debug((Object)("[ADD] DB params : " + this.params.toString()));
        Document document = this.params.getData();
        document.put("createAt", (Object)new Date());
        document.put("updateAt", (Object)new Date());
        document.put("createBy", (Object)this.uid);
        document.put("updateBy", (Object)this.uid);
        document.put("valid", (Object)Constant.VALID);
        document.put("_id", (Object)new ObjectId());
        Document confirmed = Entity.fromDocument(document, this.params.getClazz(), this.params.getHandler()).toDocument();
        return this.model.add(confirmed);
    }

    public <T extends ModCommon> T update() {
        logger.debug((Object)("[UPDATE] DB params : " + this.params.toString()));
        Document document = this.params.getData();
        document.put("updateAt", (Object)new Date());
        document.put("updateBy", (Object)this.uid);
        Document confirmed = Entity.fromDocument(document, this.params.getClazz(), this.params.getHandler()).toDocument(true);
        Document condition = this.params.getCondition();
        if (condition == null || condition.size() == 0) {
            throw DataRiderException.ParameterUnsatisfied("Update condition can not be empty.");
        }
        this.model.update(condition, confirmed);
        return this.model.get(condition, this.params.getSelect());
    }

    public Long remove() {
        logger.debug((Object)("[REMOVE] DB params : " + this.params.toString()));
        Document document = new Document();
        document.put("updateAt", (Object)new Date());
        document.put("updateBy", (Object)this.uid);
        document.put("valid", (Object)Constant.INVALID);
        Document condition = this.params.getCondition();
        if (condition == null || condition.size() == 0) {
            throw DataRiderException.ParameterUnsatisfied("Remove condition can not be empty.");
        }
        return this.model.update(condition, document);
    }

    public Long count() {
        return this.model.count(this.params.getCondition());
    }

    public ByteArrayOutputStream readStreamFromGrid() {
        return this.model.readStreamFromGrid(this.params.getCondition().getObjectId((Object)"_id"));
    }

    public ByteArrayOutputStream readStreamFromGrid(long offset, long length) {
        try {
            return this.model.readStreamFromGrid(this.params.getCondition().getObjectId((Object)"_id"), offset, length);
        }
        catch (IOException e) {
            throw DataRiderException.GridFSError("Read file error", e);
        }
    }

    public ModFile readStreamFromGrid(OutputStream outputStream) {
        return this.model.readStreamFromGrid(this.params.getCondition().getObjectId((Object)"_id"), outputStream);
    }

    public GridFSFile writeFileToGrid(RequestFile file) {
        return this.model.writeFileToGrid(file);
    }

    public void deleteFromGrid() {
        this.model.deleteFromGrid(this.params.getCondition().getObjectId((Object)"_id"));
    }
}

