/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.config;

import cn.alphabets.light.cache.CacheManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ConfigManager {
    INSTANCE;

    private Map<String, Object> map;

    public ConfigManager setUp() {
        if (this.map == null) {
            this.map = new ConcurrentHashMap<String, Object>();
        }
        CacheManager.INSTANCE.getConfiguration().forEach(document -> {
            String key = document.getType() + "." + document.getKey();
            this.map.put(key, document.getValue());
        });
        return this;
    }

    public List<String> getIgnoreTimeout() {
        return this.getArray("ignore.timeout");
    }

    public Long getAppTimeout() {
        return this.getLong("app.timeout");
    }

    public Long getAppSessionTimeout() {
        return this.getLong("app.sessionTimeout");
    }

    public List<String> getIgnoreAuth() {
        return this.getArray("ignore.auth");
    }

    public String getString(String key) {
        if (this.map.get(key) != null) {
            return String.valueOf(this.map.get(key));
        }
        return null;
    }

    public long getLong(String key) {
        return Long.valueOf(this.getString(key));
    }

    public long getInt(String key) {
        return Integer.valueOf(this.getString(key)).intValue();
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getString(key));
    }

    public List<String> getArray(String key) {
        return (List)this.map.get(key);
    }
}

