/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light.cache;

import cn.alphabets.light.Constant;
import cn.alphabets.light.db.mongo.Model;
import cn.alphabets.light.entity.ModBoard;
import cn.alphabets.light.entity.ModConfiguration;
import cn.alphabets.light.entity.ModFunction;
import cn.alphabets.light.entity.ModI18n;
import cn.alphabets.light.entity.ModJob;
import cn.alphabets.light.entity.ModRoute;
import cn.alphabets.light.entity.ModStructure;
import cn.alphabets.light.entity.ModTenant;
import cn.alphabets.light.entity.ModValidator;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public enum CacheManager {
    INSTANCE;

    private List<ModConfiguration> configuration;
    private List<ModI18n> i18ns;
    private List<ModTenant> tenants;
    private List<ModValidator> validators;
    private List<ModStructure> structures;
    private List<ModBoard> boards;
    private List<ModRoute> routes;
    private List<ModFunction> functions;
    private List<ModJob> jobs;

    public void setUp(String domain) {
        String code = "light";
        Document valid = Document.parse((String)"{valid:1}");
        List<String> select = Arrays.asList("type", "key", "value", "valueType");
        this.configuration = new Model(domain, code, "configuration").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("group", "name", "rule", "key", "option", "message", "sanitize", "class", "action", "condition");
        this.validators = new Model(domain, code, "validator").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("type", "lang", "key");
        this.i18ns = new Model(domain, code, "i18n").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("public", "lock", "type", "kind", "tenant", "version", "schema", "items", "extend", "tenant");
        this.structures = new Model(domain, code, "structure").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("schema", "api", "type", "kind", "path", "class", "action", "filters", "selects", "sorts", "reserved", "script");
        this.boards = new Model(domain, code, "board").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("template", "url", "class", "action");
        this.routes = new Model(domain, code, "route").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("order", "description", "menu", "reserved", "status", "type", "url", "icon", "kind", "parent");
        this.functions = new Model(domain, code, "function").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("name", "run", "schedule", "limit", "status", "count", "last", "start", "description", "extend", "step");
        this.jobs = new Model(domain, code, "job").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
        select = Arrays.asList("code", "name");
        this.tenants = new Model(domain, null, "tenant").list((Bson)valid, select, null, 0, (int)Constant.MAX_LIMIT);
    }

    public List<ModConfiguration> getConfiguration() {
        return this.configuration;
    }

    public List<ModI18n> getI18ns() {
        return this.i18ns;
    }

    public List<ModTenant> getTenants() {
        return this.tenants;
    }

    public List<ModValidator> getValidators() {
        return this.validators;
    }

    public List<ModStructure> getStructures() {
        return this.structures;
    }

    public List<ModBoard> getBoards() {
        return this.boards;
    }

    public List<ModRoute> getRoutes() {
        return this.routes;
    }

    public List<ModFunction> getFunctions() {
        return this.functions;
    }

    public List<ModJob> getJobs() {
        return this.jobs;
    }
}

