/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light;

import cn.alphabets.light.Environment;
import cn.alphabets.light.Helper;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.config.ConfigManager;
import cn.alphabets.light.entity.ModCode;
import cn.alphabets.light.entity.ModFile;
import cn.alphabets.light.exception.BadRequestException;
import cn.alphabets.light.http.Context;
import cn.alphabets.light.http.Params;
import cn.alphabets.light.http.RequestFile;
import cn.alphabets.light.model.File;
import cn.alphabets.light.model.Plural;
import cn.alphabets.light.model.datarider.DBParams;
import cn.alphabets.light.model.datarider.DataRider;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import org.apache.maven.model.Model;
import org.bson.Document;
import org.bson.types.ObjectId;

class Push {
    private static final Logger logger = LoggerFactory.getLogger(Push.class);

    Push() {
    }

    void exec() {
        Plural<ModFile> result;
        String home = System.getProperty("user.dir");
        String pomFile = home + "/pom.xml";
        if (!new java.io.File(pomFile).exists()) {
            logger.error((Object)"The pom file does not exist.");
            return;
        }
        Model pom = Helper.getPOM(pomFile);
        String jarFile = String.format("%s/target/%s-%s.jar", home, pom.getArtifactId(), pom.getVersion());
        String jarFileName = String.format("%s-%s.jar", pom.getArtifactId(), pom.getVersion());
        if (!new java.io.File(jarFile).exists()) {
            logger.error((Object)"The jar file does not exist.\nRun the mvn package command to generate the jar file");
            return;
        }
        ArrayList<RequestFile> file = new ArrayList<RequestFile>();
        file.add(new RequestFile(jarFile, "application/zip", jarFileName, true));
        Params params = new Params(new Document(), file);
        Environment env = Environment.instance();
        Context handler = new Context(params, env.getAppName(), "light", "000000000000000000000000");
        try {
            result = new File().add(handler);
        }
        catch (BadRequestException e) {
            throw new RuntimeException("Error uploading file");
        }
        DBParams condition = new DBParams(handler);
        condition.getCondition().put("name", (Object)"app.jar");
        DataRider.ride(ModCode.class).remove(condition);
        DBParams data = new DBParams(handler);
        data.getData().put("app", (Object)env.getAppName());
        data.getData().put("name", (Object)"app.jar");
        data.getData().put("type", (Object)"binary");
        data.getData().put("source", (Object)result.getItems().get(0).get_id().toHexString());
        DataRider.ride(ModCode.class).add(data);
        logger.debug((Object)jarFile);
        logger.info((Object)"Uploaded successfully");
    }

    void pull(String path) {
        String appName = Environment.instance().getAppName();
        Params defaults = new Params(new Document());
        Context handler = new Context(defaults, appName, "light", "000000000000000000000000");
        DBParams codeParams = new DBParams(handler).condition(new Document("name", (Object)"app.jar"));
        ModCode code = (ModCode)DataRider.ride(ModCode.class).get(codeParams);
        DBParams fileParams = new DBParams(handler).condition(new Document("_id", (Object)new ObjectId(code.getSource())));
        ModFile file = (ModFile)DataRider.ride(ModFile.class).get(fileParams);
        file.setPath(path);
        new File().saveFile(handler, file);
    }

    public static void main(String[] args) {
        Environment.initialize(args);
        CacheManager.INSTANCE.setUp(Environment.instance().getAppName());
        ConfigManager.INSTANCE.setUp();
        new Push().pull(args[0]);
    }
}

