/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light;

import io.vertx.core.http.HttpServerRequest;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.bson.Document;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;
import org.jtwig.environment.Environment;
import org.jtwig.environment.EnvironmentConfiguration;
import org.jtwig.environment.EnvironmentConfigurationBuilder;
import org.jtwig.environment.EnvironmentFactory;
import org.jtwig.environment.and.AndJtwigParserConfigurationBuilder;
import org.jtwig.environment.and.AndRenderConfigurationBuilder;
import org.jtwig.environment.and.AndResourceConfigurationBuilder;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;
import org.jtwig.parser.config.AndSyntaxConfigurationBuilder;
import org.jtwig.resource.reference.ResourceReference;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Helper {
    public static final SimpleDateFormat ISO_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static Model getPOM(String path) {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            return reader.read((Reader)new FileReader(path));
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toUTCString(Date date) {
        return ISO_FORMATTER.format(date);
    }

    public static Date fromUTCString(String date) {
        try {
            return ISO_FORMATTER.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date fromSupportedString(String date, TimeZone timeZone) throws Exception {
        LinkedHashMap<Pattern, BiFunction<String, TimeZone, Date>> patternFormatMap = new LinkedHashMap<Pattern, BiFunction<String, TimeZone, Date>>(){
            {
                this.put(Pattern.compile("^\\d{4}/\\d{2}/\\d{2}$"), (s, tz) -> {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                    format.setTimeZone((TimeZone)tz);
                    try {
                        return format.parse((String)s);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.put(Pattern.compile("^\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}$"), (s, tz) -> {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    format.setTimeZone((TimeZone)tz);
                    try {
                        return format.parse((String)s);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.put(Pattern.compile("^\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}\\.\\d{3}$"), (s, tz) -> {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
                    format.setTimeZone((TimeZone)tz);
                    try {
                        return format.parse((String)s);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        };
        for (Map.Entry entry : ((HashMap)patternFormatMap).entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(date).find()) continue;
            return (Date)((BiFunction)entry.getValue()).apply(date, timeZone);
        }
        throw new RuntimeException("time format is unsupported");
    }

    public static String getContentType(InputStream stream) {
        Metadata metadata = new Metadata();
        AutoDetectParser parser = new AutoDetectParser();
        try {
            parser.parse(stream, (ContentHandler)new BodyContentHandler(), metadata, new ParseContext());
        }
        catch (IOException | TikaException | SAXException e) {
            return null;
        }
        return metadata.get("Content-Type");
    }

    public static void setEnv(Map<String, String> newEnv) {
        Class<?>[] classes = Collections.class.getDeclaredClasses();
        Map<String, String> env = System.getenv();
        for (Class<?> cl : classes) {
            if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
            try {
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Map map = (Map)field.get(env);
                map.clear();
                map.putAll(newEnv);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setEnv(final String key, final String value) {
        ConcurrentHashMap<String, String> env = new ConcurrentHashMap<String, String>(){
            {
                this.put(key, value);
            }
        };
        Helper.setEnv((Map<String, String>)env);
    }

    public static void setValueByJsonPath(Document source, List<String> path, Object val) {
        Object parent = source;
        for (int i = 0; i < path.size(); ++i) {
            boolean isObjectValue;
            boolean isLast;
            String key = path.get(i);
            boolean bl = isLast = i == path.size() - 1;
            if (isLast) {
                boolean isList;
                boolean bl2 = isList = key.equals("") || NumberUtils.isDigits((String)key);
                if (isList) {
                    ((List)parent).add(val);
                } else {
                    parent.put(key, val);
                }
                return;
            }
            boolean isListValue = path.get(i + 1).equals("") || NumberUtils.isDigits((String)path.get(i + 1));
            boolean bl3 = isObjectValue = !isListValue;
            if (NumberUtils.isDigits((String)key)) {
                if (((List)parent).size() > Integer.parseInt(key)) {
                    parent = ((List)parent).get(Integer.parseInt(key));
                    continue;
                }
                if (isListValue) {
                    ((List)parent).add(new ArrayList());
                }
                if (isObjectValue) {
                    ((List)parent).add(new Document());
                }
                parent = ((List)parent).get(Integer.parseInt(key));
                continue;
            }
            if (parent.containsKey((Object)key)) {
                parent = parent.get((Object)key);
                continue;
            }
            if (isListValue) {
                parent.put(key, new ArrayList());
            }
            if (isObjectValue) {
                parent.put(key, (Object)new Document());
            }
            parent = parent.get((Object)key);
        }
    }

    public static boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdeDebug() {
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        boolean isDebug = false;
        for (String arg : args) {
            if (!arg.startsWith("-Xrunjdwp") && !arg.startsWith("-agentlib:jdwp")) continue;
            isDebug = true;
            break;
        }
        return isDebug;
    }

    public static boolean isBrowser(HttpServerRequest request) {
        String ua = request.getHeader("user-agent");
        return ua != null && ua.toLowerCase().matches("mozilla.*");
    }

    public static Document unParam(String url) {
        String decoded;
        Pattern pattern = Pattern.compile("\\[([^\\]]*)\\]");
        try {
            if (!url.contains("?")) {
                return new Document();
            }
            url = url.substring(url.indexOf("?") + 1);
            decoded = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Document json = new Document();
        Arrays.stream(decoded.split("&")).forEach(keyVal -> {
            String[] splitted = keyVal.split("=");
            String key = splitted[0];
            String val = splitted.length > 1 ? splitted[1] : "";
            ArrayList<String> path = new ArrayList<String>();
            path.add(key.indexOf("[") > 0 ? key.substring(0, key.indexOf("[")) : key);
            Matcher m = pattern.matcher(key);
            while (m.find()) {
                path.add(m.group(1));
            }
            Helper.setValueByJsonPath(json, path, val);
        });
        return json;
    }

    public static String loadTemplate(String name, Map<String, Object> model, List<SimpleJtwigFunction> function) {
        EnvironmentConfiguration configuration = ((AndJtwigParserConfigurationBuilder)((AndSyntaxConfigurationBuilder)((AndSyntaxConfigurationBuilder)((AndSyntaxConfigurationBuilder)((AndSyntaxConfigurationBuilder)((AndSyntaxConfigurationBuilder)((AndSyntaxConfigurationBuilder)((EnvironmentConfigurationBuilder)((AndResourceConfigurationBuilder)((AndRenderConfigurationBuilder)EnvironmentConfigurationBuilder.configuration().render().withOutputCharset(Charset.forName("UTF-8"))).and().resources().withDefaultInputCharset(Charset.forName("UTF-8"))).and().functions().add(function).and()).parser().syntax().withStartCode("<%~")).withEndCode("%>")).withStartOutput("<%=")).withEndOutput("%>")).withStartComment("<#")).withEndComment("#>")).and()).and().build();
        Environment environment = new EnvironmentFactory().create(configuration);
        ResourceReference resource = new ResourceReference("classpath", name);
        return new JtwigTemplate(environment, resource).render(JtwigModel.newModel(model));
    }

    static {
        ISO_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class MapFunction
    extends SimpleJtwigFunction {
        private String name;
        Function<List<Object>, Map<String, String>> function;

        public MapFunction(String name, Function<List<Object>, Map<String, String>> function) {
            this.name = name;
            this.function = function;
        }

        public String name() {
            return this.name;
        }

        public Object execute(FunctionRequest request) {
            return this.function.apply(request.getArguments());
        }
    }

    public static class ListFunction
    extends SimpleJtwigFunction {
        private String name;
        Function<List<Object>, List<String>> function;

        public ListFunction(String name, Function<List<Object>, List<String>> function) {
            this.name = name;
            this.function = function;
        }

        public String name() {
            return this.name;
        }

        public Object execute(FunctionRequest request) {
            return this.function.apply(request.getArguments());
        }
    }

    public static class StringFunction
    extends SimpleJtwigFunction {
        private String name;
        Function<List<Object>, String> function;

        public StringFunction(String name, Function<List<Object>, String> function) {
            this.name = name;
            this.function = function;
        }

        public String name() {
            return this.name;
        }

        public Object execute(FunctionRequest request) {
            return this.function.apply(request.getArguments());
        }
    }
}

