/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light;

import cn.alphabets.light.ConfigFile;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.yaml.snakeyaml.Yaml;

public class Environment {
    private static final Logger logger;
    private static Environment instance;
    public final Args args = new Args();
    public ConfigFile.ConfigApp app;
    public ConfigFile.ConfigMongoDB mongodb;
    public ConfigFile.ConfigMySQL mysql;

    private Environment() {
    }

    public static Environment initialize(String[] args) {
        Environment environment = new Environment();
        environment.args.initArgs(args);
        instance = environment.args.local ? (Environment)new Yaml().loadAs(ClassLoader.getSystemResourceAsStream("config.yml"), Environment.class) : environment;
        return instance;
    }

    public static Environment instance() {
        if (instance == null) {
            instance = (Environment)new Yaml().loadAs(ClassLoader.getSystemResourceAsStream("config.yml"), Environment.class);
        }
        return instance;
    }

    public static Environment instance(String file) {
        if (instance == null) {
            try {
                instance = (Environment)new Yaml().loadAs((InputStream)new FileInputStream(new File(file)), Environment.class);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"The Config file not found.", (Throwable)e);
            }
        }
        return instance;
    }

    public static void clean() {
        instance = null;
    }

    public String getAppName() {
        if (this.args.local) {
            return this.app.getDomain();
        }
        return System.getenv("APPNAME");
    }

    public int getAppPort() {
        if (this.args.local) {
            return this.app.getPort();
        }
        String port = System.getenv("PORT");
        if (port == null) {
            return 7000;
        }
        return Integer.parseInt(port);
    }

    public String getMongoHost() {
        if (this.args.local) {
            return this.mongodb.getHost();
        }
        return System.getenv("LIGHTDB_HOST");
    }

    public String getMongoPort() {
        if (this.args.local) {
            return String.valueOf(this.mongodb.getPort());
        }
        String port = System.getenv("LIGHTDB_PORT");
        if (port == null) {
            return "57017";
        }
        return port;
    }

    public String getMongoUser() {
        if (this.args.local) {
            return this.mongodb.getUser();
        }
        return System.getenv("LIGHTDB_USER");
    }

    public String getMongoPass() {
        if (this.args.local) {
            return this.mongodb.getPass();
        }
        return System.getenv("LIGHTDB_PASS");
    }

    public String getMongoAuth() {
        if (this.args.local) {
            return this.mongodb.getAuth();
        }
        String auth = System.getenv("LIGHTDB_AUTH");
        if (auth == null) {
            return "SCRAM-SHA-1";
        }
        return auth;
    }

    public String getPackages() {
        if (this.args.local) {
            return this.app.getPackages();
        }
        return System.getenv("PACKAGE");
    }

    public String getMySQLHost() {
        if (this.args.local) {
            return this.mysql.getHost();
        }
        return System.getenv("LIGHTDB_HOST");
    }

    public String getMySQLPort() {
        if (this.args.local) {
            return String.valueOf(this.mysql.getPort());
        }
        return System.getenv("LIGHTMYSQL_PORT");
    }

    static {
        System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.SLF4JLogDelegateFactory");
        System.setProperty("vertx.disableFileCaching", "true");
        logger = LoggerFactory.getLogger(Environment.class);
    }

    public static class Args {
        public boolean local;
        public boolean push;
        public boolean dump;
        public boolean restore;
        public boolean generate;

        public void initArgs(String[] args) {
            List<String> list = Arrays.asList(args);
            this.local = list.contains("-local");
            this.push = list.contains("-push");
            this.dump = list.contains("-dump");
            this.restore = list.contains("-restore");
            this.generate = list.contains("-generate");
        }
    }
}

