/*
 * Decompiled with CFR 0.152.
 */
package cn.alphabets.light;

import cn.alphabets.light.Environment;
import cn.alphabets.light.Helper;
import cn.alphabets.light.Push;
import cn.alphabets.light.cache.CacheManager;
import cn.alphabets.light.config.ConfigManager;
import cn.alphabets.light.http.AuthHandler;
import cn.alphabets.light.http.CSRFHandler;
import cn.alphabets.light.http.Dispatcher;
import cn.alphabets.light.http.TimeoutHandler;
import cn.alphabets.light.http.session.MongoSessionStoreImpl;
import cn.alphabets.light.http.session.SessionHandlerImpl;
import cn.alphabets.light.job.JobManager;
import cn.alphabets.light.model.Generator;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.handler.LoggerFormat;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.ResponseTimeHandler;
import io.vertx.ext.web.handler.StaticHandler;

public class App {
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    private Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions());
    private HttpServer server;
    private Router router = Router.router((Vertx)this.vertx);

    public App() {
        this.server = this.vertx.createHttpServer();
    }

    public void start() {
        Environment env = Environment.instance();
        CacheManager.INSTANCE.setUp(env.getAppName());
        ConfigManager.INSTANCE.setUp();
        if (env.args.generate) {
            this.generate();
            return;
        }
        if (env.args.push) {
            this.push();
            return;
        }
        if (!Helper.isIdeDebug()) {
            this.router.route().handler((Handler)TimeoutHandler.create(ConfigManager.INSTANCE.getAppTimeout() * 1000L));
        }
        this.router.route().handler((Handler)LoggerHandler.create((LoggerFormat)LoggerFormat.SHORT));
        this.router.route("/static/*").handler((Handler)StaticHandler.create().setWebRoot("static").setMaxAgeSeconds(34560000L));
        this.router.route().handler((Handler)FaviconHandler.create((String)"static/favicon.ico"));
        this.router.route().handler((Handler)CookieHandler.create());
        long sessionTimeout = 3600000L * ConfigManager.INSTANCE.getAppSessionTimeout();
        this.router.route().handler((Handler)SessionHandlerImpl.create(new MongoSessionStoreImpl(env.getAppName(), this.vertx)).setNagHttps(false).setSessionTimeout(sessionTimeout));
        this.router.route().handler((Handler)CSRFHandler.create(ConfigManager.INSTANCE.getString("app.hmackey")).setTimeout(sessionTimeout));
        this.router.route().handler((Handler)BodyHandler.create());
        if (!Helper.isJUnitTest()) {
            this.router.route().handler((Handler)AuthHandler.create());
        }
        this.router.route().handler((Handler)ResponseTimeHandler.create());
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.routeProcessAPI(this.router);
        dispatcher.routeDataAPI(this.router);
        dispatcher.routeView(this.router);
        this.server.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0)).listen(env.getAppPort());
        JobManager.start();
        logger.info((Object)String.format("Running on http://%s:%s/", "127.0.0.1", env.getAppPort()));
    }

    private void generate() {
        String pkg = Environment.instance().getPackages() + ".entity";
        new Generator(pkg).generate();
        logger.info((Object)"Generation done");
    }

    private void push() {
        new Push().exec();
    }
}

