/*
 * Decompiled with CFR 0.152.
 */
package cn.akeparking.api.ydto.handler;

import cn.akeparking.api.ydto.common.SyncFuture;
import cn.akeparking.api.ydto.core.ClientAsynResponseHandler;
import cn.akeparking.api.ydto.core.ClientServiceRequestHandler;
import cn.akeparking.api.ydto.core.NettyClient;
import cn.akeparking.api.ydto.dto.ResponseBody;
import cn.akeparking.api.ydto.dto.ThirdParkingMessage;
import cn.akeparking.api.ydto.exception.ServiceException;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHandler
extends SimpleChannelInboundHandler {
    private static Logger logger = LoggerFactory.getLogger(ServiceHandler.class);
    private ClientServiceRequestHandler requestHandler;
    private ClientAsynResponseHandler responseHandler;
    private ExecutorService serviceThreadPool = Executors.newCachedThreadPool();

    public ServiceHandler(ClientServiceRequestHandler requestHandler, ClientAsynResponseHandler responseHandler) {
        this.requestHandler = requestHandler;
        this.responseHandler = responseHandler;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        final ThirdParkingMessage message = (ThirdParkingMessage)msg;
        final ChannelHandlerContext _ctx = ctx;
        this.serviceThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceHandler.this.dispatcher(message, _ctx);
                }
                catch (Exception e) {
                    logger.error("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u5904\u7406\u53d1\u751f\u9519\u8bef", (Throwable)e);
                }
            }
        });
    }

    private void dispatcher(ThirdParkingMessage message, ChannelHandlerContext ctx) throws Exception {
        byte msgType = message.getHeader().getMsgType();
        if (0 == msgType) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u670d\u52a1\u7aef\u8bf7\u6c42:msgId:{},cmd:{},body:{}", new Object[]{message.getHeader().getMsgId(), message.getHeader().getCmd(), message.getBody()});
            }
            try {
                ResponseBody responseBody = this.requestHandler.onMessage(message.getHeader().getCmd(), message.getBody());
                ctx.writeAndFlush((Object)message.buildResp(responseBody));
                return;
            }
            catch (Exception e) {
                if (e instanceof ServiceException) {
                    ServiceException e1 = (ServiceException)e;
                    logger.warn("\u7b2c\u4e09\u65b9\u8f66\u573a\u4e1a\u52a1\u5f02\u5e38:{}", (Object)e1.getMessage());
                    ThirdParkingMessage resMessage = message.buildResp(ResponseBody.createFailureResult(e1.getMessage(), e1.getResultCode()));
                    ctx.writeAndFlush((Object)resMessage);
                }
                logger.error("\u7b2c\u4e09\u65b9\u8f66\u573a\u5904\u7406\u7cfb\u7edf\u7e41\u5fd9", (Throwable)e);
                ThirdParkingMessage resMessage = message.buildResp(ResponseBody.createExceptionResult("\u7b2c\u4e09\u65b9\u8f66\u573a\u7cfb\u7edf\u7e41\u5fd9", e));
                ctx.writeAndFlush((Object)resMessage);
            }
        }
        if (1 == msgType) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u670d\u52a1\u7aef\u54cd\u5e94:msgId:{},cmd:{},body:{}", new Object[]{message.getHeader().getMsgId(), message.getHeader().getCmd(), message.getBody()});
            }
            if (!"login".equals(message.getHeader().getCmd())) {
                if (message.getHeader().getAsyc() == 1) {
                    this.responseHandler.onMessage(message.getHeader().getCmd(), message.getHeader().getMsgId(), (ResponseBody)JSONObject.parseObject((String)message.getBody(), ResponseBody.class));
                } else {
                    SyncFuture<ThirdParkingMessage, ThirdParkingMessage> future = NettyClient.syncFutureMap.get(message.getHeader().getMsgId());
                    if (future != null) {
                        future.setResponse(message);
                    }
                }
            }
        }
    }
}

