/*
 * Decompiled with CFR 0.152.
 */
package cn.akeparking.api.ydto.handler;

import cn.akeparking.api.ydto.core.ConnectorAddress;
import cn.akeparking.api.ydto.core.ConnectorConfig;
import cn.akeparking.api.ydto.core.ConnectorStatus;
import cn.akeparking.api.ydto.core.NettyClient;
import cn.akeparking.api.ydto.dto.ResponseBody;
import cn.akeparking.api.ydto.dto.ThirdParkingMessage;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginAuthReqHandler
extends SimpleChannelInboundHandler {
    private static Logger logger = LoggerFactory.getLogger(LoginAuthReqHandler.class);
    private ConnectorConfig config;
    private ConnectorStatus connectorStatus;
    private ConnectorAddress connectorAddress;

    public LoginAuthReqHandler(ConnectorConfig config, ConnectorStatus connectorStatus, ConnectorAddress connectorAddress) {
        this.config = config;
        this.connectorStatus = connectorStatus;
        this.connectorAddress = connectorAddress;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.info("\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u670d\u52a1\u5668\u6210\u529f..");
        JSONObject requestBody = new JSONObject();
        requestBody.put("username", (Object)this.config.getUsername());
        requestBody.put("parkCodes", (Object)this.config.getParkCodeArray());
        requestBody.put("password", (Object)this.config.getPassword());
        requestBody.put("parkSystemName", (Object)this.config.getParkSystemName());
        requestBody.put("parkSystemVersion", (Object)this.config.getParkSystemVersion());
        requestBody.put("connectorAddress", (Object)this.connectorAddress);
        ThirdParkingMessage message = ThirdParkingMessage.buildReq("login", requestBody.toJSONString());
        logger.info("\u8f66\u573a\u5ba2\u6237\u7aef:\u6b63\u5728\u767b\u5f55\u670d\u52a1\u5668..");
        ctx.writeAndFlush((Object)message);
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        NettyClient.setLastReceiveTime(new Date());
        ThirdParkingMessage message = (ThirdParkingMessage)msg;
        byte msgType = message.getHeader().getMsgType();
        String cmd = message.getHeader().getCmd();
        if (1 == msgType && "login".equals(cmd)) {
            ResponseBody responseBody = (ResponseBody)JSONObject.parseObject((String)message.getBody(), ResponseBody.class);
            if (!responseBody.ok()) {
                logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u767b\u5f55\u670d\u52a1\u5668\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f\uff1a" + responseBody.getMessage());
                this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u767b\u5f55\u670d\u52a1\u5668\u5931\u8d25\uff0c" + responseBody.getMessage());
                ctx.close();
                return;
            }
            this.connectorStatus.connectSuccess();
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        NettyClient.setLastReceiveTime(null);
        if (cause instanceof IOException) {
            this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25,\u7f51\u7edc\u5f02\u5e38");
        } else {
            this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25");
        }
        ctx.fireExceptionCaught(cause);
    }
}

