/*
 * Decompiled with CFR 0.152.
 */
package cn.akeparking.api.ydto.handler;

import cn.akeparking.api.ydto.dto.ResponseBody;
import cn.akeparking.api.ydto.dto.ThirdParkingMessage;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatHandler
extends SimpleChannelInboundHandler {
    private static Logger logger = LoggerFactory.getLogger(HeartBeatHandler.class);
    private volatile ScheduledFuture<?> heartBeat;

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        ThirdParkingMessage message = (ThirdParkingMessage)msg;
        byte msgType = message.getHeader().getMsgType();
        String cmd = message.getHeader().getCmd();
        if (1 == msgType && "login".equals(cmd)) {
            ResponseBody responseBody = (ResponseBody)JSONObject.parseObject((String)message.getBody(), ResponseBody.class);
            if (responseBody.ok()) {
                logger.info("\u8f66\u573a\u5ba2\u6237\u7aef:\u767b\u5f55\u670d\u52a1\u5668\u6210\u529f!");
                if (this.heartBeat != null) {
                    this.heartBeat.cancel(true);
                }
                this.heartBeat = ctx.executor().scheduleAtFixedRate((Runnable)new HeartBeatTask(ctx), 0L, 30000L, TimeUnit.MILLISECONDS);
                return;
            }
        } else if (1 == msgType && "heartbeat".equals(cmd)) {
            logger.debug("\u8f66\u573a\u5ba2\u6237\u7aef:receive heartBeat response.");
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.debug("\u5ba2\u6237\u7aef\u53d1\u751f\u9519\u8bef:", cause);
        this.cancelHeartBeatTask();
        ctx.fireExceptionCaught(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.cancelHeartBeatTask();
    }

    private void cancelHeartBeatTask() {
        if (this.heartBeat != null) {
            this.heartBeat.cancel(true);
            this.heartBeat = null;
        }
    }

    private class HeartBeatTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        public HeartBeatTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            ThirdParkingMessage heatBeat = ThirdParkingMessage.buildReq("heartbeat", null);
            logger.debug("\u8f66\u573a\u5ba2\u6237\u7aef:send heartBeat request.");
            this.ctx.writeAndFlush((Object)heatBeat);
        }
    }
}

