/*
 * Decompiled with CFR 0.152.
 */
package cn.akeparking.api.ydto.dto;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;

public class ResponseBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int status;
    private int resultCode;
    private String message;
    private String data;

    private ResponseBody() {
    }

    public boolean ok() {
        return this.status == 1;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    private ResponseBody(int status, String message, Object data) {
        this.status = status;
        this.message = message;
        if (data != null) {
            this.data = data instanceof JSONObject ? data.toString() : JSONObject.toJSONString((Object)data);
        }
    }

    public ResponseBody(int status, int resultCode, String message, Object data) {
        this.status = status;
        this.resultCode = resultCode;
        this.message = message;
        if (data != null) {
            this.data = data instanceof JSONObject ? data.toString() : JSONObject.toJSONString((Object)data);
        }
    }

    public static ResponseBody createFailureResult() {
        return new ResponseBody(2, null, null);
    }

    public static ResponseBody createFailureResult(String message) {
        return new ResponseBody(2, message, null);
    }

    public static ResponseBody createFailureResult(String message, Object data) {
        return new ResponseBody(2, message, data);
    }

    public static ResponseBody createSuccessResult() {
        return new ResponseBody(1, null, null);
    }

    public static ResponseBody createSuccessResult(Object data) {
        return new ResponseBody(1, "OK", data);
    }

    public static ResponseBody createSuccessResult(String message) {
        return new ResponseBody(1, message, null);
    }

    public static ResponseBody createSuccessResult(String message, Object data) {
        return new ResponseBody(1, message, data);
    }

    public static ResponseBody createFailureResult(int resultCode) {
        return new ResponseBody(2, resultCode, null, null);
    }

    public static ResponseBody createFailureResult(String message, int resultCode) {
        return new ResponseBody(2, resultCode, message, null);
    }

    public static ResponseBody createFailureResult(String message, int resultCode, Object data) {
        return new ResponseBody(2, resultCode, message, data);
    }

    public static ResponseBody createExceptionResult(String message, Exception e) {
        return new ResponseBody(3, message, "");
    }

    public static ResponseBody createUnauthorizedResult() {
        return new ResponseBody(5, "\u65e0\u6743\u9650\u64cd\u4f5c", "");
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getData() {
        if (this.data == null) {
            return "";
        }
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toJSONString() {
        return JSONObject.toJSONString((Object)this);
    }
}

