/*
 * Decompiled with CFR 0.152.
 */
package cn.akeparking.api.ydto.core;

import cn.akeparking.api.ydto.codec.ThirdParkingMessageDecoder;
import cn.akeparking.api.ydto.codec.ThirdParkingMessageEncoder;
import cn.akeparking.api.ydto.common.SyncFuture;
import cn.akeparking.api.ydto.core.ClientAsynResponseHandler;
import cn.akeparking.api.ydto.core.ClientServiceRequestHandler;
import cn.akeparking.api.ydto.core.ConnectorAddress;
import cn.akeparking.api.ydto.core.ConnectorConfig;
import cn.akeparking.api.ydto.core.ConnectorStatus;
import cn.akeparking.api.ydto.dto.ThirdParkingMessage;
import cn.akeparking.api.ydto.handler.HeartBeatHandler;
import cn.akeparking.api.ydto.handler.LoginAuthReqHandler;
import cn.akeparking.api.ydto.handler.ServiceHandler;
import cn.akeparking.api.ydto.ssl.SslContextFactory;
import com.alibaba.fastjson.JSONObject;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.ConnectException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient {
    public static Map<String, SyncFuture<ThirdParkingMessage, ThirdParkingMessage>> syncFutureMap = new ConcurrentHashMap<String, SyncFuture<ThirdParkingMessage, ThirdParkingMessage>>();
    private static Logger logger = LoggerFactory.getLogger(NettyClient.class);
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private EventLoopGroup group = new NioEventLoopGroup();
    private Channel channel;
    private ConnectorConfig config;
    private ConnectorAddress currentAddress;
    private ClientServiceRequestHandler requestHandler;
    private ClientAsynResponseHandler responseHandler;
    private boolean refresh = false;
    private ConnectorStatus connectorStatus;
    private boolean isNeedReconnect = true;
    private static Date lastReceiveTime = null;

    public NettyClient(ConnectorConfig config, ClientServiceRequestHandler requestHandler, ClientAsynResponseHandler responseHandler) {
        this.config = config;
        this.currentAddress = config.getMainAddress();
        this.requestHandler = requestHandler;
        this.connectorStatus = new ConnectorStatus(false, "\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u6b63\u5728\u8fde\u63a5...");
        ScheduledExecutorService clearCheckMainAddressService = Executors.newSingleThreadScheduledExecutor();
        CheckMainAddressTimer checkMainAddressTimerTask = new CheckMainAddressTimer();
        clearCheckMainAddressService.scheduleWithFixedDelay(checkMainAddressTimerTask, 30L, 30L, TimeUnit.SECONDS);
    }

    public void refresh() {
        ConnectorAddress mainAddress = this.config.getMainAddress();
        List<ConnectorAddress> standbyAddressList = this.config.getStandbyAddressList();
        logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u6b63\u5728\u4e3a\u4f60\u65ad\u5f00\u540e\u91cd\u8fde,\u5f53\u524d\u914d\u7f6e:{}/{}/{}/{}", new Object[]{mainAddress.toString(), standbyAddressList == null ? null : standbyAddressList.toString(), this.config.getUsername(), this.config.getPassword()});
        this.currentAddress = mainAddress;
        this.refresh = true;
        if (this.channel == null && !this.isNeedReconnect) {
            this.reconnect();
        } else if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    public void refresh(ConnectorConfig config) {
        this.config = config;
        this.refresh();
    }

    public void refresh(int port, String host, String username, String password) {
        this.config.getMainAddress().setHost(host);
        this.config.getMainAddress().setPort(port);
        this.config.setUsername(username);
        this.config.setPassword(password);
        this.refresh();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void connect() {
        block18: {
            try {
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    public void initChannel(SocketChannel ch) throws Exception {
                        SSLContext sslCtx = SslContextFactory.getClientContext();
                        SSLEngine sslEngine = sslCtx.createSSLEngine();
                        sslEngine.setUseClientMode(true);
                        ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
                        ch.pipeline().addLast(new ChannelHandler[]{new ThirdParkingMessageDecoder()});
                        ch.pipeline().addLast(new ChannelHandler[]{new ThirdParkingMessageEncoder()});
                        ch.pipeline().addLast(new ChannelHandler[]{new ReadTimeoutHandler(300)});
                        ch.pipeline().addLast(new ChannelHandler[]{new LoginAuthReqHandler(NettyClient.this.config, NettyClient.this.connectorStatus, NettyClient.this.currentAddress)});
                        ch.pipeline().addLast(new ChannelHandler[]{new HeartBeatHandler()});
                        ch.pipeline().addLast(new ChannelHandler[]{new ServiceHandler(NettyClient.this.requestHandler, NettyClient.this.responseHandler)});
                    }
                });
                ChannelFuture future = b.connect(this.currentAddress.getHost(), this.currentAddress.getPort()).sync();
                this.channel = future.channel();
                this.channel.closeFuture().sync();
                if (this.connectorStatus.isActive()) {
                    this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00");
                }
                if (this.channel == null) break block18;
            }
            catch (Exception e) {
                block19: {
                    try {
                        if (e instanceof ConnectException) {
                            this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u767b\u5f55\u670d\u52a1\u5668\u5931\u8d25,\u7f51\u7edc\u5f02\u5e38");
                        } else if (e instanceof ReadTimeoutException) {
                            this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25,\u5fc3\u8df3\u8d85\u65f6");
                        } else {
                            this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25");
                        }
                        logger.warn(this.connectorStatus.getMessage(), (Throwable)e);
                        if (this.connectorStatus.isActive()) {
                            this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00");
                        }
                        if (this.channel == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (this.connectorStatus.isActive()) {
                            this.connectorStatus.connectFail("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00");
                        }
                        if (this.channel != null) {
                            this.channel.close();
                            this.channel = null;
                        }
                        if (this.isNeedReconnect) {
                            this.executor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (!NettyClient.this.refresh) {
                                            logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c10\u79d2\u540e\u5c1d\u8bd5\u91cd\u8fde..");
                                            TimeUnit.SECONDS.sleep(10L);
                                        } else {
                                            logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u9a6c\u4e0a\u5c1d\u8bd5\u91cd\u8fde..");
                                        }
                                        try {
                                            if (!NettyClient.this.refresh) {
                                                NettyClient.this.changeAddress();
                                            }
                                            NettyClient.this.refresh = false;
                                            logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u6b63\u5728\u5c1d\u8bd5\u8fde\u63a5\u670d\u52a1\u5668...,\u5730\u5740\uff1a{}", (Object)NettyClient.this.currentAddress.toString());
                                            NettyClient.this.connect();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        } else {
                            logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u5c06\u4e0d\u4f1a\u91cd\u8fde\u3002");
                        }
                        throw throwable;
                    }
                    this.channel.close();
                    this.channel = null;
                }
                if (this.isNeedReconnect) {
                    this.executor.execute(new /* invalid duplicate definition of identical inner class */);
                } else {
                    logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u5c06\u4e0d\u4f1a\u91cd\u8fde\u3002");
                }
            }
            this.channel.close();
            this.channel = null;
        }
        if (this.isNeedReconnect) {
            this.executor.execute(new /* invalid duplicate definition of identical inner class */);
        } else {
            logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u5c06\u4e0d\u4f1a\u91cd\u8fde\u3002");
        }
    }

    public void reconnect() {
        if (this.channel != null) {
            logger.warn("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u5df2\u6709\u5b9e\u4f8b\u5728\u8fd0\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u8fde\u63a5\uff01");
            return;
        }
        this.isNeedReconnect = true;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("\u7b2c\u4e09\u65b9\u8f66\u573a\u5ba2\u6237\u7aef:\u6b63\u5728\u5c1d\u8bd5\u8fde\u63a5\u670d\u52a1\u5668...");
                    NettyClient.this.connect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void changeAddress() {
        List<ConnectorAddress> standbyAddressList = this.config.getStandbyAddressList();
        ConnectorAddress mainAddress = this.config.getMainAddress();
        if (standbyAddressList == null || standbyAddressList.size() == 0) {
            return;
        }
        if (this.currentAddress.equals(mainAddress)) {
            this.currentAddress = standbyAddressList.get(0);
        } else {
            for (int i = 0; i < standbyAddressList.size(); ++i) {
                ConnectorAddress address = standbyAddressList.get(i);
                if (!address.equals(this.currentAddress)) continue;
                this.currentAddress = i == standbyAddressList.size() - 1 ? mainAddress : standbyAddressList.get(i + 1);
            }
        }
    }

    public ConnectorAddress getCurrentAddress() {
        return this.currentAddress;
    }

    public ConnectorStatus getConnectorStatus() {
        return this.connectorStatus;
    }

    public void disconnect() {
        this.isNeedReconnect = false;
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    public static Date getLastReceiveTime() {
        return lastReceiveTime;
    }

    public static void setLastReceiveTime(Date lastReceiveTime) {
        NettyClient.lastReceiveTime = lastReceiveTime;
    }

    private boolean isMainCanConnected() {
        ConnectorAddress mainAddress = this.config.getMainAddress();
        return this.isCanConnect(mainAddress.getHost(), mainAddress.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanConnect(String host, int port) {
        NioEventLoopGroup group = new NioEventLoopGroup();
        final CheckAddressCanConnectedHanlder canConnectedHanlder = new CheckAddressCanConnectedHanlder();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ThirdParkingMessageDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new ThirdParkingMessageEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{canConnectedHanlder});
                }
            });
            b.connect(host, port).channel().closeFuture().await(3L, TimeUnit.SECONDS);
            ThirdParkingMessage message = canConnectedHanlder.getMessage();
            if (message != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            group.shutdownGracefully();
        }
        return false;
    }

    private class CheckMainAddressTimer
    implements Runnable {
        private CheckMainAddressTimer() {
        }

        @Override
        public void run() {
            try {
                ConnectorAddress mainAddress = NettyClient.this.config.getMainAddress();
                if (!NettyClient.this.currentAddress.equals(mainAddress) && NettyClient.this.isNeedReconnect) {
                    boolean isMainCanConnected = NettyClient.this.isMainCanConnected();
                    logger.info("\u68c0\u6d4b\u4e3b\u7ebf\u8def\u662f\u5426\u901a\u7545\uff0c\u4e3b\u7ebf\u8def\u5730\u5740:{},\u72b6\u6001:{}", (Object)mainAddress, (Object)isMainCanConnected);
                    if (isMainCanConnected) {
                        NettyClient.this.currentAddress = mainAddress;
                        NettyClient.this.refresh();
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u6267\u884c\u68c0\u6d4b\u4e3b\u7ebf\u8def\u51fa\u9519");
            }
        }
    }

    private class CheckAddressCanConnectedHanlder
    extends SimpleChannelInboundHandler {
        private ThirdParkingMessage message;

        private CheckAddressCanConnectedHanlder() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            JSONObject requestBody = new JSONObject();
            requestBody.put("username", (Object)NettyClient.this.config.getUsername());
            requestBody.put("password", (Object)NettyClient.this.config.getPassword());
            ThirdParkingMessage message = ThirdParkingMessage.buildReq("login", requestBody.toJSONString());
            ctx.writeAndFlush((Object)message);
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.message = (ThirdParkingMessage)msg;
            ctx.close();
        }

        public ThirdParkingMessage getMessage() {
            return this.message;
        }

        public void setMessage(ThirdParkingMessage message) {
            this.message = message;
        }
    }
}

