/*
 * Decompiled with CFR 0.152.
 */
package cn.akeparking.api.ydto.core;

import cn.akeparking.api.ydto.common.SyncFuture;
import cn.akeparking.api.ydto.core.ClientAsynResponseHandler;
import cn.akeparking.api.ydto.core.ClientServiceRequestHandler;
import cn.akeparking.api.ydto.core.ConnectorAddress;
import cn.akeparking.api.ydto.core.ConnectorConfig;
import cn.akeparking.api.ydto.core.ConnectorStatus;
import cn.akeparking.api.ydto.core.NettyClient;
import cn.akeparking.api.ydto.dto.ResponseBody;
import cn.akeparking.api.ydto.dto.ThirdParkingMessage;
import cn.akeparking.api.ydto.exception.ClientInitException;
import cn.akeparking.api.ydto.exception.ConnectException;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.Channel;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Connector {
    private static NettyClient nettyClient;

    public static void init(String host, int port, String username, String password, String parkSystemName, String parkSystemVersion, ClientServiceRequestHandler requestHandler, ClientAsynResponseHandler responseHandler) {
        ConnectorConfig config = new ConnectorConfig();
        ConnectorAddress mainAddress = new ConnectorAddress(0, host, port);
        mainAddress.setIsMain(true);
        config.setMainAddress(mainAddress);
        config.setUsername(username);
        config.setPassword(password);
        config.setParkSystemVersion(parkSystemVersion);
        config.setParkSystemName(parkSystemName);
        Connector.init(config, requestHandler, responseHandler);
    }

    public static void init(ConnectorConfig config, ClientServiceRequestHandler requestHandler, ClientAsynResponseHandler responseHandler) {
        if (config.getMainAddress() == null) {
            throw new ClientInitException("mainAddress\u4e0d\u80fd\u4e3a\u7a7a");
        }
        config.getMainAddress().setIsMain(true);
        String parkSystemVersion = config.getParkSystemVersion();
        if (parkSystemVersion == null || "".equals(parkSystemVersion)) {
            throw new ClientInitException("parkSystemVersion\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String parkSystemName = config.getParkSystemName();
        if (parkSystemName == null || "".equals(parkSystemName)) {
            throw new ClientInitException("parkSystemName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (requestHandler == null) {
            throw new ClientInitException("requestHandler\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (nettyClient != null) {
            throw new ClientInitException("\u4e00\u70b9\u505c\u6570\u636e\u8fde\u63a5\u5ba2\u6237\u7aef\u5df2\u7ecf\u5728\u4f60\u7684\u9879\u76ee\u4e2d\u88ab\u521d\u59cb\u5316\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521d\u59cb\u5316");
        }
        nettyClient = new NettyClient(config, requestHandler, responseHandler);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                nettyClient.connect();
            }
        };
        new Thread(runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseBody send(String cmd, String requestBody, int timeout, TimeUnit timeUnit) {
        if (nettyClient.getChannel() == null) {
            throw new ConnectException("\u8fde\u63a5\u5df2\u65ad\u5f00");
        }
        ThirdParkingMessage message = ThirdParkingMessage.buildReq(cmd, requestBody);
        SyncFuture future = new SyncFuture();
        NettyClient.syncFutureMap.put(message.getHeader().getMsgId(), future);
        nettyClient.getChannel().writeAndFlush((Object)message);
        try {
            ResponseBody responseBody;
            ThirdParkingMessage resMessage = (ThirdParkingMessage)future.get(timeout, timeUnit);
            if (resMessage == null) {
                throw new ConnectException("\u540c\u6b65\u8bf7\u6c42\u8d85\u65f6");
            }
            ResponseBody responseBody2 = responseBody = (ResponseBody)JSONObject.parseObject((String)resMessage.getBody(), ResponseBody.class);
            return responseBody2;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ResponseBody responseBody = null;
            return responseBody;
        }
        finally {
            NettyClient.syncFutureMap.remove(message.getHeader().getMsgId());
        }
    }

    public static ResponseBody send(String cmd, String requestBody) {
        return Connector.send(cmd, requestBody, 10, TimeUnit.SECONDS);
    }

    public static ResponseBody send(String cmd, Object requestBody) {
        return Connector.send(cmd, JSONObject.toJSONString((Object)requestBody));
    }

    public static ResponseBody send(String cmd, Object requestBody, int timeout, TimeUnit timeUnit) {
        return Connector.send(cmd, JSONObject.toJSONString((Object)requestBody), timeout, timeUnit);
    }

    public static void sendAsyn(String msgId, String cmd, String requestBody) {
        ThirdParkingMessage message = ThirdParkingMessage.buildAsycReq(msgId, cmd, requestBody);
        nettyClient.getChannel().writeAndFlush((Object)message);
    }

    public static boolean isConfigured() {
        return nettyClient != null;
    }

    public static ConnectorAddress getCurrentAdrress() {
        return nettyClient.getCurrentAddress();
    }

    public static ConnectorStatus getConnectorStatus() {
        return nettyClient.getConnectorStatus();
    }

    public static boolean isCanConnect(String host, int port) {
        return nettyClient.isCanConnect(host, port);
    }

    public static void disconnect() {
        nettyClient.disconnect();
    }

    private static Channel getChannel() {
        return nettyClient.getChannel();
    }

    public static boolean isWritable() {
        if (Connector.getChannel() == null) {
            return false;
        }
        return Connector.getChannel().isWritable();
    }

    public static Long lastReceiveMilliseconds() {
        if (NettyClient.getLastReceiveTime() == null) {
            return null;
        }
        Date now = new Date();
        return now.getTime() - NettyClient.getLastReceiveTime().getTime();
    }

    public static void refresh(String host, int port, String account, String password) {
        nettyClient.refresh(port, host, account, password);
    }

    public static void refresh(ConnectorConfig config) {
        nettyClient.refresh(config);
    }

    public static void refresh() {
        nettyClient.refresh();
    }
}

