/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.util;

import com.nlf.util.ContentTypes;
import com.nlf.util.IOUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class HttpClient {
    public static final String BOUNDARY = "*****";

    private HttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String encode) throws IOException {
        String string;
        HttpURLConnection conn = null;
        Closeable out = null;
        BufferedReader in = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("GET");
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), encode));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(out);
            IOUtil.closeQuietly(in);
            if (null != conn) {
                conn.disconnect();
            }
            throw throwable;
        }
        IOUtil.closeQuietly(out);
        IOUtil.closeQuietly((Closeable)in);
        if (null != conn) {
            conn.disconnect();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String data) throws IOException {
        String string;
        HttpURLConnection conn = null;
        OutputStream out = null;
        BufferedReader in = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            out = conn.getOutputStream();
            out.write(data.getBytes("utf-8"));
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(out);
            IOUtil.closeQuietly(in);
            if (null != conn) {
                conn.disconnect();
            }
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)out);
        IOUtil.closeQuietly((Closeable)in);
        if (null != conn) {
            conn.disconnect();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String url, File file) throws IOException {
        String string;
        HttpURLConnection conn = null;
        DataOutputStream out = null;
        BufferedReader in = null;
        FileInputStream fin = null;
        try {
            String fileName = file.getName();
            String suffix = fileName.substring(0, fileName.lastIndexOf(".") + 1);
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
            out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes("--*****\r\n");
            out.writeBytes("Content-Disposition:form-data;name=\"upload\";filename=\"" + fileName + "\";filelength=" + file.length() + ";Content-Type=\"" + ContentTypes.getContentType((String)suffix) + "\"\r\n");
            out.writeBytes("\r\n");
            fin = new FileInputStream(file);
            byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
            int count = 0;
            while (-1 != (count = fin.read(buffer))) {
                out.write(buffer, 0, count);
            }
            out.writeBytes("\r\n");
            out.writeBytes("--*****--\r\n");
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(fin);
            IOUtil.closeQuietly(out);
            IOUtil.closeQuietly(in);
            if (null != conn) {
                conn.disconnect();
            }
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)fin);
        IOUtil.closeQuietly((Closeable)out);
        IOUtil.closeQuietly((Closeable)in);
        if (null != conn) {
            conn.disconnect();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, File file) throws IOException {
        URLConnection conn = null;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            conn = new URL(url).openConnection();
            in = conn.getInputStream();
            out = new FileOutputStream(file);
            byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
            int count = 0;
            while (-1 != (count = in.read(buffer))) {
                out.write(buffer, 0, count);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(out);
            IOUtil.closeQuietly(in);
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)out);
        IOUtil.closeQuietly((Closeable)in);
    }
}

