/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.user;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.user.bean.UserInfo;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;

public class UserHelper {
    public static final String LANG_ZH_CN = "zh_CN";
    public static final String LANG_ZH_TW = "zh_TW";
    public static final String LANG_EN = "en";

    protected UserHelper() {
    }

    public static UserInfo getUser(String accessToken, String openid, String lang) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.user_info", (Object[])new Object[]{accessToken, openid, lang});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            UserInfo u = new UserInfo();
            u.setSubscribe(o.getInt("subscribe", 0));
            u.setOpenid(o.getString("openid"));
            u.setNickname(o.getString("nickname"));
            u.setSex(o.getInt("sex", 0));
            u.setProvince(o.getString("province"));
            u.setCity(o.getString("city"));
            u.setCountry(o.getString("country"));
            u.setLanguage(o.getString("language"));
            u.setHeadimgurl(o.getString("headimgurl"));
            u.setSubscribeTime(o.getLong("subscribe_time", 0L));
            u.setUnionid(o.getString("unionid"));
            return u;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

