/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.sns;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.sns.bean.AccessToken;
import com.nlf.extend.wechat.sns.bean.UserInfo;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;
import java.util.List;

public class SNSHelper {
    protected SNSHelper() {
    }

    private static AccessToken getTokenByUrl(String url) throws WeixinException {
        try {
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            AccessToken token = new AccessToken();
            token.setCreateTime(System.currentTimeMillis());
            token.setToken(o.getString("access_token"));
            token.setExpiresIn(o.getInt("expires_in", 7200));
            token.setRefreshToken(o.getString("refresh_token"));
            token.setOpenid(o.getString("openid"));
            token.setScope(o.getString("scope"));
            return token;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static AccessToken getAccessToken(String appid, String secret, String code) throws WeixinException {
        String url = App.getProperty((String)"nlf.weixin.url.sns.access_token", (Object[])new Object[]{appid, secret, code});
        return SNSHelper.getTokenByUrl(url);
    }

    public static AccessToken freshAccessToken(String appid, String refreshToken) throws WeixinException {
        String url = App.getProperty((String)"nlf.weixin.url.sns.refresh_token", (Object[])new Object[]{appid, refreshToken});
        return SNSHelper.getTokenByUrl(url);
    }

    public static void checkAccessToken(String accessToken, String openid) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.sns.auth", (Object[])new Object[]{accessToken, openid});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static UserInfo getUser(String accessToken, String openid) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.sns.user_info", (Object[])new Object[]{accessToken, openid});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            UserInfo u = new UserInfo();
            u.setOpenid(o.getString("openid"));
            u.setNickname(o.getString("nickname"));
            u.setSex(o.getInt("sex", 0));
            u.setProvince(o.getString("province"));
            u.setCity(o.getString("city"));
            u.setCountry(o.getString("country"));
            u.setHeadimgurl(o.getString("headimgurl"));
            List ps = (List)o.get("privilege");
            if (null != ps) {
                for (String p : ps) {
                    u.addPrivilege(p);
                }
            }
            u.setUnionid(o.getString("unionid"));
            return u;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

