/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.qrcode;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.qrcode.bean.QrCodeRequest;
import com.nlf.extend.wechat.qrcode.bean.QrCodeResponse;
import com.nlf.extend.wechat.qrcode.type.QrCodeType;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;

public class QrCodeHelper {
    private QrCodeHelper() {
    }

    public static QrCodeResponse createQrCode(QrCodeRequest request, String accessToken) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.qrcode_create", (Object[])new Object[]{accessToken});
            Bean dataBean = new Bean();
            dataBean.set("action_name", (Object)request.getType().toString());
            dataBean.set("action_info", (Object)new Bean().set("scene", (Object)new Bean().set("scene_id", (Object)request.getSceneId())));
            if (QrCodeType.QR_SCENE == request.getType()) {
                dataBean.set("expire_seconds", (Object)request.getExpireIn());
            }
            String data = JSON.fromObject((Object)dataBean);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.send", (Object[])new Object[]{data}));
            String result = HttpsClient.post(url, data);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            QrCodeResponse response = new QrCodeResponse();
            response.setExpireIn(o.getInt("expire_seconds", 1800));
            response.setTicket(o.getString("ticket"));
            response.setUrl(o.getString("url"));
            return response;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static String showQrCode(String ticket) {
        return App.getProperty((String)"nlf.weixin.url.qrcode_show", (Object[])new Object[]{ticket});
    }
}

