/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.pay.core.impl;

import com.nlf.App;
import com.nlf.core.IRequest;
import com.nlf.extend.web.IWebRequest;
import com.nlf.extend.wechat.pay.bean.PayNotifyRequest;
import com.nlf.extend.wechat.pay.core.IPayNotifyController;
import com.nlf.extend.wechat.pay.core.IPayNotifyHandler;
import com.nlf.extend.wechat.pay.core.IPayNotifyResolver;
import com.nlf.extend.wechat.pay.core.impl.DefaultPayNotifyResolver;
import com.nlf.log.Logger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;

public class DefaultPayNotifyController
implements IPayNotifyController {
    protected IPayNotifyResolver resolver;

    public DefaultPayNotifyController() {
        this(new DefaultPayNotifyResolver());
    }

    public DefaultPayNotifyController(IPayNotifyResolver resolver) {
        this.resolver = resolver;
    }

    public String handle(IPayNotifyHandler handler) {
        try {
            IRequest r = App.getRequest();
            HttpServletRequest or = ((IWebRequest)r).getServletRequest();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)or.getInputStream(), "utf-8"));
            StringBuilder s = new StringBuilder();
            String line = "";
            while (null != (line = br.readLine())) {
                s.append(line);
            }
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.request", (Object[])new Object[]{s}));
            PayNotifyRequest req = this.resolver.decode(s.toString());
            String responseStr = this.resolver.encode(handler.onHandle(req));
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.response", (Object[])new Object[]{responseStr}));
            return responseStr;
        }
        catch (Throwable e) {
            Logger.getLog().error(App.getProperty((String)"nlf.weixin.error", (Object[])new Object[0]), e);
            return "";
        }
    }
}

