/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.pay;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.serialize.xml.XML;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.pay.bean.RefundRequest;
import com.nlf.extend.wechat.pay.bean.RefundResponse;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;
import com.nlf.util.Md5Util;
import com.nlf.util.StringUtil;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.TreeMap;

public class RefundHelper {
    protected RefundHelper() {
    }

    public static String sign(RefundRequest refundRequest, String paySecret) throws NoSuchAlgorithmException {
        Bean o = (Bean)JSON.toBean((String)JSON.fromObject((Object)refundRequest));
        o.remove("sign");
        TreeMap<Object, String> map = new TreeMap<Object, String>();
        for (Object key : o.keySet()) {
            String value = o.getString((String)key, "");
            if (value.length() <= 0) continue;
            map.put(key, o.getString((String)key));
        }
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            sb.append(key);
            sb.append("=");
            sb.append((String)map.get(key));
            sb.append("&");
        }
        sb.append("key=");
        sb.append(paySecret);
        String s = sb.toString();
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.sign_data", (Object[])new Object[]{s}));
        s = Md5Util.encode((String)s, (String)"utf-8");
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.sign_result", (Object[])new Object[]{s}));
        return s;
    }

    public static RefundResponse refund(RefundRequest refundRequest, File certFile) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.pay_refund", (Object[])new Object[0]);
            Bean bean = (Bean)JSON.toBean((String)JSON.fromObject((Object)refundRequest));
            ArrayList<String> args = new ArrayList<String>();
            for (String key : bean.keySet()) {
                if (bean.getString(key, "").length() >= 1) continue;
                args.add(key);
            }
            for (String k : args) {
                bean.remove(k);
            }
            String data = XML.fromObject((Object)bean);
            data = StringUtil.right((String)data, (String)">");
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.send", (Object[])new Object[]{data}));
            String result = HttpsClient.post(certFile, refundRequest.getMch_id(), url, data);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)XML.toBean((String)result);
            RefundResponse r = new RefundResponse();
            r.setAppid(o.getString("appid"));
            r.setCoupon_refund_fee(o.getInt("coupon_refund_fee", 0));
            r.setDevice_info(o.getString("device_info"));
            r.setErr_code(o.getString("err_code"));
            r.setErr_code_des(o.getString("err_code_des"));
            r.setMch_id(o.getString("mch_id"));
            r.setNonce_str(o.getString("nonce_str"));
            r.setOut_refund_no(o.getString("out_refund_no"));
            r.setOut_trade_no(o.getString("out_trade_no"));
            r.setRefund_channel(o.getString("refund_channel"));
            r.setRefund_fee(o.getInt("refund_fee", 0));
            r.setRefund_id(o.getString("refund_id"));
            r.setResult_code(o.getString("result_code"));
            r.setReturn_code(o.getString("return_code"));
            r.setReturn_msg(o.getString("return_msg"));
            r.setSign(o.getString("sign"));
            r.setTransaction_id(o.getString("transaction_id"));
            return r;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

