/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.pay;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.serialize.xml.XML;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.pay.bean.PayNotifyRequest;
import com.nlf.extend.wechat.pay.bean.PrePayResult;
import com.nlf.extend.wechat.pay.bean.UnifiedOrder;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;
import com.nlf.util.Md5Util;
import com.nlf.util.StringUtil;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeMap;

public class PayHelper {
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";

    protected PayHelper() {
    }

    public static String genTimestamp() {
        return System.currentTimeMillis() / 1000L + "";
    }

    public static String genNonceStr() {
        int l = CHARS.length();
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(l);
            sb.append(CHARS.charAt(number));
        }
        return sb.toString();
    }

    public static String signPayNotify(PayNotifyRequest request, String secret) throws NoSuchAlgorithmException {
        Bean o = (Bean)JSON.toBean((String)JSON.fromObject((Object)request));
        o.remove("sign");
        TreeMap<Object, String> map = new TreeMap<Object, String>();
        for (Object key : o.keySet()) {
            String value = o.getString((String)key, "");
            if (value.length() <= 0) continue;
            map.put(key, o.getString((String)key));
        }
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            sb.append(key);
            sb.append("=");
            sb.append((String)map.get(key));
            sb.append("&");
        }
        sb.append("key=");
        sb.append(secret);
        String s = sb.toString();
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.sign_data", (Object[])new Object[]{s}));
        s = Md5Util.encode((String)s, (String)"utf-8");
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.sign_result", (Object[])new Object[]{s}));
        return s;
    }

    public static String sign(UnifiedOrder order, String secret) throws NoSuchAlgorithmException {
        Bean o = (Bean)JSON.toBean((String)JSON.fromObject((Object)order));
        o.remove("sign");
        TreeMap<Object, String> map = new TreeMap<Object, String>();
        for (Object key : o.keySet()) {
            String value = o.getString((String)key, "");
            if (value.length() <= 0) continue;
            map.put(key, o.getString((String)key));
        }
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            sb.append(key);
            sb.append("=");
            sb.append((String)map.get(key));
            sb.append("&");
        }
        sb.append("key=");
        sb.append(secret);
        String s = sb.toString();
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.sign_data", (Object[])new Object[]{s}));
        s = Md5Util.encode((String)s, (String)"utf-8");
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.sign_result", (Object[])new Object[]{s}));
        return s;
    }

    public static PrePayResult prePay(UnifiedOrder signedOrder) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.pay_unifiedorder", (Object[])new Object[0]);
            Bean bean = (Bean)JSON.toBean((String)JSON.fromObject((Object)signedOrder));
            ArrayList<String> args = new ArrayList<String>();
            for (String key : bean.keySet()) {
                if (bean.getString(key, "").length() >= 1) continue;
                args.add(key);
            }
            for (String k : args) {
                bean.remove(k);
            }
            String data = XML.fromObject((Object)bean);
            data = StringUtil.right((String)data, (String)">");
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.send", (Object[])new Object[]{data}));
            String result = HttpsClient.post(url, data);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)XML.toBean((String)result);
            PrePayResult r = new PrePayResult();
            r.setReturn_code(o.getString("return_code"));
            r.setReturn_msg(o.getString("return_msg"));
            if ("SUCCESS".equals(r.getReturn_code())) {
                r.setAppid(o.getString("appid"));
                r.setMch_id(o.getString("mch_id"));
                r.setDevice_info(o.getString("device_info"));
                r.setNonce_str(o.getString("nonce_str"));
                r.setSign(o.getString("sign"));
                r.setResult_code(o.getString("result_code"));
                r.setErr_code(o.getString("err_code"));
                r.setErr_code_des(o.getString("err_code_des"));
                if ("SUCCESS".equals(r.getResult_code())) {
                    r.setTrade_type(o.getString("trade_type"));
                    r.setPrepay_id(o.getString("prepay_id"));
                    r.setCode_url(o.getString("code_url"));
                }
            }
            return r;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

