/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.msg.core.impl;

import com.nlf.App;
import com.nlf.core.IRequest;
import com.nlf.extend.web.IWebRequest;
import com.nlf.extend.wechat.msg.bean.IEventMsg;
import com.nlf.extend.wechat.msg.bean.IRequestMsg;
import com.nlf.extend.wechat.msg.bean.IResponseMsg;
import com.nlf.extend.wechat.msg.bean.impl.ClickEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.ImageMsg;
import com.nlf.extend.wechat.msg.bean.impl.KfCloseSessionEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.KfCreateSessionEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.KfSwitchSessionEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.LinkMsg;
import com.nlf.extend.wechat.msg.bean.impl.LocationEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.LocationMsg;
import com.nlf.extend.wechat.msg.bean.impl.ScanEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.SubscribeEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.TemplateSendJobFinishEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.TextMsg;
import com.nlf.extend.wechat.msg.bean.impl.UnSubscribeEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.VideoMsg;
import com.nlf.extend.wechat.msg.bean.impl.ViewEventMsg;
import com.nlf.extend.wechat.msg.bean.impl.VoiceMsg;
import com.nlf.extend.wechat.msg.core.IMsgController;
import com.nlf.extend.wechat.msg.core.IMsgHandler;
import com.nlf.extend.wechat.msg.core.IMsgResolver;
import com.nlf.extend.wechat.msg.core.impl.DefaultMsgResolver;
import com.nlf.log.Logger;
import com.nlf.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

public class DefaultMsgController
implements IMsgController {
    protected String token;
    protected IMsgResolver resolver;

    public DefaultMsgController(String token) {
        this(token, new DefaultMsgResolver());
    }

    public DefaultMsgController(String token, IMsgResolver resolver) {
        this.token = token;
        this.resolver = resolver;
    }

    private String sha1(String s) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(s.getBytes());
        byte[] b = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            hex = (hex.length() == 1 ? "0" : "") + hex;
            sb.append(hex);
        }
        return sb.toString();
    }

    private boolean check() throws NoSuchAlgorithmException {
        IRequest r = App.getRequest();
        String signature = r.get("signature");
        String timestamp = r.get("timestamp");
        String nonce = r.get("nonce");
        if (signature.length() < 1) {
            return false;
        }
        if (timestamp.length() < 1) {
            return false;
        }
        if (nonce.length() < 1) {
            return false;
        }
        Object[] a = new String[]{this.token, timestamp, nonce};
        Arrays.sort(a);
        return signature.equals(this.sha1(StringUtil.join((String[])a, (String)"")));
    }

    protected String onGet() throws NoSuchAlgorithmException {
        IRequest r = App.getRequest();
        String echostr = r.get("echostr");
        if (echostr.length() < 1) {
            return "";
        }
        return this.check() ? echostr : "";
    }

    protected String onPost(IMsgHandler handler) throws NoSuchAlgorithmException, IOException {
        if (null != this.token && this.token.length() > 0 && !this.check()) {
            return "";
        }
        IRequest r = App.getRequest();
        HttpServletRequest or = ((IWebRequest)r).getServletRequest();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)or.getInputStream(), "utf-8"));
        StringBuilder s = new StringBuilder();
        String line = "";
        while (null != (line = br.readLine())) {
            s.append(line);
        }
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.request", (Object[])new Object[]{s}));
        if (null == handler) {
            return "";
        }
        IRequestMsg msg = this.resolver.decode(s.toString());
        if (null == msg) {
            return "";
        }
        IResponseMsg responseMsg = null;
        block0 : switch (msg.getMsgType()) {
            case event: {
                IEventMsg em = (IEventMsg)msg;
                switch (em.getEventType()) {
                    case CLICK: {
                        responseMsg = handler.onClick((ClickEventMsg)em);
                        break block0;
                    }
                    case LOCATION: {
                        responseMsg = handler.onLocation((LocationEventMsg)em);
                        break block0;
                    }
                    case SCAN: {
                        responseMsg = handler.onScan((ScanEventMsg)em);
                        break block0;
                    }
                    case subscribe: {
                        responseMsg = handler.onSubscribe((SubscribeEventMsg)em);
                        break block0;
                    }
                    case unsubscribe: {
                        responseMsg = handler.onUnSubscribe((UnSubscribeEventMsg)em);
                        break block0;
                    }
                    case VIEW: {
                        responseMsg = handler.onView((ViewEventMsg)em);
                        break block0;
                    }
                    case TEMPLATESENDJOBFINISH: {
                        responseMsg = handler.onTemplateSendJobFinish((TemplateSendJobFinishEventMsg)em);
                        break block0;
                    }
                    case kf_create_session: {
                        responseMsg = handler.onKfCreateSession((KfCreateSessionEventMsg)em);
                        break block0;
                    }
                    case kf_close_session: {
                        responseMsg = handler.onKfCloseSession((KfCloseSessionEventMsg)em);
                        break block0;
                    }
                    case kf_switch_session: {
                        responseMsg = handler.onKfSwitchSession((KfSwitchSessionEventMsg)em);
                        break block0;
                    }
                }
                break;
            }
            case text: {
                responseMsg = handler.onText((TextMsg)msg);
                break;
            }
            case image: {
                responseMsg = handler.onImage((ImageMsg)msg);
                break;
            }
            case voice: {
                responseMsg = handler.onVoice((VoiceMsg)msg);
                break;
            }
            case video: {
                responseMsg = handler.onVideo((VideoMsg)msg);
                break;
            }
            case location: {
                responseMsg = handler.onLocation((LocationMsg)msg);
                break;
            }
            case link: {
                responseMsg = handler.onLink((LinkMsg)msg);
                break;
            }
        }
        String responseStr = this.resolver.encode(responseMsg);
        Logger.getLog().debug(App.getProperty((String)"nlf.weixin.response", (Object[])new Object[]{responseStr}));
        return responseStr;
    }

    public String handle(IMsgHandler handler) {
        try {
            IRequest r = App.getRequest();
            HttpServletRequest or = ((IWebRequest)r).getServletRequest();
            String method = or.getMethod();
            if ("GET".equalsIgnoreCase(method)) {
                return this.onGet();
            }
            if ("POST".equals(method)) {
                return this.onPost(handler);
            }
        }
        catch (Throwable e) {
            Logger.getLog().error(App.getProperty((String)"nlf.weixin.error", (Object[])new Object[0]), e);
        }
        return "";
    }
}

