/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.message;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.message.bean.Message;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;

public class MessageHelper {
    protected MessageHelper() {
    }

    public static String send(String accessToken, Message message) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.message_template_send", (Object[])new Object[]{accessToken});
            Bean b = new Bean();
            b.set("touser", (Object)message.getToUser());
            b.set("template_id", (Object)message.getTemplateId());
            b.set("url", (Object)message.getUrl());
            b.set("topcolor", (Object)message.getTopColor());
            Bean d = new Bean();
            d.set("first", (Object)message.getFirst());
            for (String key : message.getDatas().keySet()) {
                d.set(key, (Object)message.getDatas().get(key));
            }
            d.set("remark", (Object)message.getRemark());
            b.set("data", (Object)d);
            String data = JSON.fromObject((Object)b);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.send", (Object[])new Object[]{data}));
            String result = HttpsClient.post(url, data);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg") + " template_id=" + o.getString("template_id"));
            }
            return o.getString("msgid");
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

