/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.menu;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.menu.bean.MenuButton;
import com.nlf.extend.wechat.menu.type.MenuButtonType;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuHelper {
    protected MenuHelper() {
    }

    public static void createMenu(List<MenuButton> buttons, String accessToken) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.menu_create", (Object[])new Object[]{accessToken});
            List btns = (List)JSON.toBean((String)JSON.fromObject(buttons));
            for (Bean btn : btns) {
                List subs;
                if (!MenuButtonType.view.toString().equals(btn.getString("type"))) {
                    btn.remove("url");
                }
                if ((subs = (List)btn.get("subs")).size() > 0) {
                    for (Bean sub : subs) {
                        if (!MenuButtonType.view.toString().equals(sub.getString("type"))) {
                            sub.remove("url");
                        }
                        sub.remove("subs");
                    }
                    btn.set("sub_button", (Object)subs);
                }
                btn.remove("subs");
            }
            Bean dataBean = new Bean().set("button", (Object)btns);
            String data = JSON.fromObject((Object)dataBean);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.send", (Object[])new Object[]{data}));
            String result = HttpsClient.post(url, data);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static void deleteMenu(String accessToken) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.menu_delete", (Object[])new Object[]{accessToken});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static List<MenuButton> getMenu(String accessToken) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.menu_get", (Object[])new Object[]{accessToken});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            o = (Bean)o.get("menu");
            List btns = (List)o.get("button");
            ArrayList<MenuButton> l = new ArrayList<MenuButton>(btns.size());
            for (Bean btn : btns) {
                MenuButton b = new MenuButton();
                b.setKey(btn.getString("key"));
                b.setName(btn.getString("name"));
                b.setType(MenuButtonType.valueOf(btn.getString("type")));
                b.setUrl(btn.getString("url"));
                List subs = (List)btn.get("sub_button");
                if (null == subs) continue;
                for (Bean sub : subs) {
                    MenuButton sb = new MenuButton();
                    sb.setKey(sub.getString("key"));
                    sb.setName(sub.getString("name"));
                    sb.setType(MenuButtonType.valueOf(sub.getString("type")));
                    sb.setUrl(sub.getString("url"));
                    b.addSub(sb);
                }
            }
            return l;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

