/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.media;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.media.MediaType;
import com.nlf.extend.wechat.media.bean.Media;
import com.nlf.extend.wechat.util.HttpClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;
import java.io.File;

public class MediaHelper {
    protected MediaHelper() {
    }

    public static Media upload(File file, String accessToken, MediaType type) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.media_upload", (Object[])new Object[]{accessToken, type});
            String result = HttpClient.upload(url, file);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            Media media = new Media();
            media.setMediaId(o.getString("media_id"));
            media.setType(MediaType.valueOf(o.getString("type")));
            media.setCreatedAt(o.getString("created_at"));
            return media;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static void download(String accessToken, String mediaId, File file) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.media_get", (Object[])new Object[]{accessToken, mediaId});
            HttpClient.download(url, file);
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

