/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.js;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.js.bean.Ticket;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;

public class TicketHelper {
    protected TicketHelper() {
    }

    public static Ticket getTicket4JsApi(String accessToken) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.jsapi_ticket", (Object[])new Object[]{accessToken});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            Ticket ticket = new Ticket();
            ticket.setTicket(o.getString("ticket"));
            ticket.setExpiresIn(o.getInt("expires_in", 7200));
            ticket.setCreateTime(System.currentTimeMillis());
            return ticket;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }
}

