/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.wechat.base;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.wechat.base.bean.AccessToken;
import com.nlf.extend.wechat.exception.WeixinException;
import com.nlf.extend.wechat.util.HttpsClient;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseHelper {
    private BaseHelper() {
    }

    public static synchronized AccessToken getAccessToken(String appid, String secret) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.access_token", (Object[])new Object[]{appid, secret});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            AccessToken token = new AccessToken();
            token.setCreateTime(System.currentTimeMillis());
            token.setToken(o.getString("access_token"));
            token.setExpiresIn(o.getInt("expires_in", 7200));
            return token;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static List<String> getServerIps(String accessToken) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.get_server_ips", (Object[])new Object[]{accessToken});
            String result = HttpsClient.get(url);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            List l = (List)o.get("ip_list");
            return l;
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static String shortUrl(String accessToken, String longUrl) throws WeixinException {
        try {
            String url = App.getProperty((String)"nlf.weixin.url.shorturl", (Object[])new Object[]{accessToken});
            Bean dataBean = new Bean();
            dataBean.set("action", (Object)"long2short");
            dataBean.set("long_url", (Object)longUrl);
            String data = JSON.fromObject((Object)dataBean);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.send", (Object[])new Object[]{data}));
            String result = HttpsClient.post(url, data);
            Logger.getLog().debug(App.getProperty((String)"nlf.weixin.recv", (Object[])new Object[]{result}));
            Bean o = (Bean)JSON.toBean((String)result);
            int errorCode = o.getInt("errcode", 0);
            if (0 != errorCode) {
                throw new WeixinException(errorCode, o.getString("errmsg"));
            }
            return o.getString("short_url");
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException(e);
        }
    }

    public static String sha1(String s) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(s.getBytes());
        byte[] b = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            hex = (hex.length() == 1 ? "0" : "") + hex;
            sb.append(hex);
        }
        return sb.toString();
    }
}

