/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.session.web.impl;

import com.nlf.App;
import com.nlf.extend.session.web.AbstractHttpSessionProvider;
import javax.servlet.http.Cookie;

public class CookieSessionIdProvider
extends AbstractHttpSessionProvider {
    public static final String DEFAULT_ID_NAME = "SESSIONID";
    public static String ID_NAME = App.getPropertyString((String)"session.id.provider.cookie.name", (String)"SESSIONID");

    public String read() {
        String sessionId = null;
        for (Cookie cookie : this.request.getCookies()) {
            String name = cookie.getName();
            if (!ID_NAME.equals(name)) continue;
            sessionId = cookie.getValue();
        }
        return sessionId;
    }

    public void write(String sessionId) {
        if (null != sessionId) {
            String existSessionId = null;
            for (Cookie cookie : this.request.getCookies()) {
                String name = cookie.getName();
                if (!ID_NAME.equals(name)) continue;
                existSessionId = cookie.getValue();
            }
            if (!sessionId.equals(existSessionId)) {
                Cookie cookie = new Cookie(ID_NAME, sessionId);
                cookie.setPath("/");
                this.response.addCookie(cookie);
            }
        }
    }
}

