/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.socket.impl;

import com.nlf.core.UploadFile;
import com.nlf.extend.rpc.socket.AbstractSocketRpcFileUploader;
import com.nlf.util.IOUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

public class DefaultSocketRpcFileUploader
extends AbstractSocketRpcFileUploader {
    public UploadFile parseFile(String fileName, long fileSize, DataInputStream in) throws IOException {
        UploadFile file = new UploadFile();
        file.setName(fileName);
        String suffix = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "";
        file.setSuffix(suffix);
        file.setSize(fileSize);
        if (fileSize <= (long)IOUtil.BUFFER_SIZE) {
            file.setType(0);
            byte[] buffer = new byte[(int)fileSize];
            in.readFully(buffer);
            file.setBytes(buffer);
        } else {
            long rest;
            file.setType(1);
            StringBuilder prefix = new StringBuilder();
            prefix.append(fileName);
            while (prefix.length() < 2) {
                prefix.append("_");
            }
            prefix.append("_");
            if (suffix.length() > 0) {
                suffix = "." + suffix;
            }
            File temp = File.createTempFile(prefix.toString(), suffix);
            byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
            for (rest = fileSize; rest > (long)IOUtil.BUFFER_SIZE; rest -= (long)IOUtil.BUFFER_SIZE) {
                in.readFully(buffer);
                IOUtil.writeFile((File)temp, (byte[])buffer, (boolean)true);
            }
            buffer = new byte[(int)rest];
            in.readFully(buffer);
            IOUtil.writeFile((File)temp, (byte[])buffer, (boolean)true);
            file.setTempFile(temp);
        }
        this.files.add(file);
        return file;
    }
}

