/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.socket.impl;

import com.nlf.View;
import com.nlf.extend.rpc.server.impl.socket.AbstractSocketRpcResponse;
import com.nlf.extend.web.view.StreamView;
import com.nlf.util.DateUtil;
import com.nlf.util.IOUtil;
import com.nlf.util.InputStreamCache;
import com.nlf.view.JsonView;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class DefaultSocketRpcResponse
extends AbstractSocketRpcResponse {
    public void send(Object o) throws IOException {
        if (null == o) {
            return;
        }
        if (o instanceof StreamView) {
            this.sendStream((StreamView)o);
        } else if (o instanceof RuntimeException) {
            this.send(View.json((Object)((RuntimeException)o).getMessage()).setSuccess(false));
        } else if (o instanceof Throwable) {
            this.send(View.json((Object)((Throwable)o).getMessage()).setSuccess(false));
        } else if (o instanceof Number || o instanceof Boolean || o instanceof Character || o instanceof String) {
            this.send(View.json((Object)o));
        } else if (o instanceof JsonView) {
            this.sendString(o + "");
        } else if (o instanceof Date) {
            this.send(View.json((Object)DateUtil.ymdhms((Date)((Date)o))));
        }
    }

    public void sendString(String s) throws IOException {
        this.sendString(s, "application/json");
    }

    public void sendString(String s, String contentType) throws IOException {
        DataOutputStream os = new DataOutputStream(this.socket.getOutputStream());
        os.writeUTF("nrpc");
        os.writeShort(8);
        os.writeUTF(s);
        os.writeShort(0);
    }

    public void sendStream(InputStream inputStream) throws IOException {
        int n;
        InputStreamCache cache = new InputStreamCache(inputStream);
        InputStream in = cache.getInputStream();
        DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
        out.writeUTF("nrpc");
        out.writeShort(5);
        out.writeUTF("unknown");
        out.writeShort(6);
        out.writeLong(cache.getSize());
        byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.writeShort(0);
    }

    public void sendStream(InputStream in, String name, long size) throws IOException {
        int n;
        DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
        out.writeUTF("nrpc");
        out.writeShort(5);
        out.writeUTF(name);
        out.writeShort(6);
        out.writeLong(size);
        byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.writeShort(0);
    }

    public void sendStream(StreamView streamView) throws IOException {
        this.sendStream(streamView.getInputStream(), streamView.getName(), streamView.getSize());
    }
}

