/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.http.impl;

import com.nlf.App;
import com.nlf.core.Client;
import com.nlf.core.IFileUploader;
import com.nlf.core.ISession;
import com.nlf.core.UploadFile;
import com.nlf.extend.rpc.server.impl.http.AbstractHttpRpcRequest;
import com.nlf.extend.rpc.server.impl.http.IHttpRpcFileUploader;
import com.nlf.log.Logger;
import com.nlf.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpRpcRequest
extends AbstractHttpRpcRequest {
    protected String getIP() {
        String r = this.exchange.getRemoteAddress().getAddress().getHostAddress();
        block0: for (String k : this.exchange.getRequestHeaders().keySet()) {
            String[] stringArray = PROXY_HEADER;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String p;
                String s = stringArray[i];
                if (!s.equalsIgnoreCase(k) || null == (p = this.exchange.getRequestHeaders().getFirst(k)) || p.length() <= 0 || "unknown".equalsIgnoreCase(p)) continue;
                r = p;
                break block0;
            }
        }
        if (null != r) {
            if (r.contains(",")) {
                String[] rs;
                for (String s : rs = r.split(",")) {
                    if (s.length() <= 0 || "unknown".equalsIgnoreCase(s)) continue;
                    r = s;
                    break;
                }
            }
            if ("0:0:0:0:0:0:0:1".equals(r)) {
                r = "127.0.0.1";
            }
        }
        return null == r ? "" : r;
    }

    @Override
    public void init() {
        try {
            this.initParam();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String contentType = this.exchange.getRequestHeaders().getFirst("Content-Type");
        if (null != contentType && contentType.contains("multipart/form-data")) {
            IFileUploader uploader = (IFileUploader)App.getProxy().newInstance(IHttpRpcFileUploader.class.getName());
            List files = uploader.getFiles();
            this.param.set("uploadFiles", (Object)files);
        }
        this.initPaging();
    }

    protected Map<String, Object> parseQuery(String s) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        if (null != s) {
            List l = StringUtil.list((String)s, (String)"&");
            for (String kv : l) {
                if (!kv.contains("=")) continue;
                String key = StringUtil.left((String)kv, (String)"=");
                String value = StringUtil.right((String)kv, (String)"=");
                if (params.containsKey(key)) {
                    ArrayList<String> vs;
                    Object v = params.get(key);
                    if (v instanceof String) {
                        vs = new ArrayList<String>();
                        vs.add((String)v);
                        vs.add(value);
                        params.put(key, vs);
                        continue;
                    }
                    vs = (ArrayList<String>)v;
                    vs.add(value);
                    params.put(key, vs);
                    continue;
                }
                params.put(key, value);
            }
        }
        return params;
    }

    protected Map<String, Object> parseParams() throws IOException {
        Map<String, Object> params = this.parseQuery(this.exchange.getRequestURI().getRawQuery());
        String reqMethod = this.exchange.getRequestMethod();
        if ("POST".equalsIgnoreCase(reqMethod)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream()));
            Map<String, Object> postParams = this.parseQuery(reader.readLine());
            for (Map.Entry<String, Object> entry : postParams.entrySet()) {
                params.put(entry.getKey(), entry.getValue());
            }
        }
        return params;
    }

    protected void initParam() throws IOException {
        Map<String, Object> params = this.parseParams();
        for (String key : params.keySet()) {
            Object v = params.get(key);
            String value = null;
            String[] values = null;
            if (v instanceof String) {
                value = (String)v;
            } else {
                List vs = (List)v;
                values = new String[vs.size()];
                vs.toArray(values);
            }
            if (null == value) {
                value = "";
            }
            if (null == values) {
                values = new String[]{};
            }
            try {
                value = URLDecoder.decode(value, "utf-8");
                int j = values.length;
                for (int i = 0; i < j; ++i) {
                    values[i] = URLDecoder.decode(values[i], "utf-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLog().warn(App.getProperty((String)"nlf.web.request.parameter.decode_failed", (Object[])new Object[]{key}));
            }
            this.param.set(key, (Object)value);
            if (values.length <= 1) continue;
            this.param.set(key, (Object)values);
        }
    }

    protected void initPaging() {
        int pageNumber = this.param.getInt("pageNumber", this.pageNumber);
        int pageSize = this.param.getInt("pageSize", this.pageSize);
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
    }

    public Client getClient() {
        if (null == this.client) {
            this.client = new Client();
            this.client.setIp(this.getIP());
            String al = this.exchange.getRequestHeaders().getFirst("Accept-Language");
            if (null == al) {
                this.client.setLocale(Locale.getDefault());
            } else {
                String language = StringUtil.left((String)al, (String)"-");
                String country = StringUtil.right((String)al, (String)"-");
                if (2 != country.length()) {
                    this.client.setLocale(new Locale(language));
                } else {
                    this.client.setLocale(new Locale(language, country));
                }
            }
        }
        return this.client;
    }

    public ISession getSession(boolean autoCreate) {
        return null;
    }

    public List<UploadFile> getFiles() {
        List files = (List)this.param.get("uploadFiles");
        return null == files ? new ArrayList(0) : files;
    }
}

