/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.http.impl;

import com.nlf.App;
import com.nlf.core.IRequest;
import com.nlf.core.UploadFile;
import com.nlf.exception.ValidateException;
import com.nlf.extend.rpc.server.impl.http.IHttpRpcFileUploader;
import com.nlf.extend.rpc.server.impl.http.IHttpRpcRequest;
import com.nlf.util.ByteArray;
import com.nlf.util.FileUtil;
import com.nlf.util.IOUtil;
import com.nlf.util.StringUtil;
import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpRpcFileUploader
implements IHttpRpcFileUploader {
    public static final String CHARSET = "utf-8";
    public static final String KEY_TAG = " name=\"";
    public static final String FILE_TAG = "filename=\"";
    public static final String BOUNDARY_TAG = "boundary=";
    public static final String MULTIPART_TAG = "multipart/form-data";
    protected FormItem formItem;

    protected byte[] getBoundary(String contentType) {
        if (null == contentType) {
            return null;
        }
        if (!contentType.contains(MULTIPART_TAG)) {
            return null;
        }
        if (!contentType.contains(BOUNDARY_TAG)) {
            return null;
        }
        return ("\r\n--" + StringUtil.right((String)contentType, (String)BOUNDARY_TAG)).getBytes();
    }

    protected void append(byte[] boundary, ByteArray cache) throws IOException {
        int lb;
        if (null == this.formItem) {
            return;
        }
        int size = cache.size();
        if (size > (lb = boundary.length)) {
            int lr = size - lb;
            this.appendFile(cache.sub(0, lr).toArray());
            cache.removeHead(lr);
        }
    }

    protected void appendFile(byte[] data) throws IOException {
        if (null == this.formItem) {
            return;
        }
        File tempFile = this.formItem.getTempFile();
        if (null == tempFile) {
            UploadFile file = this.formItem.getFile();
            String fileName = file.getName();
            String suffix = file.getSuffix();
            if (fileName.contains(".")) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            while (fileName.length() < 2) {
                fileName = fileName + "_";
            }
            fileName = fileName + "_";
            if (suffix.length() > 0) {
                suffix = "." + suffix;
            }
            tempFile = File.createTempFile(fileName, suffix);
            this.formItem.setTempFile(tempFile);
        }
        IOUtil.writeFile((File)tempFile, (byte[])data, (boolean)true);
    }

    protected void parseItem(byte[] boundary, ByteArray cache, List<UploadFile> files) throws IOException {
        if (null == this.formItem) {
            int index = cache.indexOf(new byte[]{13, 10, 13, 10});
            while (index > -1) {
                String header = new String(cache.sub(0, index).toArray(), CHARSET);
                if (header.contains(FILE_TAG)) {
                    String fileName = StringUtil.between((String)header, (String)FILE_TAG, (String)"\"");
                    if (fileName.length() > 0) {
                        this.formItem = new FormItem();
                        UploadFile file = new UploadFile();
                        file.setName(fileName);
                        file.setSuffix(fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "");
                        if (header.contains(KEY_TAG)) {
                            String key = StringUtil.between((String)header, (String)KEY_TAG, (String)"\"");
                            file.setKey(key);
                        }
                        if (header.contains("Content-Type:")) {
                            file.setContentType(StringUtil.right((String)header, (String)":").trim());
                        }
                        this.formItem.setFile(file);
                    }
                } else if (header.contains(KEY_TAG)) {
                    this.formItem = new FormItem();
                    String key = StringUtil.between((String)header, (String)KEY_TAG, (String)"\"");
                    this.formItem.setKey(key);
                }
                cache.removeHead(index + 4);
                int endIndex = cache.indexOf(boundary);
                if (endIndex > -1) {
                    byte[] data = cache.sub(0, endIndex).toArray();
                    if (null != this.formItem) {
                        UploadFile file = this.formItem.getFile();
                        String key = this.formItem.getKey();
                        if (null != file) {
                            file.setBytes(data);
                            file.setType(0);
                            file.setSize((long)data.length);
                            files.add(file);
                        } else if (null != key) {
                            IRequest r = App.getRequest();
                            r.getParam().set(key, (Object)new String(data, CHARSET));
                        }
                    }
                    this.formItem = null;
                    cache.removeHead(endIndex);
                }
                index = cache.indexOf(new byte[]{13, 10, 13, 10});
            }
            this.append(boundary, cache);
        } else {
            int endIndex = cache.indexOf(boundary);
            if (endIndex > -1) {
                this.appendFile(cache.sub(0, endIndex).toArray());
                File tempFile = this.formItem.getTempFile();
                if (null != this.formItem) {
                    UploadFile file = this.formItem.getFile();
                    String key = this.formItem.getKey();
                    if (null != file) {
                        file.setTempFile(tempFile);
                        file.setType(1);
                        file.setSize(tempFile.length());
                        files.add(file);
                    } else if (null != key) {
                        IRequest r = App.getRequest();
                        r.getParam().set(key, (Object)FileUtil.readAsText((File)tempFile));
                    }
                }
                this.formItem = null;
                cache.removeHead(endIndex);
            } else {
                this.append(boundary, cache);
            }
        }
    }

    public List<UploadFile> getFiles() throws ValidateException {
        ArrayList<UploadFile> files = new ArrayList<UploadFile>();
        IHttpRpcRequest r = (IHttpRpcRequest)App.getRequest();
        HttpExchange req = r.getHttpExchange();
        byte[] boundary = this.getBoundary(req.getRequestHeaders().getFirst("Content-Type"));
        if (null == boundary) {
            return files;
        }
        ByteArray cache = new ByteArray();
        byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
        try {
            int l;
            InputStream reader = r.getInputStream();
            while (-1 != (l = reader.read(buffer))) {
                byte[] tmp = new byte[l];
                System.arraycopy(buffer, 0, tmp, 0, l);
                cache.append(tmp);
                this.parseItem(boundary, cache, files);
            }
            this.parseItem(boundary, cache, files);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    private static final class FormItem {
        private String key;
        private File tempFile;
        private UploadFile file;

        private FormItem() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public File getTempFile() {
            return this.tempFile;
        }

        public void setTempFile(File tempFile) {
            this.tempFile = tempFile;
        }

        public UploadFile getFile() {
            return this.file;
        }

        public void setFile(UploadFile file) {
            this.file = file;
        }
    }
}

