/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.client.impl.socket.impl;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.rpc.client.IRpcResponse;
import com.nlf.extend.rpc.client.impl.DefaultRpcResponse;
import com.nlf.extend.rpc.client.impl.socket.AbstractSocketRpcClient;
import com.nlf.extend.rpc.socket.ISocketRpcFileUploader;
import com.nlf.serialize.json.JSON;
import com.nlf.util.IOUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSocketRpcClient
extends AbstractSocketRpcClient {
    protected ISocketRpcFileUploader uploader = (ISocketRpcFileUploader)App.getProxy().newInstance(ISocketRpcFileUploader.class.getName());

    protected IRpcResponse parseResponse(DataInputStream in) throws IOException {
        String magic = in.readUTF();
        if (!"nrpc".equals(magic)) {
            throw new RuntimeException("magic error");
        }
        DefaultRpcResponse response = new DefaultRpcResponse();
        String fileName = null;
        long fileSize = 0L;
        short type = in.readShort();
        while (type != 0) {
            switch (type) {
                case 8: {
                    Bean data = (Bean)JSON.toBean((String)in.readUTF());
                    if (data.getBoolean("success", false)) {
                        response.setData(data.get("data"));
                        response.setSuccess(true);
                        break;
                    }
                    response.setMessage(data.getString("data"));
                    response.setSuccess(false);
                    break;
                }
                case 5: {
                    fileName = in.readUTF();
                    break;
                }
                case 6: {
                    fileSize = in.readLong();
                    break;
                }
                case 7: {
                    this.uploader.parseFile(fileName, fileSize, in);
                    break;
                }
            }
            type = in.readShort();
        }
        response.setFiles(this.uploader.getFiles());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRpcResponse call(String host, int port, String path, Map<String, String> args, String body, File ... file) {
        IRpcResponse iRpcResponse;
        Socket socket = null;
        DataInputStream in = null;
        DataOutputStream out = null;
        try {
            socket = new Socket(host, port);
            socket.setSoTimeout(0);
            socket.setTcpNoDelay(true);
            in = new DataInputStream(socket.getInputStream());
            out = new DataOutputStream(socket.getOutputStream());
            out.writeUTF("nrpc");
            out.writeShort(1);
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            out.writeUTF(language + "-" + country);
            out.writeShort(2);
            out.writeUTF(path);
            if (null != args) {
                for (Map.Entry<String, String> object : args.entrySet()) {
                    out.writeShort(3);
                    out.writeUTF(object.getKey());
                    out.writeShort(4);
                    out.writeUTF(object.getValue());
                }
            }
            if (null != body && body.length() > 0) {
                out.writeShort(9);
                out.writeUTF(body);
            }
            byte[] buffer = null;
            if (file.length > 0) {
                buffer = new byte[IOUtil.BUFFER_SIZE];
            }
            for (File f : file) {
                int n;
                out.writeShort(5);
                out.writeUTF(f.getName());
                out.writeShort(6);
                out.writeLong(f.length());
                out.writeShort(7);
                FileInputStream is = new FileInputStream(f);
                while (-1 != (n = ((InputStream)is).read(buffer))) {
                    out.write(buffer, 0, n);
                }
            }
            out.writeShort(0);
            out.flush();
            iRpcResponse = this.parseResponse(in);
        }
        catch (Exception e) {
            DefaultRpcResponse defaultRpcResponse;
            try {
                DefaultRpcResponse response = new DefaultRpcResponse();
                response.setSuccess(false);
                response.setMessage(e.getMessage());
                defaultRpcResponse = response;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                IOUtil.closeQuietly(out);
                IOUtil.closeQuietly((Socket)socket);
                throw throwable;
            }
            IOUtil.closeQuietly((Closeable)in);
            IOUtil.closeQuietly(out);
            IOUtil.closeQuietly((Socket)socket);
            return defaultRpcResponse;
        }
        IOUtil.closeQuietly((Closeable)in);
        IOUtil.closeQuietly((Closeable)out);
        IOUtil.closeQuietly((Socket)socket);
        return iRpcResponse;
    }
}

