/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.http.impl;

import com.nlf.App;
import com.nlf.extend.rpc.server.impl.http.AbstractHttpRpcResponse;
import com.nlf.extend.rpc.server.impl.http.HttpRpcServer;
import com.nlf.extend.web.view.PageView;
import com.nlf.extend.web.view.RedirectView;
import com.nlf.extend.web.view.StreamView;
import com.nlf.util.ContentTypes;
import com.nlf.util.FileUtil;
import com.nlf.util.IOUtil;
import com.nlf.util.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DefaultHttpRpcResponse
extends AbstractHttpRpcResponse {
    public void send(Object o) throws IOException {
        if (null == o) {
            return;
        }
        if (o instanceof RedirectView) {
            this.sendRedirect((RedirectView)o);
        } else if (o instanceof PageView) {
            this.sendPage((PageView)o);
        } else if (o instanceof StreamView) {
            this.sendStream((StreamView)o);
        } else {
            super.send(o);
        }
    }

    public void sendRedirect(RedirectView view) throws IOException {
        this.exchange.getResponseHeaders().add("refresh", "0,url=" + view.getUri());
        this.exchange.sendResponseHeaders(200, 0L);
        OutputStream os = null;
        try {
            os = this.exchange.getResponseBody();
            os.flush();
        }
        finally {
            IOUtil.closeQuietly((Closeable)os);
        }
    }

    public void sendPage(PageView view) throws IOException {
        this.sendResource(view.getUri(), true);
    }

    public void sendString(String s) throws IOException {
        this.sendString(s, "text/plain");
    }

    public void sendString(String s, String contentType) throws IOException {
        if (App.getPropertyBoolean((String)"nlf.rpc.server.http.cors.enable", (boolean)true)) {
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Credentials", App.getPropertyBoolean((String)"nlf.rpc.server.http.cors.allow_credentials", (boolean)true) + "");
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Origin", App.getPropertyString((String)"nlf.rpc.server.http.cors.allow_origin", (String)"*"));
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Methods", App.getPropertyString((String)"nlf.rpc.server.http.cors.allow_methods", (String)"*"));
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Headers", App.getPropertyString((String)"nlf.rpc.server.http.cors.allow_headers", (String)"*"));
            this.exchange.getResponseHeaders().add("Access-Control-Max-Age", App.getPropertyInt((String)"nlf.rpc.server.http.cors.max_age", (int)18000) + "");
        }
        this.responseString(200, contentType, s);
    }

    public void sendStream(StreamView streamView) throws IOException {
        String contentType;
        InputStream inputStream = streamView.getInputStream();
        if (null != streamView.getName()) {
            this.exchange.getResponseHeaders().add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(streamView.getName(), "utf-8"));
        }
        if (null == (contentType = streamView.getContentType()) || contentType.length() < 1) {
            contentType = "application/octet-stream";
        }
        if (streamView.getSize() > -1L) {
            this.exchange.getResponseHeaders().add("Content-Length", streamView.getSize() + "");
        }
        this.sendStream(inputStream, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStream(InputStream inputStream, String contentType) throws IOException {
        this.exchange.getResponseHeaders().add("Content-Type", contentType);
        this.exchange.sendResponseHeaders(200, 0L);
        OutputStream os = null;
        try {
            os = this.exchange.getResponseBody();
            int n = 0;
            byte[] b = new byte[IOUtil.BUFFER_SIZE];
            while ((n = inputStream.read(b)) != -1) {
                os.write(b, 0, n);
            }
            os.flush();
        }
        finally {
            IOUtil.closeQuietly((Closeable)os);
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    public void sendStream(InputStream inputStream) throws IOException {
        this.sendStream(inputStream, "application/octet-stream");
    }

    public void sendResource(String path, boolean dynamic) throws IOException {
        path = path.replaceFirst(HttpRpcServer.contextPath, "");
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        File file = ROOT.length() > 0 ? new File(ROOT, path) : new File(path);
        if (!(file = new File(file.getAbsolutePath())).exists()) {
            this.responseError(404);
        } else if (!file.canRead()) {
            this.responseError(403);
        } else if (file.isDirectory()) {
            if (DIR_ALLOWED) {
                this.responseDirectory(file);
            } else {
                File homePageFile = new File(file, HOME_PAGE);
                if (!homePageFile.exists() || !homePageFile.canRead()) {
                    this.responseError(403);
                } else {
                    this.responseFile(homePageFile, dynamic);
                }
            }
        } else {
            this.responseFile(file, dynamic);
        }
    }

    protected void responseDirectory(File directory) throws IOException {
        String path = this.exchange.getRequestURI().getRawPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        StringBuilder s = new StringBuilder().append("<!DOCTYPE html><html><head><meta charset=\"").append(CHARSET).append("\" /><title>").append(path).append("</title></head><body><h3>").append(path).append("</h3><ul><li><a href=\"../\">..</a></li>");
        File[] files = directory.listFiles();
        if (null != files) {
            for (File file : files) {
                if (!file.canRead()) continue;
                String fileName = file.getName();
                s.append("<li><a href=\"").append(path).append(fileName).append("\">").append(fileName).append("</a></li>");
            }
        }
        s.append("</ul></body></html>");
        this.responseOk(s.toString());
    }

    protected void responseOk(String html) throws IOException {
        this.responseHtml(200, html);
    }

    protected void responseError(int code) throws IOException {
        String msg = "";
        switch (code) {
            case 403: {
                msg = String.format(MSG_HTML, CHARSET, MSG_403, MSG_403);
                break;
            }
            case 404: {
                msg = String.format(MSG_HTML, CHARSET, MSG_404, MSG_404);
                break;
            }
        }
        this.responseHtml(code, msg);
    }

    protected void responseHtml(int code, String html) throws IOException {
        this.responseString(code, "text/html", html);
    }

    protected void responseString(int code, String contentType, String s) throws IOException {
        byte[] content = s.getBytes(CHARSET);
        this.exchange.getResponseHeaders().add("Content-Type", String.format("%s; charset=%s", contentType, CHARSET));
        this.exchange.sendResponseHeaders(code, content.length);
        this.responseBytes(content);
    }

    protected void responseBytes(byte[] data) throws IOException {
        OutputStream os = null;
        try {
            os = this.exchange.getResponseBody();
            os.write(data);
            os.flush();
        }
        finally {
            IOUtil.closeQuietly((Closeable)os);
        }
    }

    protected void responseFile(File file, boolean dynamic) throws IOException {
        if (dynamic) {
            this.responseDynamicFile(file);
        } else {
            this.responseStaticFile(file);
        }
    }

    protected void responseDynamicFile(File file) throws IOException {
        String html = FileUtil.readAsText((File)file);
        this.responseOk(html);
    }

    protected void responseStaticFile(File file) throws IOException {
        long length = file.length();
        long lastModified = file.lastModified();
        String etag = String.format("%s-%s", Long.toHexString(lastModified), Long.toHexString(length));
        String ifNoneMatch = this.exchange.getRequestHeaders().getFirst("If-None-Match");
        String modifiedSince = DATE_FORMAT.format(new Date(lastModified));
        String ifModifiedSince = this.exchange.getRequestHeaders().getFirst("If-Modified-Since");
        if (null != ifNoneMatch) {
            if (etag.equals(ifNoneMatch)) {
                this.responseHtml(304, MSG_304);
                return;
            }
        } else if (null != ifModifiedSince && modifiedSince.equals(ifModifiedSince)) {
            this.responseHtml(304, MSG_304);
            return;
        }
        String fileName = file.getName();
        String ext = "";
        if (fileName.contains(".")) {
            ext = fileName.substring(fileName.lastIndexOf("."));
        }
        this.exchange.getResponseHeaders().add("Content-Type", ContentTypes.getContentType((String)ext));
        this.exchange.getResponseHeaders().add("Last-Modified", modifiedSince);
        this.exchange.getResponseHeaders().add("Etag", etag);
        List acceptEncodings = new ArrayList();
        String acceptEncoding = this.exchange.getRequestHeaders().getFirst("Accept-Encoding");
        if (null != acceptEncoding) {
            acceptEncodings = StringUtil.list((String)acceptEncoding, (String)",");
        }
        List exts = StringUtil.list((String)GZIP_FILE_EXT, (String)",");
        if (acceptEncodings.contains("gzip") && GZIP_ENABLE && length >= (long)GZIP_MIN_SIZE && exts.contains(ext)) {
            this.responseGzip(file);
        } else {
            this.responseStream(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseStream(File file) throws IOException {
        this.exchange.sendResponseHeaders(200, file.length());
        FileInputStream in = null;
        OutputStream os = null;
        try {
            in = new FileInputStream(file);
            os = this.exchange.getResponseBody();
            byte[] buffer = new byte[BUFFER_SIZE];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                os.write(buffer, 0, n);
            }
            os.flush();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(os);
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)in);
        IOUtil.closeQuietly((Closeable)os);
    }

    protected void responseGzip(File file) throws IOException {
        byte[] data = this.gzip(file);
        this.exchange.getResponseHeaders().add("Content-Encoding", "gzip");
        this.exchange.sendResponseHeaders(200, data.length);
        this.responseBytes(data);
    }
}

