/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.model;

import com.nlf.Bean;
import com.nlf.core.AbstractBean;
import com.nlf.extend.dao.sql.ISqlDao;
import com.nlf.extend.dao.sql.ISqlDeleter;
import com.nlf.extend.dao.sql.ISqlSelecter;
import com.nlf.extend.dao.sql.ISqlUpdater;
import com.nlf.extend.dao.sql.SqlDaoFactory;
import com.nlf.extend.model.IModelSelecter;
import com.nlf.extend.model.impl.DefaultModelSelecter;
import com.nlf.serialize.json.JSON;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model<M extends Model>
extends AbstractBean {
    public static final String DEFAULT_PRIMARY_KEY = "id";
    private static final Pattern PATTERN_UPPER = Pattern.compile("[A-Z]");
    private static final Pattern PATTERN_LINE = Pattern.compile("_(\\w)");
    protected String alias;
    protected String tableName;
    protected Set<String> primaryKeys = new LinkedHashSet<String>();
    protected String autoIncrement;
    protected Bean cache;

    protected Model(String tableName) {
        this(tableName, new String[0], null);
    }

    protected Model(String tableName, String primaryKey) {
        this(tableName, primaryKey, null);
    }

    protected Model(String tableName, String primaryKey, String autoIncrement) {
        this(tableName, new String[]{primaryKey}, autoIncrement);
    }

    protected Model(String tableName, String[] primaryKeys, String autoIncrement) {
        this(null, tableName, primaryKeys, autoIncrement);
    }

    protected Model(String alias, String tableName, String[] primaryKeys, String autoIncrement) {
        this.alias = alias;
        this.tableName = tableName;
        if (null != primaryKeys) {
            for (String key : primaryKeys) {
                this.primaryKeys.add(this.encode(key));
            }
        }
        if (this.primaryKeys.isEmpty()) {
            this.primaryKeys.add(DEFAULT_PRIMARY_KEY);
        }
        this.autoIncrement = this.encode(autoIncrement);
    }

    public String encode(String property) {
        if (null == property) {
            return null;
        }
        Matcher matcher = PATTERN_UPPER.matcher(property);
        StringBuffer s = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(s, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(s);
        return s.toString();
    }

    public String decode(String field) {
        if (null == field) {
            return null;
        }
        field = field.toLowerCase();
        Matcher matcher = PATTERN_LINE.matcher(field);
        StringBuffer s = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(s, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(s);
        return s.toString();
    }

    public String alias() {
        return this.alias;
    }

    public String tableName() {
        return this.tableName;
    }

    public Set<String> primaryKeys() {
        return this.primaryKeys;
    }

    public String autoIncrement() {
        return this.autoIncrement;
    }

    public void delete() {
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        ISqlDao dao = null == this.alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)this.alias);
        ISqlDeleter deleter = dao.getDeleter().table(this.tableName);
        for (String key : this.primaryKeys) {
            deleter.where(key, param.get(this.decode(key)));
        }
        deleter.delete();
    }

    public void save() {
        ISqlDao iSqlDao;
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        if (param.isEmpty()) {
            return;
        }
        HashSet<String> needEncode = new HashSet<String>();
        for (String string : param.keySet()) {
            if (this.encode(string).equals(string)) continue;
            needEncode.add(string);
        }
        for (String string : needEncode) {
            param.set(this.encode(string), param.get(string));
            param.remove(string);
        }
        boolean insert = false;
        for (String key : this.primaryKeys) {
            if (key.equals(this.autoIncrement)) {
                if (param.getLong(key, 0L) >= 1L) continue;
                insert = true;
                break;
            }
            if (param.getString(key, "").length() >= 1) continue;
            insert = true;
            break;
        }
        ISqlDao iSqlDao2 = iSqlDao = null == this.alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)this.alias);
        if (!insert) {
            ISqlSelecter selecter = iSqlDao.getSelecter().table(this.tableName);
            for (String key : this.primaryKeys) {
                selecter.where(key, param.get(this.decode(key)));
            }
            boolean bl = insert = selecter.count() < 1;
        }
        if (insert) {
            if (null == this.autoIncrement) {
                iSqlDao.getInserter().table(this.tableName).set(param).insert();
            } else {
                param.remove(this.autoIncrement);
                Bean ret = iSqlDao.getInserter().table(this.tableName).set(param).insertAndGetGenerated();
                if (!ret.isEmpty()) {
                    try {
                        PropertyDescriptor[] props;
                        String autoIncrementProperty = this.decode(this.autoIncrement);
                        BeanInfo info = Introspector.getBeanInfo(((Object)((Object)this)).getClass(), Object.class);
                        for (PropertyDescriptor p : props = info.getPropertyDescriptors()) {
                            Method setter;
                            if (!p.getName().equals(autoIncrementProperty) || null == (setter = p.getWriteMethod())) continue;
                            Object value = this.convert(ret.get("GENERATED_KEY"), p.getPropertyType(), setter.getGenericParameterTypes()[0]);
                            setter.invoke((Object)this, value);
                        }
                    }
                    catch (Exception autoIncrementProperty) {}
                }
            }
        } else {
            if (null != this.cache) {
                for (String property : this.cache.keySet()) {
                    String value;
                    String field = this.encode(property);
                    String cacheValue = this.cache.getString(property, "");
                    if (cacheValue.equals(value = param.getString(field, ""))) {
                        if (this.primaryKeys.contains(field)) continue;
                        param.remove(field);
                        continue;
                    }
                    this.cache.set(property, param.get(field));
                }
            }
            ISqlUpdater updater = iSqlDao.getUpdater().table(this.tableName);
            for (String key : this.primaryKeys) {
                updater.where(key, param.get(key));
            }
            for (String key : this.primaryKeys) {
                param.remove(key);
            }
            if (!param.isEmpty()) {
                updater.set(param).update();
            }
        }
    }

    public void load() {
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        ISqlDao dao = null == this.alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)this.alias);
        ISqlSelecter selecter = dao.getSelecter().table(this.tableName);
        for (String key : this.primaryKeys) {
            selecter.where(key, param.get(this.decode(key)));
        }
        Bean ret = selecter.one();
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(((Object)((Object)this)).getClass(), Object.class);
            for (PropertyDescriptor p : props = info.getPropertyDescriptors()) {
                Method setter = p.getWriteMethod();
                if (null == setter) continue;
                Object value = this.convert(ret.get(this.encode(p.getName())), p.getPropertyType(), setter.getGenericParameterTypes()[0]);
                setter.invoke((Object)this, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cache = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
    }

    public IModelSelecter<M> selecter() {
        return new DefaultModelSelecter(this);
    }
}

