/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.type.hikari;

import com.nlf.dao.connection.AbstractConnectionProvider;
import com.nlf.dao.connection.IConnection;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.IDbSetting;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.extend.dao.sql.type.hikari.HikariSetting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class HikariConnectionProvider
extends AbstractConnectionProvider {
    private static final Map<String, HikariDataSource> dataSources = new HashMap<String, HikariDataSource>();

    public IConnection getConnection() {
        HikariSetting setting = (HikariSetting)this.setting;
        Connection conn = null;
        try {
            String key = setting.getAlias();
            HikariDataSource dataSource = dataSources.get(key);
            if (null == dataSource) {
                HikariConfig config = new HikariConfig();
                config.setDataSourceClassName(setting.getDataSourceClassName());
                config.setUsername(setting.getUser());
                config.setPassword(setting.getPassword());
                config.setConnectionTestQuery(setting.getConnectionTestQuery());
                if (setting.getIdleTimeout() > -1L) {
                    config.setIdleTimeout(setting.getIdleTimeout());
                }
                if (setting.getConnectionTimeout() > -1L) {
                    config.setConnectionTimeout(setting.getConnectionTimeout());
                }
                if (setting.getMaxLifetime() > -1L) {
                    config.setMaxLifetime(setting.getMaxLifetime());
                }
                if (setting.getMaximumPoolSize() > -1) {
                    config.setMaximumPoolSize(setting.getMaximumPoolSize());
                }
                if (setting.getMinimumIdle() > -1) {
                    config.setMinimumIdle(setting.getMinimumIdle());
                }
                config.addDataSourceProperty("url", (Object)setting.getUrl());
                for (Map.Entry<String, Object> en : setting.getProperties().entrySet()) {
                    config.addDataSourceProperty(en.getKey(), en.getValue());
                }
                dataSource = new HikariDataSource(config);
                dataSources.put(key, dataSource);
            }
            conn = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new DaoException((Throwable)e);
        }
        SqlConnection sc = new SqlConnection(conn);
        sc.setDbSetting((IDbSetting)setting);
        return sc;
    }

    public boolean support(String type) {
        return "HikariCP".equalsIgnoreCase(type);
    }
}

