/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.type.hikari;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.dao.setting.IDbSetting;
import com.nlf.dao.setting.IDbSettingProvider;
import com.nlf.extend.dao.sql.type.hikari.HikariDriver;
import com.nlf.extend.dao.sql.type.hikari.HikariSetting;
import java.util.Map;

public class HikariSettingProvider
implements IDbSettingProvider {
    public IDbSetting buildDbSetting(Bean o) {
        String alias = o.getString("alias", "");
        String dbType = o.getString("dbtype", "");
        String user = o.getString("user", "");
        String password = o.getString("password", "");
        String server = o.getString("server", "");
        int port = o.getInt("port", 0);
        String dbname = o.getString("dbname", "");
        String driver = o.getString("driver", "");
        String dataSource = o.getString("dataSource", "");
        String url = o.getString("url", "");
        String extra = o.getString("extra", "");
        if (extra.length() > 0 && !extra.startsWith("?")) {
            extra = "?" + extra;
        }
        dbType = dbType.toLowerCase();
        HikariSetting ps = new HikariSetting();
        ps.setAlias(alias);
        ps.setServer(server);
        ps.setPort(port);
        ps.setPassword(password);
        ps.setUser(user);
        ps.setDbType(dbType);
        ps.setDbName(dbname);
        ps.setMinimumIdle(o.getInt("minimumIdle", -1));
        ps.setMaximumPoolSize(o.getInt("maximumPoolSize", -1));
        ps.setConnectionTestQuery(o.getString("testSql"));
        ps.setConnectionTimeout(o.getLong("connectionTimeout", -1L));
        ps.setIdleTimeout(o.getLong("idleTimeout", -1L));
        ps.setMaxLifetime(o.getLong("maxLifeTime", -1L));
        Bean properties = o.getBean("properties", new Bean());
        for (Map.Entry en : properties.entrySet()) {
            ps.setProperty((String)en.getKey(), en.getValue());
        }
        if (dataSource.length() < 1) {
            dataSource = App.getProperty((String)String.format("nlf.dao.setting.%s.dataSource", dbType), (Object[])new Object[0]);
        }
        if (driver.length() < 1) {
            driver = HikariDriver.class.getName();
        }
        if (url.length() < 1) {
            url = App.getProperty((String)String.format("nlf.dao.setting.%s.url", dbType), (Object[])new Object[]{server, port + "", dbname}) + extra;
        }
        ps.setDataSourceClassName(dataSource);
        ps.setDriver(driver);
        ps.setUrl(url);
        return ps;
    }

    public boolean support(String type) {
        return "HikariCP".equalsIgnoreCase(type);
    }
}

