package com.nlf.extend.serialize.yaml;

import com.nlf.serialize.ConvertFactory;

/**
 * yaml序列化工具
 *
 * @author 6tail
 *
 */
public class YAML {
  /**
   * 将指定对象转换为yaml字符串
   *
   * @param o 对象
   * @return yaml字符串
   */
  public static String fromObject(Object o){
    return ConvertFactory.getWrapper("yaml").wrap(o);
  }

  /**
   * 将字符串转换为Bean或者List<Bean>
   *
   * @param s 字符串
   * @return Bean或者List<Bean>
   */
  public static <T>T toBean(String s){
    return ConvertFactory.getParser("yaml").parse(s);
  }
}
