/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.NineStar;
import com.nlf.calendar.Solar;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lunar {
    private static final double SECOND_PER_RAD = 206264.80624709636;
    private static final String[] JIE_QI = new String[]{"\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea"};
    private static final double[] NUT_B = new double[]{2.1824, -33.75705, 3.6E-5, -1720.0, 920.0, 3.5069, 1256.66393, 1.1E-5, -132.0, 57.0, 1.3375, 16799.4182, -5.1E-5, -23.0, 10.0, 4.3649, -67.5141, 7.2E-5, 21.0, -9.0, 0.04, -628.302, 0.0, -14.0, 0.0, 2.36, 8328.691, 0.0, 7.0, 0.0, 3.46, 1884.966, 0.0, -5.0, 2.0, 5.44, 16833.175, 0.0, -4.0, 2.0, 3.69, 25128.11, 0.0, -3.0, 0.0, 3.55, 628.362, 0.0, 2.0, 0.0};
    private static final double[] DT_AT = new double[]{-4000.0, 108371.7, -13036.8, 392.0, 0.0, -500.0, 17201.0, -627.82, 16.17, -0.3413, -150.0, 12200.6, -346.41, 5.403, -0.1593, 150.0, 9113.8, -328.13, -1.647, 0.0377, 500.0, 5707.5, -391.41, 0.915, 0.3145, 900.0, 2203.4, -283.45, 13.034, -0.1778, 1300.0, 490.1, -57.35, 2.085, -0.0072, 1600.0, 120.0, -9.81, -1.532, 0.1403, 1700.0, 10.2, -0.91, 0.51, -0.037, 1800.0, 13.4, -0.72, 0.202, -0.0193, 1830.0, 7.8, -1.81, 0.416, -0.0247, 1860.0, 8.3, -0.13, -0.406, 0.0292, 1880.0, -5.4, 0.32, -0.183, 0.0173, 1900.0, -2.3, 2.06, 0.169, -0.0135, 1920.0, 21.2, 1.69, -0.304, 0.0167, 1940.0, 24.2, 1.22, -0.064, 0.0031, 1960.0, 33.2, 0.51, 0.231, -0.0109, 1980.0, 51.0, 1.29, -0.026, 0.0032, 2000.0, 63.87, 0.1, 0.0, 0.0, 2005.0, 64.7, 0.4, 0.0, 0.0, 2015.0, 69.0};
    private static final double[] XL0 = new double[]{1.0E10, 20.0, 578.0, 920.0, 1100.0, 1124.0, 1136.0, 1148.0, 1217.0, 1226.0, 1229.0, 1229.0, 1229.0, 1229.0, 1937.0, 2363.0, 2618.0, 2633.0, 2660.0, 2666.0, 1.7534704567E10, 0.0, 0.0, 3.34165646E8, 4.669256804, 6283.075849991, 3489428.0, 4.6261024, 12566.1517, 349706.0, 2.744118, 5753.384885, 341757.0, 2.828866, 3.523118, 313590.0, 3.62767, 77713.771468, 267622.0, 4.418084, 7860.419392, 234269.0, 6.135162, 3930.209696, 132429.0, 0.742464, 11506.76977, 127317.0, 2.037097, 529.690965, 119917.0, 1.109629, 1577.343542, 99025.0, 5.23268, 5884.92685, 90186.0, 2.04505, 26.29832, 85722.0, 3.50849, 398.149, 77979.0, 1.17883, 5223.69392, 75314.0, 2.53339, 5507.55324, 50526.0, 4.58293, 18849.22755, 49238.0, 4.20507, 775.52261, 35666.0, 2.91954, 0.06731, 31709.0, 5.84902, 11790.62909, 28413.0, 1.89869, 796.29801, 27104.0, 0.31489, 10977.0788, 24281.0, 0.34481, 5486.77784, 20616.0, 4.80647, 2544.31442, 20539.0, 1.86948, 5573.1428, 20226.0, 2.45768, 6069.77675, 15552.0, 0.83306, 213.2991, 13221.0, 3.41118, 2942.46342, 12618.0, 1.08303, 20.7754, 11513.0, 0.64545, 0.98032, 10285.0, 0.636, 4694.00295, 10190.0, 0.97569, 15720.83878, 10172.0, 4.2668, 7.11355, 9921.0, 6.2099, 2146.1654, 9761.0, 0.681, 155.4204, 8580.0, 5.9832, 161000.6857, 8513.0, 1.2987, 6275.9623, 8471.0, 3.6708, 71430.6956, 7964.0, 1.8079, 17260.1547, 7876.0, 3.037, 12036.4607, 7465.0, 1.7551, 5088.6288, 7387.0, 3.5032, 3154.6871, 7355.0, 4.6793, 801.8209, 6963.0, 0.833, 9437.7629, 6245.0, 3.9776, 8827.3903, 6115.0, 1.8184, 7084.8968, 5696.0, 2.7843, 6286.599, 5612.0, 4.3869, 14143.4952, 5558.0, 3.4701, 6279.5527, 5199.0, 0.1891, 12139.5535, 5161.0, 1.3328, 1748.0164, 5115.0, 0.2831, 5856.4777, 4900.0, 0.4874, 1194.447, 4104.0, 5.3682, 8429.2413, 4094.0, 2.3985, 19651.0485, 3920.0, 6.1683, 10447.3878, 3677.0, 6.0413, 10213.2855, 3660.0, 2.5696, 1059.3819, 3595.0, 1.7088, 2352.8662, 3557.0, 1.776, 6812.7668, 3329.0, 0.5931, 17789.8456, 3041.0, 0.4429, 83996.8473, 3005.0, 2.7398, 1349.8674, 2535.0, 3.1647, 4690.4798, 2474.0, 0.2148, 3.5904, 2366.0, 0.4847, 8031.0923, 2357.0, 2.0653, 3340.6124, 2282.0, 5.222, 4705.7323, 2189.0, 5.5559, 553.5694, 2142.0, 1.4256, 16730.4637, 2109.0, 4.1483, 951.7184, 2030.0, 0.3713, 283.8593, 1992.0, 5.2221, 12168.0027, 1986.0, 5.7747, 6309.3742, 1912.0, 3.8222, 23581.2582, 1889.0, 5.3863, 149854.4001, 1790.0, 2.2149, 13367.9726, 1748.0, 4.5605, 135.0651, 1622.0, 5.9884, 11769.8537, 1508.0, 4.1957, 6256.7775, 1442.0, 4.1932, 242.7286, 1435.0, 3.7236, 38.0277, 1397.0, 4.4014, 6681.2249, 1362.0, 1.8893, 7632.9433, 1250.0, 1.1305, 5.5229, 1205.0, 2.6223, 955.5997, 1200.0, 1.0035, 632.7837, 1129.0, 0.1774, 4164.312, 1083.0, 0.3273, 103.0928, 1052.0, 0.9387, 11926.2544, 1050.0, 5.3591, 1592.596, 1033.0, 6.1998, 6438.4962, 1001.0, 6.0291, 5746.2713, 980.0, 0.999, 11371.705, 980.0, 5.244, 27511.468, 938.0, 2.624, 5760.498, 923.0, 0.483, 522.577, 922.0, 4.571, 4292.331, 905.0, 5.337, 6386.169, 862.0, 4.165, 7058.598, 841.0, 3.299, 7234.794, 836.0, 4.539, 25132.303, 813.0, 6.112, 4732.031, 812.0, 6.271, 426.598, 801.0, 5.821, 28.449, 787.0, 0.996, 5643.179, 776.0, 2.957, 23013.54, 769.0, 3.121, 7238.676, 758.0, 3.974, 11499.656, 735.0, 4.386, 316.392, 731.0, 0.607, 11513.883, 719.0, 3.998, 74.782, 706.0, 0.323, 263.084, 676.0, 5.911, 90955.552, 663.0, 3.665, 17298.182, 653.0, 5.791, 18073.705, 630.0, 4.717, 6836.645, 615.0, 1.458, 233141.314, 612.0, 1.075, 19804.827, 596.0, 3.321, 6283.009, 596.0, 2.876, 6283.143, 555.0, 2.452, 12352.853, 541.0, 5.392, 419.485, 531.0, 0.382, 31441.678, 519.0, 4.065, 6208.294, 513.0, 2.361, 10973.556, 494.0, 5.737, 9917.697, 450.0, 3.272, 11015.106, 449.0, 3.653, 206.186, 447.0, 2.064, 7079.374, 435.0, 4.423, 5216.58, 421.0, 1.906, 245.832, 413.0, 0.921, 3738.761, 402.0, 0.84, 20.355, 387.0, 1.826, 11856.219, 379.0, 2.344, 3.881, 374.0, 2.954, 3128.389, 370.0, 5.031, 536.805, 365.0, 1.018, 16200.773, 365.0, 1.083, 88860.057, 352.0, 5.978, 3894.182, 352.0, 2.056, 244287.6, 351.0, 3.713, 6290.189, 340.0, 1.106, 14712.317, 339.0, 0.978, 8635.942, 339.0, 3.202, 5120.601, 333.0, 0.837, 6496.375, 325.0, 3.479, 6133.513, 316.0, 5.089, 21228.392, 316.0, 1.328, 10873.986, 309.0, 3.646, 10.637, 303.0, 1.802, 35371.887, 296.0, 3.397, 9225.539, 288.0, 6.026, 154717.61, 281.0, 2.585, 14314.168, 262.0, 3.856, 266.607, 262.0, 2.579, 22483.849, 257.0, 1.561, 23543.231, 255.0, 3.949, 1990.745, 251.0, 3.744, 10575.407, 240.0, 1.161, 10984.192, 238.0, 0.106, 7.046, 236.0, 4.272, 6040.347, 234.0, 3.577, 10969.965, 211.0, 3.714, 65147.62, 210.0, 0.754, 13521.751, 207.0, 4.228, 5650.292, 202.0, 0.814, 170.673, 201.0, 4.629, 6037.244, 200.0, 0.381, 6172.87, 199.0, 3.933, 6206.81, 199.0, 5.197, 6262.3, 197.0, 1.046, 18209.33, 195.0, 1.07, 5230.807, 195.0, 4.869, 36.028, 194.0, 4.313, 6244.943, 192.0, 1.229, 709.933, 192.0, 5.595, 6282.096, 192.0, 0.602, 6284.056, 189.0, 3.744, 23.878, 188.0, 1.904, 15.252, 188.0, 0.867, 22003.915, 182.0, 3.681, 15110.466, 181.0, 0.491, 1.484, 179.0, 3.222, 39302.097, 179.0, 1.259, 12559.038, 6.2833196674749E13, 0.0, 0.0, 2.0605886E7, 2.67823456, 6283.07584999, 430343.0, 2.635127, 12566.1517, 42526.0, 1.59047, 3.52312, 11926.0, 5.79557, 26.29832, 10898.0, 2.96618, 1577.34354, 9348.0, 2.5921, 18849.2275, 7212.0, 1.1385, 529.691, 6777.0, 1.8747, 398.149, 6733.0, 4.4092, 5507.5532, 5903.0, 2.888, 5223.6939, 5598.0, 2.1747, 155.4204, 4541.0, 0.398, 796.298, 3637.0, 0.4662, 775.5226, 2896.0, 2.6471, 7.1135, 2084.0, 5.3414, 0.9803, 1910.0, 1.8463, 5486.7778, 1851.0, 4.9686, 213.2991, 1729.0, 2.9912, 6275.9623, 1623.0, 0.0322, 2544.3144, 1583.0, 1.4305, 2146.1654, 1462.0, 1.2053, 10977.0788, 1246.0, 2.8343, 1748.0164, 1188.0, 3.258, 5088.6288, 1181.0, 5.2738, 1194.447, 1151.0, 2.075, 4694.003, 1064.0, 0.7661, 553.5694, 997.0, 1.303, 6286.599, 972.0, 4.239, 1349.867, 945.0, 2.7, 242.729, 858.0, 5.645, 951.718, 758.0, 5.301, 2352.866, 639.0, 2.65, 9437.763, 610.0, 4.666, 4690.48, 583.0, 1.766, 1059.382, 531.0, 0.909, 3154.687, 522.0, 5.661, 71430.696, 520.0, 1.854, 801.821, 504.0, 1.425, 6438.496, 433.0, 0.241, 6812.767, 426.0, 0.774, 10447.388, 413.0, 5.24, 7084.897, 374.0, 2.001, 8031.092, 356.0, 2.429, 14143.495, 350.0, 4.8, 6279.553, 337.0, 0.888, 12036.461, 337.0, 3.862, 1592.596, 325.0, 3.4, 7632.943, 322.0, 0.616, 8429.241, 318.0, 3.188, 4705.732, 297.0, 6.07, 4292.331, 295.0, 1.431, 5746.271, 290.0, 2.325, 20.355, 275.0, 0.935, 5760.498, 270.0, 4.804, 7234.794, 253.0, 6.223, 6836.645, 228.0, 5.003, 17789.846, 225.0, 5.672, 11499.656, 215.0, 5.202, 11513.883, 208.0, 3.955, 10213.286, 208.0, 2.268, 522.577, 206.0, 2.224, 5856.478, 206.0, 2.55, 25132.303, 203.0, 0.91, 6256.778, 189.0, 0.532, 3340.612, 188.0, 4.735, 83996.847, 179.0, 1.474, 4164.312, 178.0, 3.025, 5.523, 177.0, 3.026, 5753.385, 159.0, 4.637, 3.286, 157.0, 6.124, 5216.58, 155.0, 3.077, 6681.225, 154.0, 4.2, 13367.973, 143.0, 1.191, 3894.182, 138.0, 3.093, 135.065, 136.0, 4.245, 426.598, 134.0, 5.765, 6040.347, 128.0, 3.085, 5643.179, 127.0, 2.092, 6290.189, 125.0, 3.077, 11926.254, 125.0, 3.445, 536.805, 114.0, 3.244, 12168.003, 112.0, 2.318, 16730.464, 111.0, 3.901, 11506.77, 111.0, 5.32, 23.878, 105.0, 3.75, 7860.419, 103.0, 2.447, 1990.745, 96.0, 0.82, 3.88, 96.0, 4.08, 6127.66, 91.0, 5.42, 206.19, 91.0, 0.42, 7079.37, 88.0, 5.17, 11790.63, 81.0, 0.34, 9917.7, 80.0, 3.89, 10973.56, 78.0, 2.4, 1589.07, 78.0, 2.58, 11371.7, 77.0, 3.98, 955.6, 77.0, 3.36, 36.03, 76.0, 1.3, 103.09, 75.0, 5.18, 10969.97, 75.0, 4.96, 6496.37, 73.0, 5.21, 38.03, 72.0, 2.65, 6309.37, 70.0, 5.61, 3738.76, 69.0, 2.6, 3496.03, 69.0, 0.39, 15.25, 69.0, 2.78, 20.78, 65.0, 1.13, 7058.6, 64.0, 4.28, 28.45, 61.0, 5.63, 10984.19, 60.0, 0.73, 419.48, 60.0, 5.28, 10575.41, 58.0, 5.55, 17298.18, 58.0, 3.19, 4732.03, 5291887.0, 0.0, 0.0, 871984.0, 1.072097, 6283.07585, 30913.0, 0.86729, 12566.1517, 2734.0, 0.053, 3.5231, 1633.0, 5.1883, 26.2983, 1575.0, 3.6846, 155.4204, 954.0, 0.757, 18849.228, 894.0, 2.057, 77713.771, 695.0, 0.827, 775.523, 506.0, 4.663, 1577.344, 406.0, 1.031, 7.114, 381.0, 3.441, 5573.143, 346.0, 5.141, 796.298, 317.0, 6.053, 5507.553, 302.0, 1.192, 242.729, 289.0, 6.117, 529.691, 271.0, 0.306, 398.149, 254.0, 2.28, 553.569, 237.0, 4.381, 5223.694, 208.0, 3.754, 0.98, 168.0, 0.902, 951.718, 153.0, 5.759, 1349.867, 145.0, 4.364, 1748.016, 134.0, 3.721, 1194.447, 125.0, 2.948, 6438.496, 122.0, 2.973, 2146.165, 110.0, 1.271, 161000.686, 104.0, 0.604, 3154.687, 100.0, 5.986, 6286.599, 92.0, 4.8, 5088.63, 89.0, 5.23, 7084.9, 83.0, 3.31, 213.3, 76.0, 3.42, 5486.78, 71.0, 6.19, 4690.48, 68.0, 3.43, 4694.0, 65.0, 1.6, 2544.31, 64.0, 1.98, 801.82, 61.0, 2.48, 10977.08, 50.0, 1.44, 6836.65, 49.0, 2.34, 1592.6, 46.0, 1.31, 4292.33, 46.0, 3.81, 149854.4, 43.0, 0.04, 7234.79, 40.0, 4.94, 7632.94, 39.0, 1.57, 71430.7, 38.0, 3.17, 6309.37, 35.0, 0.99, 6040.35, 35.0, 0.67, 1059.38, 31.0, 3.18, 2352.87, 31.0, 3.55, 8031.09, 30.0, 1.92, 10447.39, 30.0, 2.52, 6127.66, 28.0, 4.42, 9437.76, 28.0, 2.71, 3894.18, 27.0, 0.67, 25132.3, 26.0, 5.27, 6812.77, 25.0, 0.55, 6279.55, 23.0, 1.38, 4705.73, 22.0, 0.64, 6256.78, 20.0, 6.07, 640.88, 28923.0, 5.84384, 6283.07585, 3496.0, 0.0, 0.0, 1682.0, 5.4877, 12566.1517, 296.0, 5.196, 155.42, 129.0, 4.722, 3.523, 71.0, 5.3, 18849.23, 64.0, 5.97, 242.73, 40.0, 3.79, 553.57, 11408.0, 3.14159, 0.0, 772.0, 4.134, 6283.076, 77.0, 3.84, 12566.15, 42.0, 0.42, 155.42, 88.0, 3.14, 0.0, 17.0, 2.77, 6283.08, 5.0, 2.01, 155.42, 3.0, 2.21, 12566.15, 27962.0, 3.1987, 84334.66158, 10164.0, 5.42249, 5507.55324, 8045.0, 3.8801, 5223.6939, 4381.0, 3.7044, 2352.8662, 3193.0, 4.0003, 1577.3435, 2272.0, 3.9847, 1047.7473, 1814.0, 4.9837, 6283.0758, 1639.0, 3.5646, 5856.4777, 1444.0, 3.7028, 9437.7629, 1430.0, 3.4112, 10213.2855, 1125.0, 4.8282, 14143.4952, 1090.0, 2.0857, 6812.7668, 1037.0, 4.0566, 71092.8814, 971.0, 3.473, 4694.003, 915.0, 1.142, 6620.89, 878.0, 4.44, 5753.385, 837.0, 4.993, 7084.897, 770.0, 5.554, 167621.576, 719.0, 3.602, 529.691, 692.0, 4.326, 6275.962, 558.0, 4.41, 7860.419, 529.0, 2.484, 4705.732, 521.0, 6.25, 18073.705, 903.0, 3.897, 5507.553, 618.0, 1.73, 5223.694, 380.0, 5.244, 2352.866, 166.0, 1.627, 84334.662, 1.000139888E10, 0.0, 0.0, 1.67069963E8, 3.098463508, 6283.075849991, 1395602.0, 3.0552461, 12566.1517, 308372.0, 5.198467, 77713.771468, 162846.0, 1.173877, 5753.384885, 157557.0, 2.846852, 7860.419392, 92480.0, 5.45292, 11506.76977, 54244.0, 4.56409, 3930.2097, 47211.0, 3.661, 5884.92685, 34598.0, 0.96369, 5507.55324, 32878.0, 5.89984, 5223.69392, 30678.0, 0.29867, 5573.1428, 24319.0, 4.2735, 11790.62909, 21183.0, 5.84715, 1577.34354, 18575.0, 5.02194, 10977.0788, 17484.0, 3.01194, 18849.22755, 10984.0, 5.05511, 5486.77784, 9832.0, 0.8868, 6069.7768, 8650.0, 5.6896, 15720.8388, 8583.0, 1.2708, 161000.6857, 6490.0, 0.2725, 17260.1547, 6292.0, 0.9218, 529.691, 5706.0, 2.0137, 83996.8473, 5574.0, 5.2416, 71430.6956, 4938.0, 3.245, 2544.3144, 4696.0, 2.5781, 775.5226, 4466.0, 5.5372, 9437.7629, 4252.0, 6.0111, 6275.9623, 3897.0, 5.3607, 4694.003, 3825.0, 2.3926, 8827.3903, 3749.0, 0.8295, 19651.0485, 3696.0, 4.9011, 12139.5535, 3566.0, 1.6747, 12036.4607, 3454.0, 1.8427, 2942.4634, 3319.0, 0.2437, 7084.8968, 3192.0, 0.1837, 5088.6288, 3185.0, 1.7778, 398.149, 2846.0, 1.2134, 6286.599, 2779.0, 1.8993, 6279.5527, 2628.0, 4.589, 10447.3878, 2460.0, 3.7866, 8429.2413, 2393.0, 4.996, 5856.4777, 2359.0, 0.2687, 796.298, 2329.0, 2.8078, 14143.4952, 2210.0, 1.95, 3154.6871, 2035.0, 4.6527, 2146.1654, 1951.0, 5.3823, 2352.8662, 1883.0, 0.6731, 149854.4001, 1833.0, 2.2535, 23581.2582, 1796.0, 0.1987, 6812.7668, 1731.0, 6.152, 16730.4637, 1717.0, 4.4332, 10213.2855, 1619.0, 5.2316, 17789.8456, 1381.0, 5.1896, 8031.0923, 1364.0, 3.6852, 4705.7323, 1314.0, 0.6529, 13367.9726, 1041.0, 4.3329, 11769.8537, 1017.0, 1.5939, 4690.4798, 998.0, 4.201, 6309.374, 966.0, 3.676, 27511.468, 874.0, 6.064, 1748.016, 779.0, 3.674, 12168.003, 771.0, 0.312, 7632.943, 756.0, 2.626, 6256.778, 746.0, 5.648, 11926.254, 693.0, 2.924, 6681.225, 680.0, 1.423, 23013.54, 674.0, 0.563, 3340.612, 663.0, 5.661, 11371.705, 659.0, 3.136, 801.821, 648.0, 2.65, 19804.827, 615.0, 3.029, 233141.314, 612.0, 5.134, 1194.447, 563.0, 4.341, 90955.552, 552.0, 2.091, 17298.182, 534.0, 5.1, 31441.678, 531.0, 2.407, 11499.656, 523.0, 4.624, 6438.496, 513.0, 5.324, 11513.883, 477.0, 0.256, 11856.219, 461.0, 1.722, 7234.794, 458.0, 3.766, 6386.169, 458.0, 4.466, 5746.271, 423.0, 1.055, 5760.498, 422.0, 1.557, 7238.676, 415.0, 2.599, 7058.598, 401.0, 3.03, 1059.382, 397.0, 1.201, 1349.867, 379.0, 4.907, 4164.312, 360.0, 5.707, 5643.179, 352.0, 3.626, 244287.6, 348.0, 0.761, 10973.556, 342.0, 3.001, 4292.331, 336.0, 4.546, 4732.031, 334.0, 3.138, 6836.645, 324.0, 4.164, 9917.697, 316.0, 1.691, 11015.106, 307.0, 0.238, 35371.887, 298.0, 1.306, 6283.143, 298.0, 1.75, 6283.009, 293.0, 5.738, 16200.773, 286.0, 5.928, 14712.317, 281.0, 3.515, 21228.392, 280.0, 5.663, 8635.942, 277.0, 0.513, 26.298, 268.0, 4.207, 18073.705, 266.0, 0.9, 12352.853, 260.0, 2.962, 25132.303, 255.0, 2.477, 6208.294, 242.0, 2.8, 709.933, 231.0, 1.054, 22483.849, 229.0, 1.07, 14314.168, 216.0, 1.314, 154717.61, 215.0, 6.038, 10873.986, 200.0, 0.561, 7079.374, 198.0, 2.614, 951.718, 197.0, 4.369, 167283.762, 186.0, 2.861, 5216.58, 183.0, 1.66, 39302.097, 183.0, 5.912, 3738.761, 175.0, 2.145, 6290.189, 173.0, 2.168, 10575.407, 171.0, 3.702, 1592.596, 171.0, 1.343, 3128.389, 164.0, 5.55, 6496.375, 164.0, 5.856, 10984.192, 161.0, 1.998, 10969.965, 161.0, 1.909, 6133.513, 157.0, 4.955, 25158.602, 154.0, 6.216, 23543.231, 153.0, 5.357, 13521.751, 150.0, 5.77, 18209.33, 150.0, 5.439, 155.42, 139.0, 1.778, 9225.539, 139.0, 1.626, 5120.601, 128.0, 2.46, 13916.019, 123.0, 0.717, 143571.324, 122.0, 2.654, 88860.057, 121.0, 4.414, 3894.182, 121.0, 1.192, 3.523, 120.0, 4.03, 553.569, 119.0, 1.513, 17654.781, 117.0, 3.117, 14945.316, 113.0, 2.698, 6040.347, 110.0, 3.085, 43232.307, 109.0, 0.998, 955.6, 108.0, 2.939, 17256.632, 107.0, 5.285, 65147.62, 103.0, 0.139, 11712.955, 103.0, 5.85, 213.299, 102.0, 3.046, 6037.244, 101.0, 2.842, 8662.24, 100.0, 3.626, 6262.3, 98.0, 2.36, 6206.81, 98.0, 5.11, 6172.87, 98.0, 2.0, 15110.47, 97.0, 2.67, 5650.29, 97.0, 2.75, 6244.94, 96.0, 4.02, 6282.1, 96.0, 5.31, 6284.06, 92.0, 0.1, 29088.81, 85.0, 3.26, 20426.57, 84.0, 2.6, 28766.92, 81.0, 3.58, 10177.26, 80.0, 5.81, 5230.81, 78.0, 2.53, 16496.36, 77.0, 4.06, 6127.66, 73.0, 0.04, 5481.25, 72.0, 5.96, 12559.04, 72.0, 5.92, 4136.91, 71.0, 5.49, 22003.91, 70.0, 3.41, 7.11, 69.0, 0.62, 11403.68, 69.0, 3.9, 1589.07, 69.0, 1.96, 12416.59, 69.0, 4.51, 426.6, 67.0, 1.61, 11087.29, 66.0, 4.5, 47162.52, 66.0, 5.08, 283.86, 66.0, 4.32, 16858.48, 65.0, 1.04, 6062.66, 64.0, 1.59, 18319.54, 63.0, 5.7, 45892.73, 63.0, 4.6, 66567.49, 63.0, 3.82, 13517.87, 62.0, 2.62, 11190.38, 61.0, 1.54, 33019.02, 60.0, 5.58, 10344.3, 60.0, 5.38, 316428.23, 60.0, 5.78, 632.78, 59.0, 6.12, 9623.69, 57.0, 0.16, 17267.27, 57.0, 3.86, 6076.89, 57.0, 1.98, 7668.64, 56.0, 4.78, 20199.09, 55.0, 4.56, 18875.53, 55.0, 3.51, 17253.04, 54.0, 3.07, 226858.24, 54.0, 4.83, 18422.63, 53.0, 5.02, 12132.44, 52.0, 3.63, 5333.9, 52.0, 0.97, 155427.54, 51.0, 3.36, 20597.24, 50.0, 0.99, 11609.86, 50.0, 2.21, 1990.75, 48.0, 1.62, 12146.67, 48.0, 1.17, 12569.67, 47.0, 4.62, 5436.99, 47.0, 1.81, 12562.63, 47.0, 0.59, 21954.16, 47.0, 0.76, 7342.46, 46.0, 0.27, 4590.91, 46.0, 3.77, 156137.48, 45.0, 5.66, 10454.5, 44.0, 5.84, 3496.03, 43.0, 0.24, 17996.03, 41.0, 5.93, 51092.73, 41.0, 4.21, 12592.45, 40.0, 5.14, 1551.05, 40.0, 5.28, 15671.08, 39.0, 3.69, 18052.93, 39.0, 4.94, 24356.78, 38.0, 2.72, 11933.37, 38.0, 5.23, 7477.52, 38.0, 4.99, 9779.11, 37.0, 3.7, 9388.01, 37.0, 4.44, 4535.06, 36.0, 2.16, 28237.23, 36.0, 2.54, 242.73, 36.0, 0.22, 5429.88, 35.0, 6.15, 19800.95, 35.0, 2.92, 36949.23, 34.0, 5.63, 2379.16, 34.0, 5.73, 16460.33, 34.0, 5.11, 5849.36, 33.0, 6.19, 6268.85, 1.0301861E7, 1.1074897, 6283.07584999, 172124.0, 1.064423, 12566.1517, 70222.0, 3.14159, 0.0, 3235.0, 1.0217, 18849.2275, 3080.0, 2.8435, 5507.5532, 2497.0, 1.3191, 5223.6939, 1849.0, 1.4243, 1577.3435, 1008.0, 5.9138, 10977.0788, 865.0, 1.42, 6275.962, 863.0, 0.271, 5486.778, 507.0, 1.686, 5088.629, 499.0, 6.014, 6286.599, 467.0, 5.987, 529.691, 440.0, 0.518, 4694.003, 410.0, 1.084, 9437.763, 387.0, 4.75, 2544.314, 375.0, 5.071, 796.298, 352.0, 0.023, 83996.847, 344.0, 0.949, 71430.696, 341.0, 5.412, 775.523, 322.0, 6.156, 2146.165, 286.0, 5.484, 10447.388, 284.0, 3.42, 2352.866, 255.0, 6.132, 6438.496, 252.0, 0.243, 398.149, 243.0, 3.092, 4690.48, 225.0, 3.689, 7084.897, 220.0, 4.952, 6812.767, 219.0, 0.42, 8031.092, 209.0, 1.282, 1748.016, 193.0, 5.314, 8429.241, 185.0, 1.82, 7632.943, 175.0, 3.229, 6279.553, 173.0, 1.537, 4705.732, 158.0, 4.097, 11499.656, 158.0, 5.539, 3154.687, 150.0, 3.633, 11513.883, 148.0, 3.222, 7234.794, 147.0, 3.653, 1194.447, 144.0, 0.817, 14143.495, 135.0, 6.151, 5746.271, 134.0, 4.644, 6836.645, 128.0, 2.693, 1349.867, 123.0, 5.65, 5760.498, 118.0, 2.577, 13367.973, 113.0, 3.357, 17789.846, 110.0, 4.497, 4292.331, 108.0, 5.828, 12036.461, 102.0, 5.621, 6256.778, 99.0, 1.14, 1059.38, 98.0, 0.66, 5856.48, 93.0, 2.32, 10213.29, 92.0, 0.77, 16730.46, 88.0, 1.5, 11926.25, 86.0, 1.42, 5753.38, 85.0, 0.66, 155.42, 81.0, 1.64, 6681.22, 80.0, 4.11, 951.72, 66.0, 4.55, 5216.58, 65.0, 0.98, 25132.3, 64.0, 4.19, 6040.35, 64.0, 0.52, 6290.19, 63.0, 1.51, 5643.18, 59.0, 6.18, 4164.31, 57.0, 2.3, 10973.56, 55.0, 2.32, 11506.77, 55.0, 2.2, 1592.6, 55.0, 5.27, 3340.61, 54.0, 5.54, 553.57, 53.0, 5.04, 9917.7, 53.0, 0.92, 11371.7, 52.0, 3.98, 17298.18, 52.0, 3.6, 10969.97, 49.0, 5.91, 3894.18, 49.0, 2.51, 6127.66, 48.0, 1.67, 12168.0, 46.0, 0.31, 801.82, 42.0, 3.7, 10575.41, 42.0, 4.05, 10984.19, 40.0, 2.17, 7860.42, 40.0, 4.17, 26.3, 38.0, 5.82, 7058.6, 37.0, 3.39, 6496.37, 36.0, 1.08, 6309.37, 36.0, 5.34, 7079.37, 34.0, 3.62, 11790.63, 32.0, 0.32, 16200.77, 31.0, 4.24, 3738.76, 29.0, 4.55, 11856.22, 29.0, 1.26, 8635.94, 27.0, 3.45, 5884.93, 26.0, 5.08, 10177.26, 26.0, 5.38, 21228.39, 24.0, 2.26, 11712.96, 24.0, 1.05, 242.73, 24.0, 5.59, 6069.78, 23.0, 3.63, 6284.06, 23.0, 1.64, 4732.03, 22.0, 3.46, 213.3, 21.0, 1.05, 3496.03, 21.0, 3.92, 13916.02, 21.0, 4.01, 5230.81, 20.0, 5.16, 12352.85, 20.0, 0.69, 1990.75, 19.0, 2.73, 6062.66, 19.0, 5.01, 11015.11, 18.0, 6.04, 6283.01, 18.0, 2.85, 7238.68, 18.0, 5.6, 6283.14, 18.0, 5.16, 17253.04, 18.0, 2.54, 14314.17, 17.0, 1.58, 7.11, 17.0, 0.98, 3930.21, 17.0, 4.75, 17267.27, 16.0, 2.19, 6076.89, 16.0, 2.19, 18073.7, 16.0, 6.12, 3.52, 16.0, 4.61, 9623.69, 16.0, 3.4, 16496.36, 15.0, 0.19, 9779.11, 15.0, 5.3, 13517.87, 15.0, 4.26, 3128.39, 15.0, 0.81, 709.93, 14.0, 0.5, 25158.6, 14.0, 4.38, 4136.91, 13.0, 0.98, 65147.62, 13.0, 3.31, 154717.61, 13.0, 2.11, 1589.07, 13.0, 1.92, 22483.85, 12.0, 6.03, 9225.54, 12.0, 1.53, 12559.04, 12.0, 5.82, 6282.1, 12.0, 5.61, 5642.2, 12.0, 2.38, 167283.76, 12.0, 0.39, 12132.44, 12.0, 3.98, 4686.89, 12.0, 5.81, 12569.67, 12.0, 0.56, 5849.36, 11.0, 0.45, 6172.87, 11.0, 5.8, 16858.48, 11.0, 6.22, 12146.67, 11.0, 2.27, 5429.88, 435939.0, 5.784551, 6283.07585, 12363.0, 5.57935, 12566.1517, 1234.0, 3.1416, 0.0, 879.0, 3.628, 77713.771, 569.0, 1.87, 5573.143, 330.0, 5.47, 18849.228, 147.0, 4.48, 5507.553, 110.0, 2.842, 161000.686, 101.0, 2.815, 5223.694, 85.0, 3.11, 1577.34, 65.0, 5.47, 775.52, 61.0, 1.38, 6438.5, 50.0, 4.42, 6286.6, 47.0, 3.66, 7084.9, 46.0, 5.39, 149854.4, 42.0, 0.9, 10977.08, 40.0, 3.2, 5088.63, 35.0, 1.81, 5486.78, 32.0, 5.35, 3154.69, 30.0, 3.52, 796.3, 29.0, 4.62, 4690.48, 28.0, 1.84, 4694.0, 27.0, 3.14, 71430.7, 27.0, 6.17, 6836.65, 26.0, 1.42, 2146.17, 25.0, 2.81, 1748.02, 24.0, 2.18, 155.42, 23.0, 4.76, 7234.79, 21.0, 3.38, 7632.94, 21.0, 0.22, 4705.73, 20.0, 4.22, 1349.87, 20.0, 2.01, 1194.45, 20.0, 4.58, 529.69, 19.0, 1.59, 6309.37, 18.0, 5.7, 6040.35, 18.0, 6.03, 4292.33, 17.0, 2.9, 9437.76, 17.0, 2.0, 8031.09, 17.0, 5.78, 83996.85, 16.0, 0.05, 2544.31, 15.0, 0.95, 6127.66, 14.0, 0.36, 10447.39, 14.0, 1.48, 2352.87, 13.0, 0.77, 553.57, 13.0, 5.48, 951.72, 13.0, 5.27, 6279.55, 13.0, 3.76, 6812.77, 11.0, 5.41, 6256.78, 10.0, 0.68, 1592.6, 10.0, 4.95, 398.15, 10.0, 1.15, 3894.18, 10.0, 5.2, 244287.6, 10.0, 1.94, 11856.22, 9.0, 5.39, 25132.3, 8.0, 6.18, 1059.38, 8.0, 0.69, 8429.24, 8.0, 5.85, 242.73, 7.0, 5.26, 14143.5, 7.0, 0.52, 801.82, 6.0, 2.24, 8635.94, 6.0, 4.0, 13367.97, 6.0, 2.77, 90955.55, 6.0, 5.17, 7058.6, 5.0, 1.46, 233141.31, 5.0, 4.13, 7860.42, 5.0, 3.91, 26.3, 5.0, 3.89, 12036.46, 5.0, 5.58, 6290.19, 5.0, 5.54, 1990.75, 5.0, 0.83, 11506.77, 5.0, 6.22, 6681.22, 4.0, 5.26, 10575.41, 4.0, 1.91, 7477.52, 4.0, 0.43, 10213.29, 4.0, 1.09, 709.93, 4.0, 5.09, 11015.11, 4.0, 4.22, 88860.06, 4.0, 3.57, 7079.37, 4.0, 1.98, 6284.06, 4.0, 3.93, 10973.56, 4.0, 6.18, 9917.7, 4.0, 0.36, 10177.26, 4.0, 2.75, 3738.76, 4.0, 3.33, 5643.18, 4.0, 5.36, 25158.6, 14459.0, 4.27319, 6283.07585, 673.0, 3.917, 12566.152, 77.0, 0.0, 0.0, 25.0, 3.73, 18849.23, 4.0, 2.8, 6286.6, 386.0, 2.564, 6283.076, 31.0, 2.27, 12566.15, 5.0, 3.44, 5573.14, 2.0, 2.05, 18849.23, 1.0, 2.06, 77713.77, 1.0, 4.41, 161000.69, 1.0, 3.82, 149854.4, 1.0, 4.08, 6127.66, 1.0, 5.26, 6438.5, 9.0, 1.22, 6283.08, 1.0, 0.66, 12566.15};
    private static final double[] QI_KB = new double[]{1640650.479938, 15.218425, 1642476.703182, 15.21874996, 1683430.515601, 15.218750011, 1752157.640664, 15.218749978, 1807675.003759, 15.218620279, 1883627.765182, 15.218612292, 1907369.1281, 15.218449176, 1936603.140413, 15.218425, 1939145.52418, 15.218466998, 1947180.7983, 15.218524844, 1964362.041824, 15.218533526, 1987372.340971, 15.218513908, 1999653.819126, 15.218530782, 2007445.469786, 15.218535181, 2021324.917146, 15.218526248, 2047257.232342, 15.218519654, 2070282.898213, 15.218425, 2073204.87285, 15.218515221, 2080144.500926, 15.218530782, 2086703.688963, 15.218523776, 2110033.182763, 15.218425, 2111190.300888, 15.218425, 2113731.271005, 15.218515671, 2120670.840263, 15.218425, 2123973.309063, 15.218425, 2125068.997336, 15.218477932, 2136026.312633, 15.218472436, 2156099.495538, 15.218425, 2159021.324663, 15.218425, 2162308.575254, 15.218461742, 2178485.706538, 15.218425, 2178759.662849, 15.218445786, 2185334.0208, 15.218425, 2187525.481425, 15.218425, 2188621.191481, 15.218437494, 2322147.76};
    private static final String QB = "0000000000000200000001000000000000222000000000000000000000000000000000000000000000000000000000000000000000000200000001010000000000202002000000000000000000000000000000020000000000000020000000000000000000002000000000010000020000002002000000000000000010000000000000100100000000000020000010000000000020000000020000010000000002000002002000000000000000000000000100100101000000000020000000001000000020000000020000010000000002000002000000000000000000020000000000100101000200000020200000001000000020000000000000000000000002000000000000000000000000220000000000000010000200000000200000001000000000000000000000000000000002000200000000000000002000222000000000000010000000000000200000001000100000000000000000000000000000000200000001000000000000222000000000000010000000000000000000000000100000000000200000000000000000000200200001000000000000222002000000000000000000000000000000000000000000000020000000000000000000000200000000010000000000202002000000000000000000000000000000100000000000000020000010000000000000000000020000010000000000002002002000000000000000000000000000100100000000000020000000000000000020000000020000010000000002000002000000000000000001000000000000100101000000000020200000001000000020000000000000000000000002000000000000000000000000020000000000000101000200000020200000001000000020000000000000000000000002000200000000000000000000020000000000000001000200000000200000001000000000000000000000000000000002000200000000000000000000222000000000000010000000000000000000000000000000000000000000000000000000000200000001000000002000222000000000000000000000000000000000000000100000000000000000000000010000000200000000010000000000222002000000000000000000000000000000100000000000000020000010000000000000000200020000010000000000202002002000000000000000000000000100100000000000000020000000000000000000000000020000010000000000002002000000000000000000000000000000100100000000000020200000000000000000000000020000000000000002000002000000000000000000000000000000000100000000000020200000001000000020000000000000000000000002000000000000000000000000020000000000000111000000000000200000001000000020000000000000000000000002000200000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000020000000000000000000000000000000200000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000000000010000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000020000002000000000000000000000000000000000000000000000000000000000010000000200000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000002000000000000000000000000000000000100000000000000000000001000010000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000010000000000000000100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000100000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000001000010000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000010000000000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    private int year;
    private int month;
    private int day;
    private Solar solar;
    private int dayOffset;
    private int timeGanIndex;
    private int timeZhiIndex;
    private int dayGanIndex;
    private int dayZhiIndex;
    private int dayGanIndexExact;
    private int dayZhiIndexExact;
    private int monthGanIndex;
    private int monthZhiIndex;
    private int monthGanIndexExact;
    private int monthZhiIndexExact;
    private int yearGanIndex;
    private int yearZhiIndex;
    private int yearGanIndexByLiChun;
    private int yearZhiIndexByLiChun;
    private int yearGanIndexExact;
    private int yearZhiIndexExact;
    private int weekIndex;
    private int hour;
    private int minute;
    private int second;
    private Map<String, Solar> jieQi = new LinkedHashMap<String, Solar>();

    public Lunar() {
        this(new Date());
    }

    public Lunar(int lunarYear, int lunarMonth, int lunarDay) {
        this(lunarYear, lunarMonth, lunarDay, 0, 0, 0);
    }

    public Lunar(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute, int second) {
        int m = Math.abs(lunarMonth);
        if (m < 1 || m > 12) {
            throw new IllegalArgumentException("lunar month must between 1 and 12, or negative");
        }
        if (lunarMonth < 0) {
            int leapMonth = LunarUtil.getLeapMonth(lunarYear);
            if (leapMonth == 0) {
                throw new IllegalArgumentException(String.format("no leap month in lunar year %d", lunarYear));
            }
            if (leapMonth != m) {
                throw new IllegalArgumentException(String.format("leap month is %d in lunar year %d", leapMonth, lunarYear));
            }
        }
        if (lunarDay < 1 || lunarDay > 30) {
            throw new IllegalArgumentException("lunar day must between 1 and 30");
        }
        int days = LunarUtil.getDaysOfMonth(lunarYear, lunarMonth);
        if (lunarDay > days) {
            throw new IllegalArgumentException(String.format("only %d days in lunar year %d month %d", days, lunarYear, lunarMonth));
        }
        this.year = lunarYear;
        this.month = lunarMonth;
        this.day = lunarDay;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.dayOffset = LunarUtil.computeAddDays(this.year, this.month, this.day);
        this.solar = this.toSolar();
        this.compute();
    }

    public Lunar(Date date) {
        int i;
        int lunarDay;
        int lunarMonth;
        int lunarYear;
        int startDay;
        int startMonth;
        int startYear;
        this.solar = new Solar(date);
        int y = this.solar.getYear();
        int m = this.solar.getMonth();
        int d = this.solar.getDay();
        if (y < 2000) {
            startYear = 1901;
            startMonth = 1;
            startDay = 1;
            lunarYear = 1900;
            lunarMonth = 11;
            lunarDay = 11;
        } else {
            startYear = 2000;
            startMonth = 1;
            startDay = 1;
            lunarYear = 1999;
            lunarMonth = 11;
            lunarDay = 25;
        }
        int diff = 0;
        for (i = startYear; i < y; ++i) {
            diff += 365;
            if (!SolarUtil.isLeapYear(i)) continue;
            ++diff;
        }
        for (i = startMonth; i < m; ++i) {
            diff += SolarUtil.getDaysOfMonth(y, i);
        }
        lunarDay += (diff += d - startDay);
        int lastDate = LunarUtil.getDaysOfMonth(lunarYear, lunarMonth);
        while (lunarDay > lastDate) {
            lunarDay -= lastDate;
            if ((lunarMonth = LunarUtil.nextMonth(lunarYear, lunarMonth)) == 1) {
                ++lunarYear;
            }
            lastDate = LunarUtil.getDaysOfMonth(lunarYear, lunarMonth);
        }
        this.year = lunarYear;
        this.month = lunarMonth;
        this.day = lunarDay;
        this.hour = this.solar.getHour();
        this.minute = this.solar.getMinute();
        this.second = this.solar.getSecond();
        this.dayOffset = LunarUtil.computeAddDays(this.year, this.month, this.day);
        this.compute();
    }

    private double nutationLon2(double t) {
        double t2 = t * t;
        double dl = 0.0;
        int j = NUT_B.length;
        for (int i = 0; i < j; i += 5) {
            double a = i == 0 ? -1.742 * t : 0.0;
            dl += (NUT_B[i + 3] + a) * Math.sin(NUT_B[i] + NUT_B[i + 1] * t + NUT_B[i + 2] * t2);
        }
        return dl / 100.0 / 206264.80624709636;
    }

    private double eLon(double t, int n) {
        t /= 10.0;
        double v = 0.0;
        double tn = 1.0;
        int pn = 1;
        double m0 = XL0[pn + 1] - XL0[pn];
        int i = 0;
        while (i < 6) {
            int n2 = (int)XL0[pn + 1 + i];
            int n1 = (int)XL0[pn + i];
            double n0 = n2 - n1;
            if (n0 != 0.0) {
                double m;
                if (n < 0) {
                    m = n2;
                } else {
                    m = (int)((double)(3 * n) * n0 / m0 + 0.5) + n1;
                    if (i != 0) {
                        m += 3.0;
                    }
                    if (m > (double)n2) {
                        m = n2;
                    }
                }
                double c = 0.0;
                int j = n1;
                while ((double)j < m) {
                    c += XL0[j] * Math.cos(XL0[j + 1] + t * XL0[j + 2]);
                    j += 3;
                }
                v += c * tn;
            }
            ++i;
            tn *= t;
        }
        v /= XL0[0];
        double t2 = t * t;
        double t3 = t2 * t;
        return v += (-0.0728 - 2.7702 * t - 1.1019 * t2 - 0.0996 * t3) / 206264.80624709636;
    }

    private double gxcSunLon(double t) {
        double v = -0.043126 + 628.301955 * t - 2.732E-6 * t * t;
        double e = 0.016708634 - 4.2037E-5 * t - 1.267E-7 * t * t;
        return -20.49552 * (1.0 + e * Math.cos(v)) / 206264.80624709636;
    }

    private double ev(double t) {
        double f = 628.307585 * t;
        return 628.332 + 21.0 * Math.sin(1.527 + f) + 0.44 * Math.sin(1.48 + f * 2.0) + 0.129 * Math.sin(5.82 + f) * t + 5.5E-4 * Math.sin(4.21 + f) * t * t;
    }

    private double saLon(double t, int n) {
        return this.eLon(t, n) + this.nutationLon2(t) + this.gxcSunLon(t) + Math.PI;
    }

    private double dtExt(double y, double jsd) {
        double dy = (y - 1820.0) / 100.0;
        return -20.0 + jsd * dy * dy;
    }

    private double dtCalc(double y) {
        int i;
        int size = DT_AT.length;
        double y0 = DT_AT[size - 2];
        double t0 = DT_AT[size - 1];
        if (y >= y0) {
            double jsd = 31.0;
            if (y > y0 + 100.0) {
                return this.dtExt(y, jsd);
            }
            double v = this.dtExt(y, jsd);
            double dv = this.dtExt(y0, jsd) - t0;
            return v - dv * (y0 + 100.0 - y) / 100.0;
        }
        for (i = 0; i < size && !(y < DT_AT[i + 5]); i += 5) {
        }
        double t1 = (y - DT_AT[i]) / (DT_AT[i + 5] - DT_AT[i]) * 10.0;
        double t2 = t1 * t1;
        double t3 = t2 * t1;
        return DT_AT[i + 1] + DT_AT[i + 2] * t1 + DT_AT[i + 3] * t2 + DT_AT[i + 4] * t3;
    }

    private double dtT(double t) {
        return this.dtCalc(t / 365.2425 + 2000.0) / 86400.0;
    }

    private double saLonT(double w) {
        double v = 628.3319653318;
        double t = (w - 1.75347 - Math.PI) / v;
        v = this.ev(t);
        t += (w - this.saLon(t, 10)) / v;
        v = this.ev(t);
        t += (w - this.saLon(t, -1)) / v;
        return t;
    }

    private double qiLow(double w) {
        double v = 628.3319653318;
        double t = (w - 4.895062166) / v;
        t -= (53.0 * t * t + 334116.0 * Math.cos(4.67 + 628.307585 * t) + 2061.0 * Math.cos(2.678 + 628.3076 * t) * t) / v / 1.0E7;
        double l = 4.895062166E7 + 6.283319653318E9 * t + 53.0 * t * t + 334166.0 * Math.cos(4.669257 + 628.307585 * t) + 3489.0 * Math.cos(4.6261 + 1256.61517 * t) + 2060.6 * Math.cos(2.67823 + 628.307585 * t) * t - 994.0 - 834.0 * Math.sin(2.1824 - 33.75705 * t);
        t -= (l / 1.0E7 - w) / 628.332 + (32.0 * (t + 1.8) * (t + 1.8) - 20.0) / 86400.0 / 36525.0;
        return t * 36525.0 + 0.0;
    }

    private double saLonT2(double w) {
        double v = 628.3319653318;
        double t = (w - 1.75347 - Math.PI) / v;
        t -= (5.297E-6 * t * t + 0.0334166 * Math.cos(4.669257 + 628.307585 * t) + 2.061E-4 * Math.cos(2.67823 + 628.307585 * t) * t) / v;
        t += (w - this.eLon(t, 8) - Math.PI + (20.5 + 17.2 * Math.sin(2.1824 - 33.75705 * t)) / 206264.80624709636) / v;
        return t;
    }

    private double qiHigh(double w) {
        double t = this.saLonT2(w) * 36525.0;
        double v = ((t = t - this.dtT(t) + 0.0) + 0.5) % 1.0 * 86400.0;
        if (v < 1200.0 || v > 85200.0) {
            t = this.saLonT(w) * 36525.0 - this.dtT(t) + 0.0;
        }
        return t;
    }

    private double calcJieQi(double jd) {
        int size = QI_KB.length;
        double d = 0.0;
        int pc = 7;
        double f1 = QI_KB[0] - (double)pc;
        double f2 = QI_KB[size - 1] - (double)pc;
        double f3 = 2436935.0;
        if ((jd += 2451545.0) < f1 || jd >= f3) {
            d = Math.floor(this.qiHigh(Math.floor((jd + (double)pc - 2451259.0) * 24.0 / 365.2422) * Math.PI / 12.0) + 0.5);
        } else if (jd >= f1 && jd < f2) {
            int i;
            for (i = 0; i < size && !(jd + (double)pc < QI_KB[i + 2]); i += 2) {
            }
            d = QI_KB[i] + QI_KB[i + 1] * Math.floor((jd + (double)pc - QI_KB[i]) / QI_KB[i + 1]);
            if ((d = Math.floor(d + 0.5)) == 1683460.0) {
                d += 1.0;
            }
            d -= 2451545.0;
        } else if (jd >= f2 && jd < f3) {
            d = Math.floor(this.qiLow(Math.floor((jd + (double)pc - 2451259.0) * 24.0 / 365.2422) * Math.PI / 12.0) + 0.5);
            int from = (int)((jd - f2) / 365.2422 * 24.0);
            String n = QB.substring(from, from + 1);
            if ("1".equals(n)) {
                d += 1.0;
            }
            if ("2".equals(n)) {
                d -= 1.0;
            }
        }
        return d;
    }

    private double qiAccurate(double w) {
        double t = this.saLonT(w) * 36525.0;
        return t - this.dtT(t) + 0.3333333333333333;
    }

    private double qiAccurate2(double jd) {
        double d = 0.2617993877991494;
        double w = Math.floor((jd + 293.0) * 24.0 / 365.2422) * d;
        double a = this.qiAccurate(w);
        if (a - jd > 5.0) {
            return this.qiAccurate(w - d);
        }
        if (a - jd < -5.0) {
            return this.qiAccurate(w + d);
        }
        return a;
    }

    private void computeJieQi() {
        double jd = Math.floor((double)(this.solar.getYear() - 2000) * 365.2422 + 180.0);
        double w = Math.floor((jd - 355.0 + 183.0) / 365.2422) * 365.2422 + 355.0;
        if (this.calcJieQi(w) > jd) {
            w -= 365.2422;
        }
        int size = JIE_QI.length;
        for (int i = 0; i < size; ++i) {
            double q = this.calcJieQi(w + 15.2184 * (double)i);
            this.jieQi.put(JIE_QI[i], Solar.fromJulianDay(this.qiAccurate2(q) + 2451545.0));
        }
        double q = this.calcJieQi(w + 15.2184 * (double)size);
        this.jieQi.put("DONG_ZHI", Solar.fromJulianDay(this.qiAccurate2(q) + 2451545.0));
    }

    private void computeYear() {
        this.yearGanIndex = (this.year + -4) % 10;
        this.yearZhiIndex = (this.year + -4) % 12;
        int g = this.yearGanIndex;
        int z = this.yearZhiIndex;
        int gExact = this.yearGanIndex;
        int zExact = this.yearZhiIndex;
        if (this.year == this.solar.getYear()) {
            Solar liChun = this.jieQi.get("\u7acb\u6625");
            if (this.solar.toYmd().compareTo(liChun.toYmd()) < 0) {
                if (--g < 0) {
                    g += 10;
                }
                if (--z < 0) {
                    z += 12;
                }
            }
            if (this.solar.toYmdHms().compareTo(liChun.toYmdHms()) < 0) {
                if (--gExact < 0) {
                    gExact += 10;
                }
                if (--zExact < 0) {
                    zExact += 12;
                }
            }
        }
        this.yearGanIndexByLiChun = g;
        this.yearZhiIndexByLiChun = z;
        this.yearGanIndexExact = gExact;
        this.yearZhiIndexExact = zExact;
    }

    private void computeMonth() {
        Solar end;
        Solar start = null;
        int gOffset = (this.yearGanIndexByLiChun % 5 + 1) * 2 % 10;
        int gOffsetExact = (this.yearGanIndexExact % 5 + 1) * 2 % 10;
        int index = -2;
        for (String jie : LunarUtil.JIE) {
            end = this.jieQi.get(jie);
            String ymd = this.solar.toYmd();
            String symd = null == start ? ymd : start.toYmd();
            String eymd = end.toYmd();
            if (ymd.compareTo(symd) >= 0 && ymd.compareTo(eymd) < 0) break;
            start = end;
            ++index;
        }
        if (index < 0) {
            index += 12;
        }
        this.monthGanIndex = (index + gOffset) % 10;
        this.monthZhiIndex = (index + 2) % 12;
        int indexExact = -2;
        for (String jie : LunarUtil.JIE) {
            end = this.jieQi.get(jie);
            String time = this.solar.toYmdHms();
            String stime = null == start ? time : start.toYmdHms();
            String etime = end.toYmdHms();
            if (time.compareTo(stime) >= 0 && time.compareTo(etime) < 0) break;
            start = end;
            ++indexExact;
        }
        if (indexExact < 0) {
            indexExact += 12;
        }
        this.monthGanIndexExact = (indexExact + gOffsetExact) % 10;
        this.monthZhiIndexExact = (indexExact + 2) % 12;
    }

    private void computeDay() {
        int addDays = (this.dayOffset + 15) % 60;
        this.dayGanIndex = addDays % 10;
        this.dayZhiIndex = addDays % 12;
        int dayGanExact = this.dayGanIndex;
        int dayZhiExact = this.dayZhiIndex;
        String hm = (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute;
        if (hm.compareTo("23:00") >= 0 && hm.compareTo("23:59") <= 0) {
            if (++dayGanExact >= 10) {
                dayGanExact -= 10;
            }
            if (++dayZhiExact >= 12) {
                dayZhiExact -= 12;
            }
        }
        this.dayGanIndexExact = dayGanExact;
        this.dayZhiIndexExact = dayZhiExact;
    }

    private void computeTime() {
        String hm = (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute;
        this.timeZhiIndex = LunarUtil.getTimeZhiIndex(hm);
        this.timeGanIndex = (this.dayGanIndexExact % 5 * 2 + this.timeZhiIndex) % 10;
    }

    private void computeWeek() {
        this.weekIndex = (this.dayOffset + 2) % 7;
    }

    private void compute() {
        this.computeJieQi();
        this.computeYear();
        this.computeMonth();
        this.computeDay();
        this.computeTime();
        this.computeWeek();
    }

    public static Lunar fromDate(Date date) {
        return new Lunar(date);
    }

    public static Lunar fromYmd(int lunarYear, int lunarMonth, int lunarDay) {
        return new Lunar(lunarYear, lunarMonth, lunarDay);
    }

    public static Lunar fromYmdHms(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute, int second) {
        return new Lunar(lunarYear, lunarMonth, lunarDay, hour, minute, second);
    }

    @Deprecated
    public String getGan() {
        return this.getYearGan();
    }

    public String getYearGan() {
        return LunarUtil.GAN[this.yearGanIndex + 1];
    }

    public String getYearGanByLiChun() {
        return LunarUtil.GAN[this.yearGanIndexByLiChun + 1];
    }

    public String getYearGanExact() {
        return LunarUtil.GAN[this.yearGanIndexExact + 1];
    }

    @Deprecated
    public String getZhi() {
        return this.getYearZhi();
    }

    public String getYearZhi() {
        return LunarUtil.ZHI[this.yearZhiIndex + 1];
    }

    public String getYearZhiByLiChun() {
        return LunarUtil.ZHI[this.yearZhiIndexByLiChun + 1];
    }

    public String getYearZhiExact() {
        return LunarUtil.ZHI[this.yearZhiIndexExact + 1];
    }

    public String getYearInGanZhi() {
        return this.getYearGan() + this.getYearZhi();
    }

    public String getYearInGanZhiByLiChun() {
        return this.getYearGanByLiChun() + this.getYearZhiByLiChun();
    }

    public String getYearInGanZhiExact() {
        return this.getYearGanExact() + this.getYearZhiExact();
    }

    public String getMonthInGanZhi() {
        return this.getMonthGan() + this.getMonthZhi();
    }

    public String getMonthInGanZhiExact() {
        return this.getMonthGanExact() + this.getMonthZhiExact();
    }

    public String getMonthGan() {
        return LunarUtil.GAN[this.monthGanIndex + 1];
    }

    public String getMonthGanExact() {
        return LunarUtil.GAN[this.monthGanIndexExact + 1];
    }

    public String getMonthZhi() {
        return LunarUtil.ZHI[this.monthZhiIndex + 1];
    }

    public String getMonthZhiExact() {
        return LunarUtil.ZHI[this.monthZhiIndexExact + 1];
    }

    public String getDayInGanZhi() {
        return this.getDayGan() + this.getDayZhi();
    }

    public String getDayInGanZhiExact() {
        return this.getDayGanExact() + this.getDayZhiExact();
    }

    public String getDayGan() {
        return LunarUtil.GAN[this.dayGanIndex + 1];
    }

    public String getDayGanExact() {
        return LunarUtil.GAN[this.dayGanIndexExact + 1];
    }

    public String getDayZhi() {
        return LunarUtil.ZHI[this.dayZhiIndex + 1];
    }

    public String getDayZhiExact() {
        return LunarUtil.ZHI[this.dayZhiIndexExact + 1];
    }

    @Deprecated
    public String getShengxiao() {
        return this.getYearShengXiao();
    }

    public String getYearShengXiao() {
        return LunarUtil.SHENGXIAO[this.yearZhiIndex + 1];
    }

    public String getYearShengXiaoByLiChun() {
        return LunarUtil.SHENGXIAO[this.yearZhiIndexByLiChun + 1];
    }

    public String getYearShengXiaoExact() {
        return LunarUtil.SHENGXIAO[this.yearZhiIndexExact + 1];
    }

    public String getMonthShengXiao() {
        return LunarUtil.SHENGXIAO[this.monthZhiIndex + 1];
    }

    public String getDayShengXiao() {
        return LunarUtil.SHENGXIAO[this.dayZhiIndex + 1];
    }

    public String getTimeShengXiao() {
        return LunarUtil.SHENGXIAO[this.timeZhiIndex + 1];
    }

    public String getYearInChinese() {
        String y = this.year + "";
        StringBuilder s = new StringBuilder();
        int j = y.length();
        for (int i = 0; i < j; ++i) {
            s.append(LunarUtil.NUMBER[y.charAt(i) - 48]);
        }
        return s.toString();
    }

    public String getMonthInChinese() {
        return (this.month < 0 ? "\u95f0" : "") + LunarUtil.MONTH[Math.abs(this.month)];
    }

    public String getDayInChinese() {
        return LunarUtil.DAY[this.day];
    }

    public String getTimeZhi() {
        return LunarUtil.ZHI[this.timeZhiIndex + 1];
    }

    public String getTimeGan() {
        return LunarUtil.GAN[this.timeGanIndex + 1];
    }

    public String getTimeInGanZhi() {
        return this.getTimeGan() + this.getTimeZhi();
    }

    public String getSeason() {
        return LunarUtil.SEASON[Math.abs(this.month)];
    }

    public String getJie() {
        for (String jie : LunarUtil.JIE) {
            Solar d = this.jieQi.get(jie);
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return jie;
        }
        return "";
    }

    public String getQi() {
        for (String qi : LunarUtil.QI) {
            Solar d = this.jieQi.get(qi);
            if (d.getYear() != this.solar.getYear() || d.getMonth() != this.solar.getMonth() || d.getDay() != this.solar.getDay()) continue;
            return qi;
        }
        Solar d = this.jieQi.get("DONG_ZHI");
        if (d.getYear() == this.solar.getYear() && d.getMonth() == this.solar.getMonth() && d.getDay() == this.solar.getDay()) {
            return "\u51ac\u81f3";
        }
        return "";
    }

    public int getWeek() {
        return this.weekIndex;
    }

    public String getWeekInChinese() {
        return SolarUtil.WEEK[this.getWeek()];
    }

    public String getXiu() {
        return LunarUtil.XIU.get(this.getDayZhi() + this.getWeek());
    }

    public String getXiuLuck() {
        return LunarUtil.XIU_LUCK.get(this.getXiu());
    }

    public String getXiuSong() {
        return LunarUtil.XIU_SONG.get(this.getXiu());
    }

    public String getZheng() {
        return LunarUtil.ZHENG.get(this.getXiu());
    }

    public String getAnimal() {
        return LunarUtil.ANIMAL.get(this.getXiu());
    }

    public String getGong() {
        return LunarUtil.GONG.get(this.getXiu());
    }

    public String getShou() {
        return LunarUtil.SHOU.get(this.getGong());
    }

    public List<String> getFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        String f = LunarUtil.FESTIVAL.get(this.month + "-" + this.day);
        if (null != f) {
            l.add(f);
        }
        return l;
    }

    public List<String> getOtherFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        List<String> fs = LunarUtil.OTHER_FESTIVAL.get(this.month + "-" + this.day);
        if (null != fs) {
            l.addAll(fs);
        }
        return l;
    }

    private Solar toSolar() {
        Calendar c = Calendar.getInstance();
        c.set(1901, 0, 1, this.hour, this.minute, this.second);
        c.add(5, this.dayOffset);
        return new Solar(c);
    }

    public String getPengZuGan() {
        return LunarUtil.PENGZU_GAN[this.dayGanIndex + 1];
    }

    public String getPengZuZhi() {
        return LunarUtil.PENGZU_ZHI[this.dayZhiIndex + 1];
    }

    public String getPositionXi() {
        return this.getDayPositionXi();
    }

    public String getPositionXiDesc() {
        return this.getDayPositionXiDesc();
    }

    public String getPositionYangGui() {
        return this.getDayPositionYangGui();
    }

    public String getPositionYangGuiDesc() {
        return this.getDayPositionYangGuiDesc();
    }

    public String getPositionYinGui() {
        return this.getDayPositionYinGui();
    }

    public String getPositionYinGuiDesc() {
        return this.getDayPositionYinGuiDesc();
    }

    public String getPositionFu() {
        return this.getDayPositionFu();
    }

    public String getPositionFuDesc() {
        return this.getDayPositionFuDesc();
    }

    public String getPositionCai() {
        return this.getDayPositionCai();
    }

    public String getPositionCaiDesc() {
        return this.getDayPositionCaiDesc();
    }

    public String getDayPositionXi() {
        return LunarUtil.POSITION_XI[this.dayGanIndex + 1];
    }

    public String getDayPositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionXi());
    }

    public String getDayPositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.dayGanIndex + 1];
    }

    public String getDayPositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionYangGui());
    }

    public String getDayPositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.dayGanIndex + 1];
    }

    public String getDayPositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionYinGui());
    }

    public String getDayPositionFu() {
        return LunarUtil.POSITION_FU[this.dayGanIndex + 1];
    }

    public String getDayPositionFuDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionFu());
    }

    public String getDayPositionCai() {
        return LunarUtil.POSITION_CAI[this.dayGanIndex + 1];
    }

    public String getDayPositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getDayPositionCai());
    }

    public String getTimePositionXi() {
        return LunarUtil.POSITION_XI[this.timeGanIndex + 1];
    }

    public String getTimePositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionXi());
    }

    public String getTimePositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.timeGanIndex + 1];
    }

    public String getTimePositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionYangGui());
    }

    public String getTimePositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.timeGanIndex + 1];
    }

    public String getTimePositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionYinGui());
    }

    public String getTimePositionFu() {
        return LunarUtil.POSITION_FU[this.timeGanIndex + 1];
    }

    public String getTimePositionFuDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionFu());
    }

    public String getTimePositionCai() {
        return LunarUtil.POSITION_CAI[this.timeGanIndex + 1];
    }

    public String getTimePositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getTimePositionCai());
    }

    @Deprecated
    public String getChong() {
        return this.getDayChong();
    }

    @Deprecated
    public String getChongGan() {
        return this.getDayChongGan();
    }

    @Deprecated
    public String getChongGanTie() {
        return this.getDayChongGanTie();
    }

    @Deprecated
    public String getChongShengXiao() {
        return this.getDayChongShengXiao();
    }

    @Deprecated
    public String getChongDesc() {
        return this.getDayChongDesc();
    }

    @Deprecated
    public String getSha() {
        return this.getDaySha();
    }

    public String getYearNaYin() {
        return LunarUtil.NAYIN.get(this.getYearInGanZhi());
    }

    public String getMonthNaYin() {
        return LunarUtil.NAYIN.get(this.getMonthInGanZhi());
    }

    public String getDayNaYin() {
        return LunarUtil.NAYIN.get(this.getDayInGanZhi());
    }

    public String getTimeNaYin() {
        return LunarUtil.NAYIN.get(this.getTimeInGanZhi());
    }

    public List<String> getBaZi() {
        ArrayList<String> l = new ArrayList<String>(4);
        l.add(this.getYearInGanZhiExact());
        l.add(this.getMonthInGanZhiExact());
        l.add(this.getDayInGanZhiExact());
        l.add(this.getTimeInGanZhi());
        return l;
    }

    public List<String> getBaZiWuXing() {
        List<String> baZi = this.getBaZi();
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        for (String ganZhi : baZi) {
            String gan = ganZhi.substring(0, 1);
            String zhi = ganZhi.substring(1);
            l.add(LunarUtil.WU_XING_GAN.get(gan) + LunarUtil.WU_XING_ZHI.get(zhi));
        }
        return l;
    }

    public List<String> getBaZiNaYin() {
        List<String> baZi = this.getBaZi();
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        for (String ganZhi : baZi) {
            l.add(LunarUtil.NAYIN.get(ganZhi));
        }
        return l;
    }

    public List<String> getBaZiShiShenGan() {
        List<String> baZi = this.getBaZi();
        String yearGan = baZi.get(0).substring(0, 1);
        String monthGan = baZi.get(1).substring(0, 1);
        String dayGan = baZi.get(2).substring(0, 1);
        String timeGan = baZi.get(3).substring(0, 1);
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        l.add(LunarUtil.SHI_SHEN_GAN.get(dayGan + yearGan));
        l.add(LunarUtil.SHI_SHEN_GAN.get(dayGan + monthGan));
        l.add("\u65e5\u4e3b");
        l.add(LunarUtil.SHI_SHEN_GAN.get(dayGan + timeGan));
        return l;
    }

    public List<String> getBaZiShiShenZhi() {
        List<String> baZi = this.getBaZi();
        String dayGan = baZi.get(2).substring(0, 1);
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        for (String ganZhi : baZi) {
            String zhi = ganZhi.substring(1);
            l.add(LunarUtil.SHI_SHEN_ZHI.get(dayGan + zhi + LunarUtil.ZHI_HIDE_GAN.get(zhi).get(0)));
        }
        return l;
    }

    public String getZhiXing() {
        int offset = this.dayZhiIndex - this.monthZhiIndex;
        if (offset < 0) {
            offset += 12;
        }
        return LunarUtil.ZHI_XING[offset + 1];
    }

    public String getDayTianShen() {
        String monthZhi = this.getMonthZhi();
        int offset = LunarUtil.ZHI_TIAN_SHEN_OFFSET.get(monthZhi);
        return LunarUtil.TIAN_SHEN[(this.dayZhiIndex + offset) % 12 + 1];
    }

    public String getTimeTianShen() {
        String dayZhi = this.getDayZhiExact();
        int offset = LunarUtil.ZHI_TIAN_SHEN_OFFSET.get(dayZhi);
        return LunarUtil.TIAN_SHEN[(this.timeZhiIndex + offset) % 12 + 1];
    }

    public String getDayTianShenType() {
        return LunarUtil.TIAN_SHEN_TYPE.get(this.getDayTianShen());
    }

    public String getTimeTianShenType() {
        return LunarUtil.TIAN_SHEN_TYPE.get(this.getTimeTianShen());
    }

    public String getDayTianShenLuck() {
        return LunarUtil.TIAN_SHEN_TYPE_LUCK.get(this.getDayTianShenType());
    }

    public String getTimeTianShenLuck() {
        return LunarUtil.TIAN_SHEN_TYPE_LUCK.get(this.getTimeTianShenType());
    }

    public String getDayPositionTai() {
        int offset = this.dayGanIndex - this.dayZhiIndex;
        if (offset < 0) {
            offset += 12;
        }
        return LunarUtil.POSITION_TAI_DAY[offset * 5 + this.dayGanIndex];
    }

    public String getMonthPositionTai() {
        if (this.month < 0) {
            return "";
        }
        return LunarUtil.POSITION_TAI_MONTH[this.month - 1];
    }

    public List<String> getDayYi() {
        return LunarUtil.getDayYi(this.getMonthInGanZhiExact(), this.getDayInGanZhi());
    }

    public List<String> getDayJi() {
        return LunarUtil.getDayJi(this.getMonthInGanZhiExact(), this.getDayInGanZhi());
    }

    public List<String> getDayJiShen() {
        return LunarUtil.getDayJiShen(this.getMonth(), this.getDayInGanZhi());
    }

    public List<String> getDayXiongSha() {
        return LunarUtil.getDayXiongSha(this.getMonth(), this.getDayInGanZhi());
    }

    public String getDayChong() {
        return LunarUtil.CHONG[this.dayZhiIndex + 1];
    }

    public String getDaySha() {
        return LunarUtil.SHA.get(this.getDayZhi());
    }

    public String getDayChongDesc() {
        return "(" + this.getDayChongGan() + this.getDayChong() + ")" + this.getDayChongShengXiao();
    }

    public String getDayChongShengXiao() {
        String chong = this.getDayChong();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(chong)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getDayChongGan() {
        return LunarUtil.CHONG_GAN[this.dayGanIndex + 1];
    }

    public String getDayChongGanTie() {
        return LunarUtil.CHONG_GAN_TIE[this.dayGanIndex + 1];
    }

    public String getTimeChong() {
        return LunarUtil.CHONG[this.timeZhiIndex + 1];
    }

    public String getTimeSha() {
        return LunarUtil.SHA.get(this.getTimeZhi());
    }

    public String getTimeChongShengXiao() {
        String chong = this.getTimeChong();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(chong)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getTimeChongDesc() {
        return "(" + this.getTimeChongGan() + this.getTimeChong() + ")" + this.getTimeChongShengXiao();
    }

    public String getTimeChongGan() {
        return LunarUtil.CHONG_GAN[this.timeGanIndex + 1];
    }

    public String getTimeChongGanTie() {
        return LunarUtil.CHONG_GAN_TIE[this.timeGanIndex + 1];
    }

    public List<String> getTimeYi() {
        return LunarUtil.getTimeYi(this.getDayInGanZhiExact(), this.getTimeInGanZhi());
    }

    public List<String> getTimeJi() {
        return LunarUtil.getTimeJi(this.getDayInGanZhiExact(), this.getTimeInGanZhi());
    }

    public String getYueXiang() {
        return LunarUtil.YUE_XIANG[this.day];
    }

    public NineStar getYearNineStar() {
        int index = 0 - (this.year - 1900) % 9;
        if (index < 0) {
            index += 9;
        }
        return new NineStar(index);
    }

    public NineStar getMonthNineStar() {
        int start = 2;
        String yearZhi = this.getYearZhi();
        if ("\u5b50\u5348\u536f\u9149".contains(yearZhi)) {
            start = 8;
        } else if ("\u8fb0\u620c\u4e11\u672a".contains(yearZhi)) {
            start = 5;
        }
        int monthIndex = this.monthZhiIndex - 2;
        int index = start - monthIndex - 1;
        if (index < 0) {
            index += 9;
        }
        return new NineStar(index);
    }

    public NineStar getDayNineStar() {
        int index;
        String solarYmd = this.solar.toYmd();
        String yuShui = this.jieQi.get("\u96e8\u6c34").toYmd();
        String guYu = this.jieQi.get("\u8c37\u96e8").toYmd();
        String xiaZhi = this.jieQi.get("\u590f\u81f3").toYmd();
        String chuShu = this.jieQi.get("\u5904\u6691").toYmd();
        String shuangJiang = this.jieQi.get("\u971c\u964d").toYmd();
        int start = 6;
        boolean asc = false;
        if (solarYmd.compareTo(this.jieQi.get("\u51ac\u81f3").toYmd()) >= 0 && solarYmd.compareTo(yuShui) < 0) {
            asc = true;
            start = 1;
        } else if (solarYmd.compareTo(yuShui) >= 0 && solarYmd.compareTo(guYu) < 0) {
            asc = true;
            start = 7;
        } else if (solarYmd.compareTo(guYu) >= 0 && solarYmd.compareTo(xiaZhi) < 0) {
            asc = true;
            start = 4;
        } else if (solarYmd.compareTo(xiaZhi) >= 0 && solarYmd.compareTo(chuShu) < 0) {
            start = 9;
        } else if (solarYmd.compareTo(chuShu) >= 0 && solarYmd.compareTo(shuangJiang) < 0) {
            start = 3;
        }
        int ganZhiIndex = LunarUtil.getJiaZiIndex(this.getDayInGanZhi()) % 9;
        int n = index = asc ? start + ganZhiIndex - 1 : start - ganZhiIndex - 1;
        if (index > 8) {
            index -= 9;
        }
        if (index < 0) {
            index += 9;
        }
        return new NineStar(index);
    }

    public NineStar getTimeNineStar() {
        int index;
        String solarYmd = this.solar.toYmd();
        boolean asc = false;
        if (solarYmd.compareTo(this.jieQi.get("\u51ac\u81f3").toYmd()) >= 0 && solarYmd.compareTo(this.jieQi.get("\u590f\u81f3").toYmd()) < 0) {
            asc = true;
        }
        int start = asc ? 7 : 3;
        String dayZhi = this.getDayZhi();
        if ("\u5b50\u5348\u536f\u9149".contains(dayZhi)) {
            start = asc ? 1 : 9;
        } else if ("\u8fb0\u620c\u4e11\u672a".contains(dayZhi)) {
            start = asc ? 4 : 6;
        }
        int n = index = asc ? start + this.timeZhiIndex - 1 : start - this.timeZhiIndex - 1;
        if (index > 8) {
            index -= 9;
        }
        if (index < 0) {
            index += 9;
        }
        return new NineStar(index);
    }

    public Map<String, Solar> getJieQiTable() {
        return this.jieQi;
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this.toString());
        s.append(" ");
        s.append(this.getYearInGanZhi());
        s.append("(");
        s.append(this.getYearShengXiao());
        s.append(")\u5e74 ");
        s.append(this.getMonthInGanZhi());
        s.append("(");
        s.append(this.getMonthShengXiao());
        s.append(")\u6708 ");
        s.append(this.getDayInGanZhi());
        s.append("(");
        s.append(this.getDayShengXiao());
        s.append(")\u65e5 ");
        s.append(this.getTimeZhi());
        s.append("(");
        s.append(this.getTimeShengXiao());
        s.append(")\u65f6 \u7eb3\u97f3[");
        s.append(this.getYearNaYin());
        s.append(" ");
        s.append(this.getMonthNaYin());
        s.append(" ");
        s.append(this.getDayNaYin());
        s.append(" ");
        s.append(this.getTimeNaYin());
        s.append("] \u661f\u671f");
        s.append(this.getWeekInChinese());
        for (String f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        for (String f : this.getOtherFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        String jq = this.getJie() + this.getQi();
        if (jq.length() > 0) {
            s.append(" [");
            s.append(jq);
            s.append("]");
        }
        s.append(" ");
        s.append(this.getGong());
        s.append("\u65b9");
        s.append(this.getShou());
        s.append(" \u661f\u5bbf[");
        s.append(this.getXiu());
        s.append(this.getZheng());
        s.append(this.getAnimal());
        s.append("](");
        s.append(this.getXiuLuck());
        s.append(") \u5f6d\u7956\u767e\u5fcc[");
        s.append(this.getPengZuGan());
        s.append(" ");
        s.append(this.getPengZuZhi());
        s.append("] \u559c\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionXi());
        s.append("](");
        s.append(this.getDayPositionXiDesc());
        s.append(") \u9633\u8d35\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionYangGui());
        s.append("](");
        s.append(this.getDayPositionYangGuiDesc());
        s.append(") \u9634\u8d35\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionYinGui());
        s.append("](");
        s.append(this.getDayPositionYinGuiDesc());
        s.append(") \u798f\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionFu());
        s.append("](");
        s.append(this.getDayPositionFuDesc());
        s.append(") \u8d22\u795e\u65b9\u4f4d[");
        s.append(this.getDayPositionCai());
        s.append("](");
        s.append(this.getDayPositionCaiDesc());
        s.append(") \u51b2[");
        s.append(this.getDayChongDesc());
        s.append("] \u715e[");
        s.append(this.getDaySha());
        s.append("]");
        return s.toString();
    }

    public String toString() {
        return this.getYearInChinese() + "\u5e74" + this.getMonthInChinese() + "\u6708" + this.getDayInChinese();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public Solar getSolar() {
        return this.solar;
    }
}

