/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LunarUtil {
    public static final int BASE_YEAR = 1900;
    public static final int BASE_MONTH = 11;
    public static final int BASE_DAY = 11;
    public static final int BASE_INDEX = 0;
    public static final int BASE_DAY_GANZHI_INDEX = 15;
    public static final int BASE_MONTH_ZHI_INDEX = 2;
    public static final int BASE_WEEK_INDEX = 2;
    public static final int[] LEAP_MONTH_YEAR = new int[]{6, 14, 19, 25, 33, 36, 38, 41, 44, 52, 55, 79, 117, 136, 147, 150, 155, 158, 185, 193};
    public static final int[] LUNAR_MONTH = new int[]{0, 4, 173, 8, 90, 1, 213, 84, 180, 9, 100, 5, 89, 69, 149, 10, 166, 4, 85, 36, 173, 8, 90, 98, 218, 4, 180, 5, 180, 85, 82, 13, 148, 10, 74, 42, 86, 2, 109, 113, 109, 1, 218, 2, 210, 82, 169, 5, 73, 13, 42, 69, 43, 9, 86, 1, 181, 32, 109, 1, 89, 105, 212, 10, 168, 5, 169, 86, 165, 4, 43, 9, 158, 56, 182, 8, 236, 116, 108, 5, 212, 10, 228, 106, 82, 5, 149, 10, 90, 66, 91, 4, 182, 4, 180, 34, 106, 5, 82, 117, 201, 10, 82, 5, 53, 85, 77, 10, 90, 2, 93, 49, 181, 2, 106, 138, 104, 5, 169, 10, 138, 106, 42, 5, 45, 9, 170, 72, 90, 1, 181, 9, 176, 57, 100, 5, 37, 117, 149, 10, 150, 4, 77, 84, 173, 4, 218, 4, 212, 68, 180, 5, 84, 133, 82, 13, 146, 10, 86, 106, 86, 2, 109, 2, 106, 65, 218, 2, 178, 161, 169, 5, 73, 13, 10, 109, 42, 9, 86, 1, 173, 80, 109, 1, 217, 2, 209, 58, 168, 5, 41, 133, 165, 12, 42, 9, 150, 84, 182, 8, 108, 9, 100, 69, 212, 10, 164, 5, 81, 37, 149, 10, 42, 114, 91, 4, 182, 4, 172, 82, 106, 5, 210, 10, 162, 74, 74, 5, 85, 148, 45, 10, 90, 2, 117, 97, 181, 2, 106, 3, 97, 69, 169, 10, 74, 5, 37, 37, 45, 9, 154, 104, 218, 8, 180, 9, 168, 89, 84, 3, 165, 10, 145, 58, 150, 4, 173, 176, 173, 4, 218, 4, 244, 98, 180, 5, 84, 11, 68, 93, 82, 10, 149, 4, 85, 34, 109, 2, 90, 113, 218, 2, 170, 5, 178, 85, 73, 11, 74, 10, 45, 57, 54, 1, 109, 128, 109, 1, 217, 2, 233, 106, 168, 5, 41, 11, 154, 76, 170, 8, 182, 8, 180, 56, 108, 9, 84, 117, 212, 10, 164, 5, 69, 85, 149, 10, 154, 4, 85, 68, 181, 4, 106, 130, 106, 5, 210, 10, 146, 106, 74, 5, 85, 10, 42, 74, 90, 2, 181, 2, 178, 49, 105, 3, 49, 115, 169, 10, 74, 5, 45, 85, 45, 9, 90, 1, 213, 72, 180, 9, 104, 137, 84, 11, 164, 10, 165, 106, 149, 4, 173, 8, 106, 68, 218, 4, 116, 5, 176, 37, 84, 3};
    public static final int[][] JIE_YEAR = new int[][]{{13, 49, 85, 117, 149, 185, 201, 250, 250}, {13, 45, 81, 117, 149, 185, 201, 250, 250}, {13, 48, 84, 112, 148, 184, 200, 201, 250}, {13, 45, 76, 108, 140, 172, 200, 201, 250}, {13, 44, 72, 104, 132, 168, 200, 201, 250}, {5, 33, 68, 96, 124, 152, 188, 200, 201}, {29, 57, 85, 120, 148, 176, 200, 201, 250}, {13, 48, 76, 104, 132, 168, 196, 200, 201}, {25, 60, 88, 120, 148, 184, 200, 201, 250}, {16, 44, 76, 108, 144, 172, 200, 201, 250}, {28, 60, 92, 124, 160, 192, 200, 201, 250}, {17, 53, 85, 124, 156, 188, 200, 201, 250}};
    public static final int[][] JIE_MAP = new int[][]{{7, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5}, {5, 4, 5, 5, 5, 4, 4, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 3, 3, 4, 4, 3, 3, 3}, {6, 6, 6, 7, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 5}, {5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 4, 4, 5, 5, 4, 4, 4, 5, 4, 4, 4, 4, 5}, {6, 6, 6, 7, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 5}, {6, 6, 7, 7, 6, 6, 6, 7, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 5}, {7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 6, 6, 6, 7, 7}, {8, 8, 8, 9, 8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 7}, {8, 8, 8, 9, 8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 7}, {9, 9, 9, 9, 8, 9, 9, 9, 8, 8, 9, 9, 8, 8, 8, 9, 8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 8}, {8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 7}, {7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 6, 6, 6, 7, 7}};
    public static final int[][] QI_YEAR = new int[][]{{13, 45, 81, 113, 149, 185, 201}, {21, 57, 93, 125, 161, 193, 201}, {21, 56, 88, 120, 152, 188, 200, 201}, {21, 49, 81, 116, 144, 176, 200, 201}, {17, 49, 77, 112, 140, 168, 200, 201}, {28, 60, 88, 116, 148, 180, 200, 201}, {25, 53, 84, 112, 144, 172, 200, 201}, {29, 57, 89, 120, 148, 180, 200, 201}, {17, 45, 73, 108, 140, 168, 200, 201}, {28, 60, 92, 124, 160, 192, 200, 201}, {16, 44, 80, 112, 148, 180, 200, 201}, {17, 53, 88, 120, 156, 188, 200, 201}};
    public static final int[][] QI_MAP = new int[][]{{21, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 19, 20, 20, 20, 19, 19, 20}, {20, 19, 19, 20, 20, 19, 19, 19, 19, 19, 19, 19, 19, 18, 19, 19, 19, 18, 18, 19, 19, 18, 18, 18, 18, 18, 18, 18}, {21, 21, 21, 22, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 21, 20, 20, 20, 20, 19, 20, 20, 20, 20}, {20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 21, 20, 20, 20, 20, 19, 20, 20, 20, 19, 19, 20, 20, 19, 19, 19, 20, 20}, {21, 22, 22, 22, 21, 21, 22, 22, 21, 21, 21, 22, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 21, 21}, {22, 22, 22, 22, 21, 22, 22, 22, 21, 21, 22, 22, 21, 21, 21, 22, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 21}, {23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 22, 22, 22, 22, 23}, {23, 24, 24, 24, 23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 23}, {23, 24, 24, 24, 23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 23}, {24, 24, 24, 24, 23, 24, 24, 24, 23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 23}, {23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 22, 22, 22, 22, 21, 22, 22, 22, 21, 21, 22, 22, 22}, {22, 22, 23, 23, 22, 22, 22, 23, 22, 22, 22, 22, 21, 22, 22, 22, 21, 21, 22, 22, 21, 21, 21, 22, 21, 21, 21, 21, 22}};
    public static final String[] GAN = new String[]{"", "\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    public static final String[] POSITION_XI = new String[]{"", "\u826e", "\u4e7e", "\u5764", "\u79bb", "\u5dfd", "\u826e", "\u4e7e", "\u5764", "\u79bb", "\u5dfd"};
    public static final String[] POSITION_YANG_GUI = new String[]{"", "\u5764", "\u5764", "\u5151", "\u4e7e", "\u826e", "\u574e", "\u79bb", "\u826e", "\u9707", "\u5dfd"};
    public static final String[] POSITION_YIN_GUI = new String[]{"", "\u826e", "\u574e", "\u4e7e", "\u5151", "\u5764", "\u5764", "\u826e", "\u79bb", "\u5dfd", "\u9707"};
    public static final String[] POSITION_FU = new String[]{"", "\u5dfd", "\u5dfd", "\u9707", "\u9707", "\u574e", "\u79bb", "\u5764", "\u5764", "\u4e7e", "\u5151"};
    public static final String[] POSITION_CAI = new String[]{"", "\u826e", "\u826e", "\u5764", "\u5764", "\u574e", "\u574e", "\u9707", "\u9707", "\u79bb", "\u79bb"};
    public static final String[] ZHI = new String[]{"", "\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    public static final String[] PENGZU_GAN = new String[]{"", "\u7532\u4e0d\u5f00\u4ed3\u8d22\u7269\u8017\u6563", "\u4e59\u4e0d\u683d\u690d\u5343\u682a\u4e0d\u957f", "\u4e19\u4e0d\u4fee\u7076\u5fc5\u89c1\u707e\u6b83", "\u4e01\u4e0d\u5243\u5934\u5934\u5fc5\u751f\u75ae", "\u620a\u4e0d\u53d7\u7530\u7530\u4e3b\u4e0d\u7965", "\u5df1\u4e0d\u7834\u5238\u4e8c\u6bd4\u5e76\u4ea1", "\u5e9a\u4e0d\u7ecf\u7edc\u7ec7\u673a\u865a\u5f20", "\u8f9b\u4e0d\u5408\u9171\u4e3b\u4eba\u4e0d\u5c1d", "\u58ec\u4e0d\u6cf1\u6c34\u66f4\u96be\u63d0\u9632", "\u7678\u4e0d\u8bcd\u8bbc\u7406\u5f31\u654c\u5f3a"};
    public static final String[] PENGZU_ZHI = new String[]{"", "\u5b50\u4e0d\u95ee\u535c\u81ea\u60f9\u7978\u6b83", "\u4e11\u4e0d\u51a0\u5e26\u4e3b\u4e0d\u8fd8\u4e61", "\u5bc5\u4e0d\u796d\u7940\u795e\u9b3c\u4e0d\u5c1d", "\u536f\u4e0d\u7a7f\u4e95\u6c34\u6cc9\u4e0d\u9999", "\u8fb0\u4e0d\u54ed\u6ce3\u5fc5\u4e3b\u91cd\u4e27", "\u5df3\u4e0d\u8fdc\u884c\u8d22\u7269\u4f0f\u85cf", "\u5348\u4e0d\u82eb\u76d6\u5c4b\u4e3b\u66f4\u5f20", "\u672a\u4e0d\u670d\u836f\u6bd2\u6c14\u5165\u80a0", "\u7533\u4e0d\u5b89\u5e8a\u9b3c\u795f\u5165\u623f", "\u9149\u4e0d\u4f1a\u5ba2\u9189\u5750\u98a0\u72c2", "\u620c\u4e0d\u5403\u72ac\u4f5c\u602a\u4e0a\u5e8a", "\u4ea5\u4e0d\u5ac1\u5a36\u4e0d\u5229\u65b0\u90ce"};
    public static final String[] NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    public static final String[] MONTH = new String[]{"", "\u6b63", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396", "\u62fe", "\u51ac", "\u814a"};
    public static final String[] SEASON = new String[]{"", "\u5b5f\u6625", "\u4ef2\u6625", "\u5b63\u6625", "\u5b5f\u590f", "\u4ef2\u590f", "\u5b63\u590f", "\u5b5f\u79cb", "\u4ef2\u79cb", "\u5b63\u79cb", "\u5b5f\u51ac", "\u4ef2\u51ac", "\u5b63\u51ac"};
    public static final String[] SHENGXIAO = new String[]{"", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    public static final String[] QI = new String[]{"\u5927\u5bd2", "\u96e8\u6c34", "\u6625\u5206", "\u8c37\u96e8", "\u590f\u6ee1", "\u590f\u81f3", "\u5927\u6691", "\u5904\u6691", "\u79cb\u5206", "\u971c\u964d", "\u5c0f\u96ea", "\u51ac\u81f3"};
    public static final String[] JIE = new String[]{"\u5c0f\u5bd2", "\u7acb\u6625", "\u60ca\u86f0", "\u6e05\u660e", "\u7acb\u590f", "\u8292\u79cd", "\u5c0f\u6691", "\u7acb\u79cb", "\u767d\u9732", "\u5bd2\u9732", "\u7acb\u51ac", "\u5927\u96ea"};
    public static final String[] DAY = new String[]{"", "\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    public static final Map<String, String> FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-1", "\u6625\u8282");
            this.put("1-15", "\u5143\u5bb5\u8282");
            this.put("2-2", "\u9f99\u5934\u8282");
            this.put("5-5", "\u7aef\u5348\u8282");
            this.put("7-7", "\u4e03\u5915\u8282");
            this.put("8-15", "\u4e2d\u79cb\u8282");
            this.put("9-9", "\u91cd\u9633\u8282");
            this.put("12-8", "\u814a\u516b\u8282");
            this.put("12-30", "\u9664\u5915");
        }
    };
    public static final Map<String, List<String>> OTHER_FESTIVAL = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-1", Collections.nCopies(1, "\u5f25\u52d2\u4f5b\u5723\u8bde"));
            this.put("1-8", Collections.nCopies(1, "\u4e94\u6bbf\u960e\u7f57\u5929\u5b50\u8bde"));
            this.put("1-9", Collections.nCopies(1, "\u7389\u7687\u4e0a\u5e1d\u8bde"));
            this.put("2-1", Collections.nCopies(1, "\u4e00\u6bbf\u79e6\u5e7f\u738b\u8bde"));
            this.put("2-2", Collections.nCopies(1, "\u798f\u5fb7\u571f\u5730\u6b63\u795e\u8bde"));
            this.put("2-3", Collections.nCopies(1, "\u6587\u660c\u5e1d\u541b\u8bde"));
            this.put("2-6", Collections.nCopies(1, "\u4e1c\u534e\u5e1d\u541b\u8bde"));
            this.put("2-8", Collections.nCopies(1, "\u91ca\u8fe6\u725f\u5c3c\u4f5b\u51fa\u5bb6"));
            this.put("2-15", Collections.nCopies(1, "\u91ca\u8fe6\u725f\u5c3c\u4f5b\u822c\u6d85\u69c3"));
            this.put("2-17", Collections.nCopies(1, "\u4e1c\u65b9\u675c\u5c06\u519b\u8bde"));
            this.put("2-18", Collections.nCopies(1, "\u81f3\u5723\u5148\u5e08\u5b54\u5b50\u8bb3\u8fb0"));
            this.put("2-19", Collections.nCopies(1, "\u89c2\u97f3\u5927\u58eb\u8bde"));
            this.put("2-21", Collections.nCopies(1, "\u666e\u8d24\u83e9\u8428\u8bde"));
            this.put("3-1", Collections.nCopies(1, "\u4e8c\u6bbf\u695a\u6c5f\u738b\u8bde"));
            this.put("3-3", Collections.nCopies(1, "\u7384\u5929\u4e0a\u5e1d\u8bde"));
            this.put("3-8", Collections.nCopies(1, "\u516d\u6bbf\u535e\u57ce\u738b\u8bde"));
            this.put("3-15", Collections.nCopies(1, "\u660a\u5929\u4e0a\u5e1d\u8bde"));
            this.put("3-16", Collections.nCopies(1, "\u51c6\u63d0\u83e9\u8428\u8bde"));
            this.put("3-19", Collections.nCopies(1, "\u4e2d\u5cb3\u5927\u5e1d\u8bde"));
            this.put("3-20", Collections.nCopies(1, "\u5b50\u5b59\u5a18\u5a18\u8bde"));
            this.put("3-27", Collections.nCopies(1, "\u4e03\u6bbf\u6cf0\u5c71\u738b\u8bde"));
            this.put("3-28", Collections.nCopies(1, "\u82cd\u9889\u81f3\u5723\u5148\u5e08\u8bde"));
            this.put("4-1", Collections.nCopies(1, "\u516b\u6bbf\u90fd\u5e02\u738b\u8bde"));
            this.put("4-4", Collections.nCopies(1, "\u6587\u6b8a\u83e9\u8428\u8bde"));
            this.put("4-8", Collections.nCopies(1, "\u91ca\u8fe6\u725f\u5c3c\u4f5b\u8bde"));
            this.put("4-14", Collections.nCopies(1, "\u7eaf\u9633\u7956\u5e08\u8bde"));
            this.put("4-15", Collections.nCopies(1, "\u949f\u79bb\u7956\u5e08\u8bde"));
            this.put("4-17", Collections.nCopies(1, "\u5341\u6bbf\u8f6c\u8f6e\u738b\u8bde"));
            this.put("4-18", Collections.nCopies(1, "\u7d2b\u5fbd\u5927\u5e1d\u8bde"));
            this.put("4-20", Collections.nCopies(1, "\u773c\u5149\u5723\u6bcd\u8bde"));
            this.put("5-1", Collections.nCopies(1, "\u5357\u6781\u957f\u751f\u5927\u5e1d\u8bde"));
            this.put("5-8", Collections.nCopies(1, "\u5357\u65b9\u4e94\u9053\u8bde"));
            this.put("5-11", Collections.nCopies(1, "\u5929\u4e0b\u90fd\u57ce\u968d\u8bde"));
            this.put("5-12", Collections.nCopies(1, "\u70b3\u7075\u516c\u8bde"));
            this.put("5-13", Collections.nCopies(1, "\u5173\u5723\u964d"));
            this.put("5-16", Collections.nCopies(1, "\u5929\u5730\u5143\u6c14\u9020\u5316\u4e07\u7269\u4e4b\u8fb0"));
            this.put("5-18", Collections.nCopies(1, "\u5f20\u5929\u5e08\u8bde"));
            this.put("5-22", Collections.nCopies(1, "\u5b5d\u5a25\u795e\u8bde"));
            this.put("6-19", Collections.nCopies(1, "\u89c2\u4e16\u97f3\u83e9\u8428\u6210\u9053\u65e5"));
            this.put("6-24", Collections.nCopies(1, "\u5173\u5e1d\u8bde"));
            this.put("7-7", Collections.nCopies(1, "\u9b41\u661f\u8bde"));
            this.put("7-13", Arrays.asList("\u957f\u771f\u8c2d\u771f\u4eba\u8bde", "\u5927\u52bf\u81f3\u83e9\u8428\u8bde"));
            this.put("7-15", Collections.nCopies(1, "\u4e2d\u5143\u8282"));
            this.put("7-18", Collections.nCopies(1, "\u897f\u738b\u6bcd\u8bde"));
            this.put("7-19", Collections.nCopies(1, "\u592a\u5c81\u8bde"));
            this.put("7-22", Collections.nCopies(1, "\u589e\u798f\u8d22\u795e\u8bde"));
            this.put("7-29", Collections.nCopies(1, "\u6768\u516c\u5fcc"));
            this.put("7-30", Collections.nCopies(1, "\u5730\u85cf\u83e9\u8428\u8bde"));
            this.put("8-1", Collections.nCopies(1, "\u8bb8\u771f\u541b\u8bde"));
            this.put("8-3", Collections.nCopies(1, "\u53f8\u547d\u7076\u541b\u8bde"));
            this.put("8-5", Collections.nCopies(1, "\u96f7\u58f0\u5927\u5e1d\u8bde"));
            this.put("8-10", Collections.nCopies(1, "\u5317\u6597\u5927\u5e1d\u8bde"));
            this.put("8-12", Collections.nCopies(1, "\u897f\u65b9\u4e94\u9053\u8bde"));
            this.put("8-16", Collections.nCopies(1, "\u5929\u66f9\u63a0\u5237\u771f\u541b\u964d"));
            this.put("8-18", Collections.nCopies(1, "\u5929\u4eba\u5174\u798f\u4e4b\u8fb0"));
            this.put("8-23", Collections.nCopies(1, "\u6c49\u6052\u5019\u5f20\u663e\u738b\u8bde"));
            this.put("8-24", Collections.nCopies(1, "\u7076\u541b\u592b\u4eba\u8bde"));
            this.put("8-29", Collections.nCopies(1, "\u81f3\u5723\u5148\u5e08\u5b54\u5b50\u8bde"));
            this.put("9-1", Collections.nCopies(1, "\u5317\u6597\u4e5d\u661f\u964d\u4e16"));
            this.put("9-3", Collections.nCopies(1, "\u4e94\u761f\u795e\u8bde"));
            this.put("9-9", Collections.nCopies(1, "\u9146\u90fd\u5927\u5e1d\u8bde"));
            this.put("9-13", Collections.nCopies(1, "\u5b5f\u5a46\u5c0a\u795e\u8bde"));
            this.put("9-17", Collections.nCopies(1, "\u91d1\u9f99\u56db\u5927\u738b\u8bde"));
            this.put("9-19", Collections.nCopies(1, "\u89c2\u4e16\u97f3\u83e9\u8428\u51fa\u5bb6"));
            this.put("9-30", Collections.nCopies(1, "\u836f\u5e08\u7409\u7483\u5149\u4f5b\u8bde"));
            this.put("10-1", Collections.nCopies(1, "\u5bd2\u8863\u8282"));
            this.put("10-3", Collections.nCopies(1, "\u4e09\u8305\u8bde"));
            this.put("10-5", Collections.nCopies(1, "\u8fbe\u6469\u7956\u5e08\u8bde"));
            this.put("10-8", Collections.nCopies(1, "\u4f5b\u6d85\u69c3\u65e5"));
            this.put("10-15", Collections.nCopies(1, "\u4e0b\u5143\u8282"));
            this.put("11-4", Collections.nCopies(1, "\u81f3\u5723\u5148\u5e08\u5b54\u5b50\u8bde"));
            this.put("11-6", Collections.nCopies(1, "\u897f\u5cb3\u5927\u5e1d\u8bde"));
            this.put("11-11", Collections.nCopies(1, "\u592a\u4e59\u6551\u82e6\u5929\u5c0a\u8bde"));
            this.put("11-17", Collections.nCopies(1, "\u963f\u5f25\u9640\u4f5b\u8bde"));
            this.put("11-19", Collections.nCopies(1, "\u592a\u9633\u65e5\u5bab\u8bde"));
            this.put("11-23", Collections.nCopies(1, "\u5f20\u4ed9\u8bde"));
            this.put("11-26", Collections.nCopies(1, "\u5317\u65b9\u4e94\u9053\u8bde"));
            this.put("12-8", Collections.nCopies(1, "\u91ca\u8fe6\u5982\u6765\u6210\u4f5b\u4e4b\u8fb0"));
            this.put("12-16", Collections.nCopies(1, "\u5357\u5cb3\u5927\u5e1d\u8bde"));
            this.put("12-21", Collections.nCopies(1, "\u5929\u7337\u4e0a\u5e1d\u8bde"));
            this.put("12-23", Collections.nCopies(1, "\u5c0f\u5e74"));
            this.put("12-24", Collections.nCopies(1, "\u5b50\u65f6\u7076\u541b\u4e0a\u5929\u671d\u7389\u5e1d"));
            this.put("12-29", Collections.nCopies(1, "\u534e\u4e25\u83e9\u8428\u8bde"));
        }
    };
    public static final Map<String, String> XIU = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u75331", "\u6bd5");
            this.put("\u75332", "\u7ffc");
            this.put("\u75333", "\u7b95");
            this.put("\u75334", "\u594e");
            this.put("\u75335", "\u9b3c");
            this.put("\u75336", "\u6c10");
            this.put("\u75330", "\u865a");
            this.put("\u5b501", "\u6bd5");
            this.put("\u5b502", "\u7ffc");
            this.put("\u5b503", "\u7b95");
            this.put("\u5b504", "\u594e");
            this.put("\u5b505", "\u9b3c");
            this.put("\u5b506", "\u6c10");
            this.put("\u5b500", "\u865a");
            this.put("\u8fb01", "\u6bd5");
            this.put("\u8fb02", "\u7ffc");
            this.put("\u8fb03", "\u7b95");
            this.put("\u8fb04", "\u594e");
            this.put("\u8fb05", "\u9b3c");
            this.put("\u8fb06", "\u6c10");
            this.put("\u8fb00", "\u865a");
            this.put("\u5df31", "\u5371");
            this.put("\u5df32", "\u89dc");
            this.put("\u5df33", "\u8f78");
            this.put("\u5df34", "\u6597");
            this.put("\u5df35", "\u5a04");
            this.put("\u5df36", "\u67f3");
            this.put("\u5df30", "\u623f");
            this.put("\u91491", "\u5371");
            this.put("\u91492", "\u89dc");
            this.put("\u91493", "\u8f78");
            this.put("\u91494", "\u6597");
            this.put("\u91495", "\u5a04");
            this.put("\u91496", "\u67f3");
            this.put("\u91490", "\u623f");
            this.put("\u4e111", "\u5371");
            this.put("\u4e112", "\u89dc");
            this.put("\u4e113", "\u8f78");
            this.put("\u4e114", "\u6597");
            this.put("\u4e115", "\u5a04");
            this.put("\u4e116", "\u67f3");
            this.put("\u4e110", "\u623f");
            this.put("\u5bc51", "\u5fc3");
            this.put("\u5bc52", "\u5ba4");
            this.put("\u5bc53", "\u53c2");
            this.put("\u5bc54", "\u89d2");
            this.put("\u5bc55", "\u725b");
            this.put("\u5bc56", "\u80c3");
            this.put("\u5bc50", "\u661f");
            this.put("\u53481", "\u5fc3");
            this.put("\u53482", "\u5ba4");
            this.put("\u53483", "\u53c2");
            this.put("\u53484", "\u89d2");
            this.put("\u53485", "\u725b");
            this.put("\u53486", "\u80c3");
            this.put("\u53480", "\u661f");
            this.put("\u620c1", "\u5fc3");
            this.put("\u620c2", "\u5ba4");
            this.put("\u620c3", "\u53c2");
            this.put("\u620c4", "\u89d2");
            this.put("\u620c5", "\u725b");
            this.put("\u620c6", "\u80c3");
            this.put("\u620c0", "\u661f");
            this.put("\u4ea51", "\u5f20");
            this.put("\u4ea52", "\u5c3e");
            this.put("\u4ea53", "\u58c1");
            this.put("\u4ea54", "\u4e95");
            this.put("\u4ea55", "\u4ea2");
            this.put("\u4ea56", "\u5973");
            this.put("\u4ea50", "\u6634");
            this.put("\u536f1", "\u5f20");
            this.put("\u536f2", "\u5c3e");
            this.put("\u536f3", "\u58c1");
            this.put("\u536f4", "\u4e95");
            this.put("\u536f5", "\u4ea2");
            this.put("\u536f6", "\u5973");
            this.put("\u536f0", "\u6634");
            this.put("\u672a1", "\u5f20");
            this.put("\u672a2", "\u5c3e");
            this.put("\u672a3", "\u58c1");
            this.put("\u672a4", "\u4e95");
            this.put("\u672a5", "\u4ea2");
            this.put("\u672a6", "\u5973");
            this.put("\u672a0", "\u6634");
        }
    };
    public static final Map<String, String> XIU_LUCK = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u5409");
            this.put("\u4ea2", "\u51f6");
            this.put("\u6c10", "\u51f6");
            this.put("\u623f", "\u5409");
            this.put("\u5fc3", "\u51f6");
            this.put("\u5c3e", "\u5409");
            this.put("\u7b95", "\u5409");
            this.put("\u6597", "\u5409");
            this.put("\u725b", "\u51f6");
            this.put("\u5973", "\u51f6");
            this.put("\u865a", "\u51f6");
            this.put("\u5371", "\u51f6");
            this.put("\u5ba4", "\u5409");
            this.put("\u58c1", "\u5409");
            this.put("\u594e", "\u51f6");
            this.put("\u5a04", "\u5409");
            this.put("\u80c3", "\u5409");
            this.put("\u6634", "\u51f6");
            this.put("\u6bd5", "\u5409");
            this.put("\u89dc", "\u51f6");
            this.put("\u53c2", "\u5409");
            this.put("\u4e95", "\u5409");
            this.put("\u9b3c", "\u51f6");
            this.put("\u67f3", "\u51f6");
            this.put("\u661f", "\u51f6");
            this.put("\u5f20", "\u5409");
            this.put("\u7ffc", "\u51f6");
            this.put("\u8f78", "\u5409");
        }
    };
    public static final Map<String, String> XIU_SONG = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u89d2\u661f\u9020\u4f5c\u4e3b\u8363\u660c\uff0c\u5916\u8fdb\u7530\u8d22\u53ca\u5973\u90ce\uff0c\u5ac1\u5a36\u5a5a\u59fb\u51fa\u8d35\u5b50\uff0c\u6587\u4eba\u53ca\u7b2c\u89c1\u541b\u738b\uff0c\u60df\u6709\u57cb\u846c\u4e0d\u53ef\u7528\uff0c\u4e09\u5e74\u4e4b\u540e\u4e3b\u761f\u75ab\uff0c\u8d77\u5de5\u4fee\u7b51\u575f\u57fa\u5730\uff0c\u5802\u524d\u7acb\u89c1\u4e3b\u4eba\u51f6\u3002");
            this.put("\u4ea2", "\u4ea2\u661f\u9020\u4f5c\u957f\u623f\u5f53\uff0c\u5341\u65e5\u4e4b\u4e2d\u4e3b\u6709\u6b83\uff0c\u7530\u5730\u6d88\u78e8\u5b98\u5931\u804c\uff0c\u63a5\u8fd0\u5b9a\u662f\u864e\u72fc\u4f24\uff0c\u5ac1\u5a36\u5a5a\u59fb\u7528\u6b64\u65e5\uff0c\u513f\u5b59\u65b0\u5987\u5b88\u7a7a\u623f\uff0c\u57cb\u846c\u82e5\u8fd8\u7528\u6b64\u65e5\uff0c\u5f53\u65f6\u5bb3\u7978\u4e3b\u91cd\u4f24\u3002");
            this.put("\u6c10", "\u6c10\u661f\u9020\u4f5c\u4e3b\u707e\u51f6\uff0c\u8d39\u5c3d\u7530\u56ed\u4ed3\u5e93\u7a7a\uff0c\u57cb\u846c\u4e0d\u53ef\u7528\u6b64\u65e5\uff0c\u60ac\u7ef3\u540a\u9888\u7978\u91cd\u91cd\uff0c\u82e5\u662f\u5a5a\u59fb\u79bb\u522b\u6563\uff0c\u591c\u62db\u6d6a\u5b50\u5165\u623f\u4e2d\uff0c\u884c\u8239\u5fc5\u5b9a\u906d\u6c89\u6ca1\uff0c\u66f4\u751f\u804b\u54d1\u5b50\u5b59\u7a77\u3002");
            this.put("\u623f", "\u623f\u661f\u9020\u4f5c\u7530\u56ed\u8fdb\uff0c\u94b1\u8d22\u725b\u9a6c\u904d\u5c71\u5c97\uff0c\u66f4\u62db\u5916\u5904\u7530\u5e84\u5b85\uff0c\u8363\u534e\u5bcc\u8d35\u798f\u7984\u5eb7\uff0c\u57cb\u846c\u82e5\u7136\u7528\u6b64\u65e5\uff0c\u9ad8\u5b98\u8fdb\u804c\u62dc\u541b\u738b\uff0c\u5ac1\u5a36\u5ae6\u5a25\u81f3\u6708\u6bbf\uff0c\u4e09\u5e74\u62b1\u5b50\u81f3\u671d\u5802\u3002");
            this.put("\u5fc3", "\u5fc3\u661f\u9020\u4f5c\u5927\u4e3a\u51f6\uff0c\u66f4\u906d\u5211\u8bbc\u72f1\u56da\u4e2d\uff0c\u5fe4\u9006\u5b98\u975e\u5b85\u4ea7\u9000\uff0c\u57cb\u846c\u5352\u66b4\u6b7b\u76f8\u4ece\uff0c\u5a5a\u59fb\u82e5\u662f\u7528\u6b64\u65e5\uff0c\u5b50\u6b7b\u513f\u4ea1\u6cea\u6ee1\u80f8\uff0c\u4e09\u5e74\u4e4b\u5185\u8fde\u906d\u7978\uff0c\u4e8b\u4e8b\u6559\u541b\u6ca1\u59cb\u7ec8\u3002");
            this.put("\u5c3e", "\u5c3e\u661f\u9020\u4f5c\u4e3b\u5929\u6069\uff0c\u5bcc\u8d35\u8363\u534e\u798f\u7984\u589e\uff0c\u62db\u8d22\u8fdb\u5b9d\u5174\u5bb6\u5b85\uff0c\u548c\u5408\u5a5a\u59fb\u8d35\u5b50\u5b59\uff0c\u57cb\u846c\u82e5\u80fd\u4f9d\u6b64\u65e5\uff0c\u7537\u6e05\u5973\u6b63\u5b50\u5b59\u5174\uff0c\u5f00\u95e8\u653e\u6c34\u62db\u7530\u5b85\uff0c\u4ee3\u4ee3\u516c\u4faf\u8fdc\u64ad\u540d\u3002");
            this.put("\u7b95", "\u7b95\u661f\u9020\u4f5c\u4e3b\u9ad8\u5f3a\uff0c\u5c81\u5c81\u5e74\u5e74\u5927\u5409\u660c\uff0c\u57cb\u846c\u4fee\u575f\u5927\u5409\u5229\uff0c\u7530\u8695\u725b\u9a6c\u904d\u5c71\u5c97\uff0c\u5f00\u95e8\u653e\u6c34\u62db\u7530\u5b85\uff0c\u7ba7\u6ee1\u91d1\u94f6\u8c37\u6ee1\u4ed3\uff0c\u798f\u836b\u9ad8\u5b98\u52a0\u7984\u4f4d\uff0c\u516d\u4eb2\u4e30\u7984\u4e50\u5b89\u5eb7\u3002");
            this.put("\u6597", "\u6597\u661f\u9020\u4f5c\u4e3b\u62db\u8d22\uff0c\u6587\u6b66\u5b98\u5458\u4f4d\u9f0e\u53f0\uff0c\u7530\u5b85\u5bb6\u8d22\u5343\u4e07\u8fdb\uff0c\u575f\u5802\u4fee\u7b51\u8d35\u5bcc\u6765\uff0c\u5f00\u95e8\u653e\u6c34\u62db\u725b\u9a6c\uff0c\u65fa\u8695\u7537\u5973\u4e3b\u548c\u8c10\uff0c\u9047\u6b64\u5409\u5bbf\u6765\u7167\u62a4\uff0c\u65f6\u652f\u798f\u5e86\u6c38\u65e0\u707e\u3002");
            this.put("\u725b", "\u725b\u661f\u9020\u4f5c\u4e3b\u707e\u5371\uff0c\u4e5d\u6a2a\u4e09\u707e\u4e0d\u53ef\u63a8\uff0c\u5bb6\u5b85\u4e0d\u5b89\u4eba\u53e3\u9000\uff0c\u7530\u8695\u4e0d\u5229\u4e3b\u4eba\u8870\uff0c\u5ac1\u5a36\u5a5a\u59fb\u7686\u81ea\u635f\uff0c\u91d1\u94f6\u8d22\u8c37\u6e10\u65e0\u4e4b\uff0c\u82e5\u662f\u5f00\u95e8\u5e76\u653e\u6c34\uff0c\u725b\u732a\u7f8a\u9a6c\u4ea6\u4f24\u60b2\u3002");
            this.put("\u5973", "\u5973\u661f\u9020\u4f5c\u635f\u5a46\u5a18\uff0c\u5144\u5f1f\u76f8\u5acc\u4f3c\u864e\u72fc\uff0c\u57cb\u846c\u751f\u707e\u9022\u9b3c\u602a\uff0c\u98a0\u90aa\u75be\u75c5\u4e3b\u761f\u60f6\uff0c\u4e3a\u4e8b\u906d\u5b98\u8d22\u5931\u6563\uff0c\u6cfb\u5229\u7559\u8fde\u4e0d\u53ef\u5f53\uff0c\u5f00\u95e8\u653e\u6c34\u7528\u6b64\u65e5\uff0c\u5168\u5bb6\u8d22\u6563\u4e3b\u79bb\u4e61\u3002");
            this.put("\u865a", "\u865a\u661f\u9020\u4f5c\u4e3b\u707e\u6b83\uff0c\u7537\u5973\u5b64\u7720\u4e0d\u4e00\u53cc\uff0c\u5185\u4e71\u98ce\u58f0\u65e0\u793c\u8282\uff0c\u513f\u5b59\u5ab3\u5987\u4f34\u4eba\u5e8a\uff0c\u5f00\u95e8\u653e\u6c34\u906d\u707e\u7978\uff0c\u864e\u54ac\u86c7\u4f24\u53c8\u5352\u4ea1\uff0c\u4e09\u4e09\u4e94\u4e94\u8fde\u5e74\u75c5\uff0c\u5bb6\u7834\u4eba\u4ea1\u4e0d\u53ef\u5f53\u3002");
            this.put("\u5371", "\u5371\u661f\u4e0d\u53ef\u9020\u9ad8\u697c\uff0c\u81ea\u906d\u5211\u540a\u89c1\u8840\u5149\uff0c\u4e09\u5e74\u5b69\u5b50\u906d\u6c34\u5384\uff0c\u540e\u751f\u51fa\u5916\u6c38\u4e0d\u8fd8\uff0c\u57cb\u846c\u82e5\u8fd8\u9022\u6b64\u65e5\uff0c\u5468\u5e74\u767e\u65e5\u53d6\u9ad8\u5802\uff0c\u4e09\u5e74\u4e24\u8f7d\u4e00\u60b2\u4f24\uff0c\u5f00\u95e8\u653e\u6c34\u5230\u5b98\u5802\u3002");
            this.put("\u5ba4", "\u5ba4\u661f\u4fee\u9020\u8fdb\u7530\u725b\uff0c\u513f\u5b59\u4ee3\u4ee3\u8fd1\u738b\u4faf\uff0c\u5bb6\u8d35\u8363\u534e\u5929\u4e0a\u81f3\uff0c\u5bff\u5982\u5f6d\u7956\u516b\u5343\u79cb\uff0c\u5f00\u95e8\u653e\u6c34\u62db\u8d22\u5e1b\uff0c\u548c\u5408\u5a5a\u59fb\u751f\u8d35\u513f\uff0c\u57cb\u846c\u82e5\u80fd\u4f9d\u6b64\u65e5\uff0c\u95e8\u5ead\u5174\u65fa\u798f\u65e0\u4f11\u3002");
            this.put("\u58c1", "\u58c1\u661f\u9020\u4f5c\u4e3b\u589e\u8d22\uff0c\u4e1d\u8695\u5927\u719f\u798f\u6ed4\u5929\uff0c\u5974\u5a62\u81ea\u6765\u4eba\u53e3\u8fdb\uff0c\u5f00\u95e8\u653e\u6c34\u51fa\u82f1\u8d24\uff0c\u57cb\u846c\u62db\u8d22\u5b98\u54c1\u8fdb\uff0c\u5bb6\u4e2d\u8bf8\u4e8b\u4e50\u9676\u7136\uff0c\u5a5a\u59fb\u5409\u5229\u4e3b\u8d35\u5b50\uff0c\u65e9\u64ad\u540d\u8a89\u8457\u7956\u97ad\u3002");
            this.put("\u594e", "\u594e\u661f\u9020\u4f5c\u5f97\u796f\u7965\uff0c\u5bb6\u5185\u8363\u548c\u5927\u5409\u660c\uff0c\u82e5\u662f\u57cb\u846c\u9634\u5352\u6b7b\uff0c\u5f53\u5e74\u5b9a\u4e3b\u4e24\u4e09\u4f24\uff0c\u770b\u770b\u519b\u4ee4\u5211\u4f24\u5230\uff0c\u91cd\u91cd\u5b98\u4e8b\u4e3b\u761f\u60f6\uff0c\u5f00\u95e8\u653e\u6c34\u906d\u707e\u7978\uff0c\u4e09\u5e74\u4e24\u6b21\u635f\u513f\u90ce\u3002");
            this.put("\u5a04", "\u5a04\u661f\u4fee\u9020\u8d77\u95e8\u5ead\uff0c\u8d22\u65fa\u5bb6\u548c\u4e8b\u4e8b\u5174\uff0c\u5916\u8fdb\u94b1\u8d22\u767e\u65e5\u8fdb\uff0c\u4e00\u5bb6\u5144\u5f1f\u64ad\u9ad8\u540d\uff0c\u5a5a\u59fb\u8fdb\u76ca\u751f\u8d35\u5b50\uff0c\u7389\u5e1b\u91d1\u94f6\u7bb1\u6ee1\u76c8\uff0c\u653e\u6c34\u5f00\u95e8\u7686\u5409\u5229\uff0c\u7537\u8363\u5973\u8d35\u5bff\u5eb7\u5b81\u3002");
            this.put("\u80c3", "\u80c3\u661f\u9020\u4f5c\u4e8b\u5982\u4f55\uff0c\u5bb6\u8d35\u8363\u534e\u559c\u6c14\u591a\uff0c\u57cb\u846c\u8d35\u4e34\u5b98\u7984\u4f4d\uff0c\u592b\u5987\u9f50\u7709\u6c38\u4fdd\u5eb7\uff0c\u5a5a\u59fb\u9047\u6b64\u5bb6\u5bcc\u8d35\uff0c\u4e09\u707e\u4e5d\u7978\u4e0d\u9022\u4ed6\uff0c\u4ece\u6b64\u95e8\u524d\u591a\u5409\u5e86\uff0c\u513f\u5b59\u4ee3\u4ee3\u62dc\u91d1\u9636\u3002");
            this.put("\u6634", "\u6634\u661f\u9020\u4f5c\u8fdb\u7530\u725b\uff0c\u57cb\u846c\u5b98\u707e\u4e0d\u5f97\u4f11\uff0c\u91cd\u4e27\u4e8c\u65e5\u4e09\u4eba\u6b7b\uff0c\u5c3d\u5356\u7530\u56ed\u4e0d\u8bb0\u589e\uff0c\u5f00\u95e8\u653e\u6c34\u62db\u707e\u7978\uff0c\u4e09\u5c81\u5b69\u513f\u767d\u4e86\u5934\uff0c\u5a5a\u59fb\u4e0d\u53ef\u9022\u6b64\u65e5\uff0c\u6b7b\u522b\u751f\u79bb\u662f\u53ef\u6101\u3002");
            this.put("\u6bd5", "\u6bd5\u661f\u9020\u4f5c\u4e3b\u5149\u524d\uff0c\u4e70\u5f97\u7530\u56ed\u6709\u4f59\u94b1\uff0c\u57cb\u846c\u6b64\u65e5\u6dfb\u5b98\u804c\uff0c\u7530\u8695\u5927\u719f\u6c38\u4e30\u5e74\uff0c\u5f00\u95e8\u653e\u6c34\u591a\u5409\u5e86\uff0c\u5408\u5bb6\u4eba\u53e3\u5f97\u5b89\u7136\uff0c\u5a5a\u59fb\u82e5\u5f97\u9022\u6b64\u65e5\uff0c\u751f\u5f97\u5b69\u513f\u798f\u5bff\u5168\u3002");
            this.put("\u89dc", "\u89dc\u661f\u9020\u4f5c\u6709\u5f92\u5211\uff0c\u4e09\u5e74\u5fc5\u5b9a\u4e3b\u4f36\u4e01\uff0c\u57cb\u846c\u5352\u6b7b\u591a\u56e0\u6b64\uff0c\u53d6\u5b9a\u5bc5\u5e74\u4f7f\u6740\u4eba\uff0c\u4e09\u4e27\u4e0d\u6b62\u7686\u7531\u6b64\uff0c\u4e00\u4eba\u836f\u6bd2\u4e8c\u4eba\u8eab\uff0c\u5bb6\u95e8\u7530\u5730\u7686\u9000\u8d25\uff0c\u4ed3\u5e93\u91d1\u94f6\u5316\u4f5c\u5c18\u3002");
            this.put("\u53c2", "\u53c2\u661f\u9020\u4f5c\u65fa\u4eba\u5bb6\uff0c\u6587\u661f\u7167\u8000\u5927\u5149\u534e\uff0c\u53ea\u56e0\u9020\u4f5c\u7530\u8d22\u65fa\uff0c\u57cb\u846c\u62db\u75be\u54ed\u9ec4\u6c99\uff0c\u5f00\u95e8\u653e\u6c34\u52a0\u5b98\u804c\uff0c\u623f\u623f\u5b50\u5b59\u89c1\u7530\u52a0\uff0c\u5a5a\u59fb\u8bb8\u9041\u906d\u5211\u514b\uff0c\u7537\u5973\u671d\u5f00\u5e55\u843d\u82b1\u3002");
            this.put("\u4e95", "\u4e95\u661f\u9020\u4f5c\u65fa\u8695\u7530\uff0c\u91d1\u699c\u9898\u540d\u7b2c\u4e00\u5149\uff0c\u57cb\u846c\u987b\u9632\u60ca\u5352\u6b7b\uff0c\u72c2\u98a0\u98ce\u75be\u5165\u9ec4\u6cc9\uff0c\u5f00\u95e8\u653e\u6c34\u62db\u8d22\u5e1b\uff0c\u725b\u9a6c\u732a\u7f8a\u65fa\u83ab\u8a00\uff0c\u8d35\u4eba\u7530\u5858\u6765\u5165\u5b85\uff0c\u513f\u5b59\u5174\u65fa\u6709\u4f59\u94b1\u3002");
            this.put("\u9b3c", "\u9b3c\u661f\u8d77\u9020\u5352\u4eba\u4ea1\uff0c\u5802\u524d\u4e0d\u89c1\u4e3b\u4eba\u90ce\uff0c\u57cb\u846c\u6b64\u65e5\u5b98\u7984\u81f3\uff0c\u513f\u5b59\u4ee3\u4ee3\u8fd1\u541b\u738b\uff0c\u5f00\u95e8\u653e\u6c34\u987b\u4f24\u6b7b\uff0c\u5ac1\u5a36\u592b\u59bb\u4e0d\u4e45\u957f\uff0c\u4fee\u571f\u7b51\u5899\u4f24\u4ea7\u5973\uff0c\u624b\u6276\u53cc\u5973\u6cea\u6c6a\u6c6a\u3002");
            this.put("\u67f3", "\u67f3\u661f\u9020\u4f5c\u4e3b\u906d\u5b98\uff0c\u663c\u591c\u5077\u95ed\u4e0d\u6682\u5b89\uff0c\u57cb\u846c\u761f\u60f6\u591a\u75be\u75c5\uff0c\u7530\u56ed\u9000\u5c3d\u5b88\u51ac\u5bd2\uff0c\u5f00\u95e8\u653e\u6c34\u906d\u804b\u778e\uff0c\u8170\u9a7c\u80cc\u66f2\u4f3c\u5f13\u5f2f\uff0c\u66f4\u6709\u68d2\u5211\u5b9c\u8c28\u614e\uff0c\u5987\u4eba\u968f\u5ba2\u8d70\u76d8\u6853\u3002");
            this.put("\u661f", "\u661f\u5bbf\u65e5\u597d\u9020\u65b0\u623f\uff0c\u8fdb\u804c\u52a0\u5b98\u8fd1\u5e1d\u738b\uff0c\u4e0d\u53ef\u57cb\u846c\u5e76\u653e\u6c34\uff0c\u51f6\u661f\u4e34\u4f4d\u5973\u4eba\u4ea1\uff0c\u751f\u79bb\u6b7b\u522b\u65e0\u5fc3\u604b\uff0c\u8981\u81ea\u5f52\u4f11\u522b\u5ac1\u90ce\uff0c\u5b54\u5b50\u4e5d\u66f2\u6b8a\u96be\u5ea6\uff0c\u653e\u6c34\u5f00\u95e8\u5929\u547d\u4f24\u3002");
            this.put("\u5f20", "\u5f20\u661f\u65e5\u597d\u9020\u9f99\u8f69\uff0c\u5e74\u5e74\u5e76\u89c1\u8fdb\u5e84\u7530\uff0c\u57cb\u846c\u4e0d\u4e45\u5347\u5b98\u804c\uff0c\u4ee3\u4ee3\u4e3a\u5b98\u8fd1\u5e1d\u524d\uff0c\u5f00\u95e8\u653e\u6c34\u62db\u8d22\u5e1b\uff0c\u5a5a\u59fb\u548c\u5408\u798f\u7ef5\u7ef5\uff0c\u7530\u8695\u4eba\u6ee1\u4ed3\u5e93\u6ee1\uff0c\u767e\u822c\u987a\u610f\u81ea\u5b89\u7136\u3002");
            this.put("\u7ffc", "\u7ffc\u661f\u4e0d\u5229\u67b6\u9ad8\u5802\uff0c\u4e09\u5e74\u4e8c\u8f7d\u89c1\u761f\u60f6\uff0c\u57cb\u846c\u82e5\u8fd8\u9022\u6b64\u65e5\uff0c\u5b50\u5b59\u5fc5\u5b9a\u8d70\u4ed6\u4e61\uff0c\u5a5a\u59fb\u6b64\u65e5\u4e0d\u5b9c\u5229\uff0c\u5f52\u5bb6\u5b9a\u662f\u4e0d\u76f8\u5f53\uff0c\u5f00\u95e8\u653e\u6c34\u5bb6\u987b\u7834\uff0c\u5c11\u5973\u604b\u82b1\u8d2a\u5916\u90ce\u3002");
            this.put("\u8f78", "\u8f78\u661f\u4e34\u6c34\u9020\u9f99\u5bab\uff0c\u4ee3\u4ee3\u4e3a\u5b98\u53d7\u7687\u5c01\uff0c\u5bcc\u8d35\u8363\u534e\u589e\u5bff\u7984\uff0c\u5e93\u6ee1\u4ed3\u76c8\u81ea\u660c\u9686\uff0c\u57cb\u846c\u6587\u660c\u6765\u7167\u52a9\uff0c\u5b85\u820d\u5b89\u5b81\u4e0d\u89c1\u51f6\uff0c\u66f4\u6709\u4e3a\u5b98\u6cbe\u5e1d\u5ba0\uff0c\u5a5a\u59fb\u9f99\u5b50\u5165\u9f99\u5bab\u3002");
        }
    };
    public static final Map<String, String> SHOU = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u4e1c", "\u9752\u9f99");
            this.put("\u5357", "\u6731\u96c0");
            this.put("\u897f", "\u767d\u864e");
            this.put("\u5317", "\u7384\u6b66");
        }
    };
    public static final Map<String, String> CHONG = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u5b50", "\u5348");
            this.put("\u4e11", "\u672a");
            this.put("\u5bc5", "\u7533");
            this.put("\u536f", "\u9149");
            this.put("\u8fb0", "\u620c");
            this.put("\u5df3", "\u4ea5");
            this.put("\u5348", "\u5b50");
            this.put("\u672a", "\u4e11");
            this.put("\u7533", "\u5bc5");
            this.put("\u9149", "\u536f");
            this.put("\u620c", "\u8fb0");
            this.put("\u4ea5", "\u5df3");
        }
    };
    public static final Map<String, String> CHONG_GAN = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u7532", "\u620a");
            this.put("\u4e59", "\u5df1");
            this.put("\u4e19", "\u5e9a");
            this.put("\u4e01", "\u8f9b");
            this.put("\u620a", "\u58ec");
            this.put("\u5df1", "\u7678");
            this.put("\u5e9a", "\u7532");
            this.put("\u8f9b", "\u4e59");
            this.put("\u58ec", "\u4e19");
            this.put("\u7678", "\u4e01");
        }
    };
    public static final Map<String, String> CHONG_GAN_BAD = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u5e9a", "\u7532");
            this.put("\u8f9b", "\u4e59");
            this.put("\u58ec", "\u4e19");
            this.put("\u7678", "\u4e01");
        }
    };
    public static final Map<String, String> CHONG_GAN_TIE = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u7532", "\u5df1");
            this.put("\u4e59", "\u620a");
            this.put("\u4e19", "\u8f9b");
            this.put("\u4e01", "\u5e9a");
            this.put("\u620a", "\u7678");
            this.put("\u5df1", "\u58ec");
            this.put("\u5e9a", "\u4e59");
            this.put("\u8f9b", "\u7532");
            this.put("\u58ec", "\u4e01");
            this.put("\u7678", "\u4e19");
        }
    };
    public static final Map<String, String> CHONG_GAN_TIE_GOOD = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u7532", "\u5df1");
            this.put("\u4e19", "\u8f9b");
            this.put("\u620a", "\u7678");
            this.put("\u5e9a", "\u4e59");
            this.put("\u58ec", "\u4e01");
        }
    };
    public static final Map<String, String> SHA = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u5b50", "\u5357");
            this.put("\u4e11", "\u4e1c");
            this.put("\u5bc5", "\u5317");
            this.put("\u536f", "\u897f");
            this.put("\u8fb0", "\u5357");
            this.put("\u5df3", "\u4e1c");
            this.put("\u5348", "\u5317");
            this.put("\u672a", "\u897f");
            this.put("\u7533", "\u5357");
            this.put("\u9149", "\u4e1c");
            this.put("\u620c", "\u5317");
            this.put("\u4ea5", "\u897f");
        }
    };
    public static final Map<String, String> POSITION_DESC = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u574e", "\u6b63\u5317");
            this.put("\u826e", "\u4e1c\u5317");
            this.put("\u9707", "\u6b63\u4e1c");
            this.put("\u5dfd", "\u4e1c\u5357");
            this.put("\u79bb", "\u6b63\u5357");
            this.put("\u5764", "\u897f\u5357");
            this.put("\u5151", "\u6b63\u897f");
            this.put("\u4e7e", "\u897f\u5317");
        }
    };
    public static final Map<String, String> GONG = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u4e1c");
            this.put("\u4e95", "\u5357");
            this.put("\u594e", "\u897f");
            this.put("\u6597", "\u5317");
            this.put("\u4ea2", "\u4e1c");
            this.put("\u9b3c", "\u5357");
            this.put("\u5a04", "\u897f");
            this.put("\u725b", "\u5317");
            this.put("\u6c10", "\u5357");
            this.put("\u67f3", "\u5357");
            this.put("\u80c3", "\u897f");
            this.put("\u5973", "\u5317");
            this.put("\u623f", "\u4e1c");
            this.put("\u661f", "\u5357");
            this.put("\u6634", "\u897f");
            this.put("\u865a", "\u5317");
            this.put("\u5fc3", "\u4e1c");
            this.put("\u5f20", "\u5357");
            this.put("\u6bd5", "\u897f");
            this.put("\u5371", "\u5317");
            this.put("\u5c3e", "\u4e1c");
            this.put("\u7ffc", "\u5357");
            this.put("\u89dc", "\u897f");
            this.put("\u5ba4", "\u5317");
            this.put("\u7b95", "\u4e1c");
            this.put("\u8f78", "\u5357");
            this.put("\u53c2", "\u897f");
            this.put("\u58c1", "\u5317");
        }
    };
    public static final Map<String, String> ZHENG = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u6728");
            this.put("\u4e95", "\u6728");
            this.put("\u594e", "\u6728");
            this.put("\u6597", "\u6728");
            this.put("\u4ea2", "\u91d1");
            this.put("\u9b3c", "\u91d1");
            this.put("\u5a04", "\u91d1");
            this.put("\u725b", "\u91d1");
            this.put("\u6c10", "\u571f");
            this.put("\u67f3", "\u571f");
            this.put("\u80c3", "\u571f");
            this.put("\u5973", "\u571f");
            this.put("\u623f", "\u65e5");
            this.put("\u661f", "\u65e5");
            this.put("\u6634", "\u65e5");
            this.put("\u865a", "\u65e5");
            this.put("\u5fc3", "\u6708");
            this.put("\u5f20", "\u6708");
            this.put("\u6bd5", "\u6708");
            this.put("\u5371", "\u6708");
            this.put("\u5c3e", "\u706b");
            this.put("\u7ffc", "\u706b");
            this.put("\u89dc", "\u706b");
            this.put("\u5ba4", "\u706b");
            this.put("\u7b95", "\u6c34");
            this.put("\u8f78", "\u6c34");
            this.put("\u53c2", "\u6c34");
            this.put("\u58c1", "\u6c34");
        }
    };
    public static final Map<String, String> ANIMAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u86df");
            this.put("\u6597", "\u736c");
            this.put("\u594e", "\u72fc");
            this.put("\u4e95", "\u72b4");
            this.put("\u4ea2", "\u9f99");
            this.put("\u725b", "\u725b");
            this.put("\u5a04", "\u72d7");
            this.put("\u9b3c", "\u7f8a");
            this.put("\u5973", "\u8760");
            this.put("\u6c10", "\u8c89");
            this.put("\u80c3", "\u5f58");
            this.put("\u67f3", "\u7350");
            this.put("\u623f", "\u5154");
            this.put("\u865a", "\u9f20");
            this.put("\u6634", "\u9e21");
            this.put("\u661f", "\u9a6c");
            this.put("\u5fc3", "\u72d0");
            this.put("\u5371", "\u71d5");
            this.put("\u6bd5", "\u4e4c");
            this.put("\u5f20", "\u9e7f");
            this.put("\u5c3e", "\u864e");
            this.put("\u5ba4", "\u732a");
            this.put("\u89dc", "\u7334");
            this.put("\u7ffc", "\u86c7");
            this.put("\u7b95", "\u8c79");
            this.put("\u58c1", "\u735d");
            this.put("\u53c2", "\u733f");
            this.put("\u8f78", "\u8693");
        }
    };
    public static final Map<String, String> WU_XING_GAN = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u7532", "\u6728");
            this.put("\u4e59", "\u6728");
            this.put("\u4e19", "\u706b");
            this.put("\u4e01", "\u706b");
            this.put("\u620a", "\u571f");
            this.put("\u5df1", "\u571f");
            this.put("\u5e9a", "\u91d1");
            this.put("\u8f9b", "\u91d1");
            this.put("\u58ec", "\u6c34");
            this.put("\u7678", "\u6c34");
        }
    };
    public static final Map<String, String> WU_XING_ZHI = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u5bc5", "\u6728");
            this.put("\u536f", "\u6728");
            this.put("\u5df3", "\u706b");
            this.put("\u5348", "\u706b");
            this.put("\u8fb0", "\u571f");
            this.put("\u4e11", "\u571f");
            this.put("\u620c", "\u571f");
            this.put("\u672a", "\u571f");
            this.put("\u7533", "\u91d1");
            this.put("\u9149", "\u91d1");
            this.put("\u4ea5", "\u6c34");
            this.put("\u5b50", "\u6c34");
        }
    };
    public static final Map<String, String> NAYIN = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u7532\u5b50", "\u6d77\u4e2d\u91d1");
            this.put("\u7532\u5348", "\u6c99\u4e2d\u91d1");
            this.put("\u4e19\u5bc5", "\u7089\u4e2d\u706b");
            this.put("\u4e19\u7533", "\u5c71\u4e0b\u706b");
            this.put("\u620a\u8fb0", "\u5927\u6797\u6728");
            this.put("\u620a\u620c", "\u5e73\u5730\u6728");
            this.put("\u5e9a\u5348", "\u8def\u65c1\u571f");
            this.put("\u5e9a\u5b50", "\u58c1\u4e0a\u571f");
            this.put("\u58ec\u7533", "\u5251\u950b\u91d1");
            this.put("\u58ec\u5bc5", "\u91d1\u7b94\u91d1");
            this.put("\u7532\u620c", "\u5c71\u5934\u706b");
            this.put("\u7532\u8fb0", "\u8986\u706f\u706b");
            this.put("\u4e19\u5b50", "\u6da7\u4e0b\u6c34");
            this.put("\u4e19\u5348", "\u5929\u6cb3\u6c34");
            this.put("\u620a\u5bc5", "\u57ce\u5934\u571f");
            this.put("\u620a\u7533", "\u5927\u9a7f\u571f");
            this.put("\u5e9a\u8fb0", "\u767d\u8721\u91d1");
            this.put("\u5e9a\u620c", "\u9497\u948f\u91d1");
            this.put("\u58ec\u5348", "\u6768\u67f3\u6728");
            this.put("\u58ec\u5b50", "\u6851\u67d8\u6728");
            this.put("\u7532\u7533", "\u6cc9\u4e2d\u6c34");
            this.put("\u7532\u5bc5", "\u5927\u6eaa\u6c34");
            this.put("\u4e19\u620c", "\u5c4b\u4e0a\u571f");
            this.put("\u4e19\u8fb0", "\u6c99\u4e2d\u571f");
            this.put("\u620a\u5b50", "\u9739\u96f3\u706b");
            this.put("\u620a\u5348", "\u5929\u4e0a\u706b");
            this.put("\u5e9a\u5bc5", "\u677e\u67cf\u6728");
            this.put("\u5e9a\u7533", "\u77f3\u69b4\u6728");
            this.put("\u58ec\u8fb0", "\u957f\u6d41\u6c34");
            this.put("\u58ec\u620c", "\u5927\u6d77\u6c34");
            this.put("\u4e59\u4e11", "\u6d77\u4e2d\u91d1");
            this.put("\u4e59\u672a", "\u6c99\u4e2d\u91d1");
            this.put("\u4e01\u536f", "\u7089\u4e2d\u706b");
            this.put("\u4e01\u9149", "\u5c71\u4e0b\u706b");
            this.put("\u5df1\u5df3", "\u5927\u6797\u6728");
            this.put("\u5df1\u4ea5", "\u5e73\u5730\u6728");
            this.put("\u8f9b\u672a", "\u8def\u65c1\u571f");
            this.put("\u8f9b\u4e11", "\u58c1\u4e0a\u571f");
            this.put("\u7678\u9149", "\u5251\u950b\u91d1");
            this.put("\u7678\u536f", "\u91d1\u7b94\u91d1");
            this.put("\u4e59\u4ea5", "\u5c71\u5934\u706b");
            this.put("\u4e59\u5df3", "\u8986\u706f\u706b");
            this.put("\u4e01\u4e11", "\u6da7\u4e0b\u6c34");
            this.put("\u4e01\u672a", "\u5929\u6cb3\u6c34");
            this.put("\u5df1\u536f", "\u57ce\u5934\u571f");
            this.put("\u5df1\u9149", "\u5927\u9a7f\u571f");
            this.put("\u8f9b\u5df3", "\u767d\u8721\u91d1");
            this.put("\u8f9b\u4ea5", "\u9497\u948f\u91d1");
            this.put("\u7678\u672a", "\u6768\u67f3\u6728");
            this.put("\u7678\u4e11", "\u6851\u67d8\u6728");
            this.put("\u4e59\u9149", "\u6cc9\u4e2d\u6c34");
            this.put("\u4e59\u536f", "\u5927\u6eaa\u6c34");
            this.put("\u4e01\u4ea5", "\u5c4b\u4e0a\u571f");
            this.put("\u4e01\u5df3", "\u6c99\u4e2d\u571f");
            this.put("\u5df1\u4e11", "\u9739\u96f3\u706b");
            this.put("\u5df1\u672a", "\u5929\u4e0a\u706b");
            this.put("\u8f9b\u536f", "\u677e\u67cf\u6728");
            this.put("\u8f9b\u9149", "\u77f3\u69b4\u6728");
            this.put("\u7678\u5df3", "\u957f\u6d41\u6c34");
            this.put("\u7678\u4ea5", "\u5927\u6d77\u6c34");
        }
    };
    public static final Map<String, String> SHI_SHEN_GAN = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u7532\u7532", "\u6bd4\u80a9");
            this.put("\u7532\u4e59", "\u52ab\u8d22");
            this.put("\u7532\u4e19", "\u98df\u795e");
            this.put("\u7532\u4e01", "\u4f24\u5b98");
            this.put("\u7532\u620a", "\u504f\u8d22");
            this.put("\u7532\u5df1", "\u6b63\u8d22");
            this.put("\u7532\u5e9a", "\u4e03\u6740");
            this.put("\u7532\u8f9b", "\u6b63\u5b98");
            this.put("\u7532\u58ec", "\u504f\u5370");
            this.put("\u7532\u7678", "\u6b63\u5370");
            this.put("\u4e59\u4e59", "\u6bd4\u80a9");
            this.put("\u4e59\u7532", "\u52ab\u8d22");
            this.put("\u4e59\u4e01", "\u98df\u795e");
            this.put("\u4e59\u4e19", "\u4f24\u5b98");
            this.put("\u4e59\u5df1", "\u504f\u8d22");
            this.put("\u4e59\u620a", "\u6b63\u8d22");
            this.put("\u4e59\u8f9b", "\u4e03\u6740");
            this.put("\u4e59\u5e9a", "\u6b63\u5b98");
            this.put("\u4e59\u7678", "\u504f\u5370");
            this.put("\u4e59\u58ec", "\u6b63\u5370");
            this.put("\u4e19\u4e19", "\u6bd4\u80a9");
            this.put("\u4e19\u4e01", "\u52ab\u8d22");
            this.put("\u4e19\u620a", "\u98df\u795e");
            this.put("\u4e19\u5df1", "\u4f24\u5b98");
            this.put("\u4e19\u5e9a", "\u504f\u8d22");
            this.put("\u4e19\u8f9b", "\u6b63\u8d22");
            this.put("\u4e19\u58ec", "\u4e03\u6740");
            this.put("\u4e19\u7678", "\u6b63\u5b98");
            this.put("\u4e19\u7532", "\u504f\u5370");
            this.put("\u4e19\u4e59", "\u6b63\u5370");
            this.put("\u4e01\u4e01", "\u6bd4\u80a9");
            this.put("\u4e01\u4e19", "\u52ab\u8d22");
            this.put("\u4e01\u5df1", "\u98df\u795e");
            this.put("\u4e01\u620a", "\u4f24\u5b98");
            this.put("\u4e01\u8f9b", "\u504f\u8d22");
            this.put("\u4e01\u5e9a", "\u6b63\u8d22");
            this.put("\u4e01\u7678", "\u4e03\u6740");
            this.put("\u4e01\u58ec", "\u6b63\u5b98");
            this.put("\u4e01\u4e59", "\u504f\u5370");
            this.put("\u4e01\u7532", "\u6b63\u5370");
            this.put("\u620a\u620a", "\u6bd4\u80a9");
            this.put("\u620a\u5df1", "\u52ab\u8d22");
            this.put("\u620a\u5e9a", "\u98df\u795e");
            this.put("\u620a\u8f9b", "\u4f24\u5b98");
            this.put("\u620a\u58ec", "\u504f\u8d22");
            this.put("\u620a\u7678", "\u6b63\u8d22");
            this.put("\u620a\u7532", "\u4e03\u6740");
            this.put("\u620a\u4e59", "\u6b63\u5b98");
            this.put("\u620a\u4e19", "\u504f\u5370");
            this.put("\u620a\u4e01", "\u6b63\u5370");
            this.put("\u5df1\u5df1", "\u6bd4\u80a9");
            this.put("\u5df1\u620a", "\u52ab\u8d22");
            this.put("\u5df1\u8f9b", "\u98df\u795e");
            this.put("\u5df1\u5e9a", "\u4f24\u5b98");
            this.put("\u5df1\u7678", "\u504f\u8d22");
            this.put("\u5df1\u58ec", "\u6b63\u8d22");
            this.put("\u5df1\u4e59", "\u4e03\u6740");
            this.put("\u5df1\u7532", "\u6b63\u5b98");
            this.put("\u5df1\u4e01", "\u504f\u5370");
            this.put("\u5df1\u4e19", "\u6b63\u5370");
            this.put("\u5e9a\u5e9a", "\u6bd4\u80a9");
            this.put("\u5e9a\u8f9b", "\u52ab\u8d22");
            this.put("\u5e9a\u58ec", "\u98df\u795e");
            this.put("\u5e9a\u7678", "\u4f24\u5b98");
            this.put("\u5e9a\u7532", "\u504f\u8d22");
            this.put("\u5e9a\u4e59", "\u6b63\u8d22");
            this.put("\u5e9a\u4e19", "\u4e03\u6740");
            this.put("\u5e9a\u4e01", "\u6b63\u5b98");
            this.put("\u5e9a\u620a", "\u504f\u5370");
            this.put("\u5e9a\u5df1", "\u6b63\u5370");
            this.put("\u8f9b\u8f9b", "\u6bd4\u80a9");
            this.put("\u8f9b\u5e9a", "\u52ab\u8d22");
            this.put("\u8f9b\u7678", "\u98df\u795e");
            this.put("\u8f9b\u58ec", "\u4f24\u5b98");
            this.put("\u8f9b\u4e59", "\u504f\u8d22");
            this.put("\u8f9b\u7532", "\u6b63\u8d22");
            this.put("\u8f9b\u4e01", "\u4e03\u6740");
            this.put("\u8f9b\u4e19", "\u6b63\u5b98");
            this.put("\u8f9b\u5df1", "\u504f\u5370");
            this.put("\u8f9b\u620a", "\u6b63\u5370");
            this.put("\u58ec\u58ec", "\u6bd4\u80a9");
            this.put("\u58ec\u7678", "\u52ab\u8d22");
            this.put("\u58ec\u7532", "\u98df\u795e");
            this.put("\u58ec\u4e59", "\u4f24\u5b98");
            this.put("\u58ec\u4e19", "\u504f\u8d22");
            this.put("\u58ec\u4e01", "\u6b63\u8d22");
            this.put("\u58ec\u620a", "\u4e03\u6740");
            this.put("\u58ec\u5df1", "\u6b63\u5b98");
            this.put("\u58ec\u5e9a", "\u504f\u5370");
            this.put("\u58ec\u8f9b", "\u6b63\u5370");
            this.put("\u7678\u7678", "\u6bd4\u80a9");
            this.put("\u7678\u58ec", "\u52ab\u8d22");
            this.put("\u7678\u4e59", "\u98df\u795e");
            this.put("\u7678\u7532", "\u4f24\u5b98");
            this.put("\u7678\u4e01", "\u504f\u8d22");
            this.put("\u7678\u4e19", "\u6b63\u8d22");
            this.put("\u7678\u5df1", "\u4e03\u6740");
            this.put("\u7678\u620a", "\u6b63\u5b98");
            this.put("\u7678\u8f9b", "\u504f\u5370");
            this.put("\u7678\u5e9a", "\u6b63\u5370");
        }
    };
    public static final Map<String, String> SHI_SHEN_ZHI = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u7532\u5b50\u7678", "\u6b63\u5370");
            this.put("\u7532\u4e11\u7678", "\u6b63\u5370");
            this.put("\u7532\u4e11\u5df1", "\u6b63\u8d22");
            this.put("\u7532\u4e11\u8f9b", "\u6b63\u5b98");
            this.put("\u7532\u5bc5\u4e19", "\u98df\u795e");
            this.put("\u7532\u5bc5\u7532", "\u6bd4\u80a9");
            this.put("\u7532\u5bc5\u620a", "\u504f\u8d22");
            this.put("\u7532\u536f\u4e59", "\u52ab\u8d22");
            this.put("\u7532\u8fb0\u4e59", "\u52ab\u8d22");
            this.put("\u7532\u8fb0\u620a", "\u504f\u8d22");
            this.put("\u7532\u8fb0\u7678", "\u6b63\u5370");
            this.put("\u7532\u5df3\u620a", "\u504f\u8d22");
            this.put("\u7532\u5df3\u4e19", "\u98df\u795e");
            this.put("\u7532\u5df3\u5e9a", "\u4e03\u6740");
            this.put("\u7532\u5348\u4e01", "\u4f24\u5b98");
            this.put("\u7532\u5348\u5df1", "\u6b63\u8d22");
            this.put("\u7532\u672a\u4e59", "\u52ab\u8d22");
            this.put("\u7532\u672a\u5df1", "\u6b63\u8d22");
            this.put("\u7532\u672a\u4e01", "\u4f24\u5b98");
            this.put("\u7532\u7533\u620a", "\u504f\u8d22");
            this.put("\u7532\u7533\u5e9a", "\u4e03\u6740");
            this.put("\u7532\u7533\u58ec", "\u504f\u5370");
            this.put("\u7532\u9149\u8f9b", "\u6b63\u5b98");
            this.put("\u7532\u620c\u8f9b", "\u6b63\u5b98");
            this.put("\u7532\u620c\u620a", "\u504f\u8d22");
            this.put("\u7532\u620c\u4e01", "\u4f24\u5b98");
            this.put("\u7532\u4ea5\u58ec", "\u504f\u5370");
            this.put("\u7532\u4ea5\u7532", "\u6bd4\u80a9");
            this.put("\u4e59\u5b50\u7678", "\u504f\u5370");
            this.put("\u4e59\u4e11\u7678", "\u504f\u5370");
            this.put("\u4e59\u4e11\u5df1", "\u504f\u8d22");
            this.put("\u4e59\u4e11\u8f9b", "\u4e03\u6740");
            this.put("\u4e59\u5bc5\u4e19", "\u4f24\u5b98");
            this.put("\u4e59\u5bc5\u7532", "\u52ab\u8d22");
            this.put("\u4e59\u5bc5\u620a", "\u6b63\u8d22");
            this.put("\u4e59\u536f\u4e59", "\u6bd4\u80a9");
            this.put("\u4e59\u8fb0\u4e59", "\u6bd4\u80a9");
            this.put("\u4e59\u8fb0\u620a", "\u6b63\u8d22");
            this.put("\u4e59\u8fb0\u7678", "\u504f\u5370");
            this.put("\u4e59\u5df3\u620a", "\u6b63\u8d22");
            this.put("\u4e59\u5df3\u4e19", "\u4f24\u5b98");
            this.put("\u4e59\u5df3\u5e9a", "\u6b63\u5b98");
            this.put("\u4e59\u5348\u4e01", "\u98df\u795e");
            this.put("\u4e59\u5348\u5df1", "\u504f\u8d22");
            this.put("\u4e59\u672a\u4e59", "\u6bd4\u80a9");
            this.put("\u4e59\u672a\u5df1", "\u504f\u8d22");
            this.put("\u4e59\u672a\u4e01", "\u98df\u795e");
            this.put("\u4e59\u7533\u620a", "\u6b63\u8d22");
            this.put("\u4e59\u7533\u5e9a", "\u6b63\u5b98");
            this.put("\u4e59\u7533\u58ec", "\u6b63\u5370");
            this.put("\u4e59\u9149\u8f9b", "\u4e03\u6740");
            this.put("\u4e59\u620c\u8f9b", "\u4e03\u6740");
            this.put("\u4e59\u620c\u620a", "\u6b63\u8d22");
            this.put("\u4e59\u620c\u4e01", "\u98df\u795e");
            this.put("\u4e59\u4ea5\u58ec", "\u6b63\u5370");
            this.put("\u4e59\u4ea5\u7532", "\u52ab\u8d22");
            this.put("\u4e19\u5b50\u7678", "\u6b63\u5b98");
            this.put("\u4e19\u4e11\u7678", "\u6b63\u5b98");
            this.put("\u4e19\u4e11\u5df1", "\u4f24\u5b98");
            this.put("\u4e19\u4e11\u8f9b", "\u6b63\u8d22");
            this.put("\u4e19\u5bc5\u4e19", "\u6bd4\u80a9");
            this.put("\u4e19\u5bc5\u7532", "\u504f\u5370");
            this.put("\u4e19\u5bc5\u620a", "\u98df\u795e");
            this.put("\u4e19\u536f\u4e59", "\u6b63\u5370");
            this.put("\u4e19\u8fb0\u4e59", "\u6b63\u5370");
            this.put("\u4e19\u8fb0\u620a", "\u98df\u795e");
            this.put("\u4e19\u8fb0\u7678", "\u6b63\u5b98");
            this.put("\u4e19\u5df3\u620a", "\u98df\u795e");
            this.put("\u4e19\u5df3\u4e19", "\u6bd4\u80a9");
            this.put("\u4e19\u5df3\u5e9a", "\u504f\u8d22");
            this.put("\u4e19\u5348\u4e01", "\u52ab\u8d22");
            this.put("\u4e19\u5348\u5df1", "\u4f24\u5b98");
            this.put("\u4e19\u672a\u4e59", "\u6b63\u5370");
            this.put("\u4e19\u672a\u5df1", "\u4f24\u5b98");
            this.put("\u4e19\u672a\u4e01", "\u52ab\u8d22");
            this.put("\u4e19\u7533\u620a", "\u98df\u795e");
            this.put("\u4e19\u7533\u5e9a", "\u504f\u8d22");
            this.put("\u4e19\u7533\u58ec", "\u4e03\u6740");
            this.put("\u4e19\u9149\u8f9b", "\u6b63\u8d22");
            this.put("\u4e19\u620c\u8f9b", "\u6b63\u8d22");
            this.put("\u4e19\u620c\u620a", "\u98df\u795e");
            this.put("\u4e19\u620c\u4e01", "\u52ab\u8d22");
            this.put("\u4e19\u4ea5\u58ec", "\u4e03\u6740");
            this.put("\u4e19\u4ea5\u7532", "\u504f\u5370");
            this.put("\u4e01\u5b50\u7678", "\u4e03\u6740");
            this.put("\u4e01\u4e11\u7678", "\u4e03\u6740");
            this.put("\u4e01\u4e11\u5df1", "\u98df\u795e");
            this.put("\u4e01\u4e11\u8f9b", "\u504f\u8d22");
            this.put("\u4e01\u5bc5\u4e19", "\u52ab\u8d22");
            this.put("\u4e01\u5bc5\u7532", "\u6b63\u5370");
            this.put("\u4e01\u5bc5\u620a", "\u4f24\u5b98");
            this.put("\u4e01\u536f\u4e59", "\u504f\u5370");
            this.put("\u4e01\u8fb0\u4e59", "\u504f\u5370");
            this.put("\u4e01\u8fb0\u620a", "\u4f24\u5b98");
            this.put("\u4e01\u8fb0\u7678", "\u4e03\u6740");
            this.put("\u4e01\u5df3\u620a", "\u4f24\u5b98");
            this.put("\u4e01\u5df3\u4e19", "\u52ab\u8d22");
            this.put("\u4e01\u5df3\u5e9a", "\u6b63\u8d22");
            this.put("\u4e01\u5348\u4e01", "\u6bd4\u80a9");
            this.put("\u4e01\u5348\u5df1", "\u98df\u795e");
            this.put("\u4e01\u672a\u4e59", "\u504f\u5370");
            this.put("\u4e01\u672a\u5df1", "\u98df\u795e");
            this.put("\u4e01\u672a\u4e01", "\u6bd4\u80a9");
            this.put("\u4e01\u7533\u620a", "\u4f24\u5b98");
            this.put("\u4e01\u7533\u5e9a", "\u6b63\u8d22");
            this.put("\u4e01\u7533\u58ec", "\u6b63\u5b98");
            this.put("\u4e01\u9149\u8f9b", "\u504f\u8d22");
            this.put("\u4e01\u620c\u8f9b", "\u504f\u8d22");
            this.put("\u4e01\u620c\u620a", "\u4f24\u5b98");
            this.put("\u4e01\u620c\u4e01", "\u6bd4\u80a9");
            this.put("\u4e01\u4ea5\u58ec", "\u6b63\u5b98");
            this.put("\u4e01\u4ea5\u7532", "\u6b63\u5370");
            this.put("\u620a\u5b50\u7678", "\u6b63\u8d22");
            this.put("\u620a\u4e11\u7678", "\u6b63\u8d22");
            this.put("\u620a\u4e11\u5df1", "\u52ab\u8d22");
            this.put("\u620a\u4e11\u8f9b", "\u4f24\u5b98");
            this.put("\u620a\u5bc5\u4e19", "\u504f\u5370");
            this.put("\u620a\u5bc5\u7532", "\u4e03\u6740");
            this.put("\u620a\u5bc5\u620a", "\u6bd4\u80a9");
            this.put("\u620a\u536f\u4e59", "\u6b63\u5b98");
            this.put("\u620a\u8fb0\u4e59", "\u6b63\u5b98");
            this.put("\u620a\u8fb0\u620a", "\u6bd4\u80a9");
            this.put("\u620a\u8fb0\u7678", "\u6b63\u8d22");
            this.put("\u620a\u5df3\u620a", "\u6bd4\u80a9");
            this.put("\u620a\u5df3\u4e19", "\u504f\u5370");
            this.put("\u620a\u5df3\u5e9a", "\u98df\u795e");
            this.put("\u620a\u5348\u4e01", "\u6b63\u5370");
            this.put("\u620a\u5348\u5df1", "\u52ab\u8d22");
            this.put("\u620a\u672a\u4e59", "\u6b63\u5b98");
            this.put("\u620a\u672a\u5df1", "\u52ab\u8d22");
            this.put("\u620a\u672a\u4e01", "\u6b63\u5370");
            this.put("\u620a\u7533\u620a", "\u6bd4\u80a9");
            this.put("\u620a\u7533\u5e9a", "\u98df\u795e");
            this.put("\u620a\u7533\u58ec", "\u504f\u8d22");
            this.put("\u620a\u9149\u8f9b", "\u4f24\u5b98");
            this.put("\u620a\u620c\u8f9b", "\u4f24\u5b98");
            this.put("\u620a\u620c\u620a", "\u6bd4\u80a9");
            this.put("\u620a\u620c\u4e01", "\u6b63\u5370");
            this.put("\u620a\u4ea5\u58ec", "\u504f\u8d22");
            this.put("\u620a\u4ea5\u7532", "\u4e03\u6740");
            this.put("\u5df1\u5b50\u7678", "\u504f\u8d22");
            this.put("\u5df1\u4e11\u7678", "\u504f\u8d22");
            this.put("\u5df1\u4e11\u5df1", "\u6bd4\u80a9");
            this.put("\u5df1\u4e11\u8f9b", "\u98df\u795e");
            this.put("\u5df1\u5bc5\u4e19", "\u6b63\u5370");
            this.put("\u5df1\u5bc5\u7532", "\u6b63\u5b98");
            this.put("\u5df1\u5bc5\u620a", "\u52ab\u8d22");
            this.put("\u5df1\u536f\u4e59", "\u4e03\u6740");
            this.put("\u5df1\u8fb0\u4e59", "\u4e03\u6740");
            this.put("\u5df1\u8fb0\u620a", "\u52ab\u8d22");
            this.put("\u5df1\u8fb0\u7678", "\u504f\u8d22");
            this.put("\u5df1\u5df3\u620a", "\u52ab\u8d22");
            this.put("\u5df1\u5df3\u4e19", "\u6b63\u5370");
            this.put("\u5df1\u5df3\u5e9a", "\u4f24\u5b98");
            this.put("\u5df1\u5348\u4e01", "\u504f\u5370");
            this.put("\u5df1\u5348\u5df1", "\u6bd4\u80a9");
            this.put("\u5df1\u672a\u4e59", "\u4e03\u6740");
            this.put("\u5df1\u672a\u5df1", "\u6bd4\u80a9");
            this.put("\u5df1\u672a\u4e01", "\u504f\u5370");
            this.put("\u5df1\u7533\u620a", "\u52ab\u8d22");
            this.put("\u5df1\u7533\u5e9a", "\u4f24\u5b98");
            this.put("\u5df1\u7533\u58ec", "\u6b63\u8d22");
            this.put("\u5df1\u9149\u8f9b", "\u98df\u795e");
            this.put("\u5df1\u620c\u8f9b", "\u98df\u795e");
            this.put("\u5df1\u620c\u620a", "\u52ab\u8d22");
            this.put("\u5df1\u620c\u4e01", "\u504f\u5370");
            this.put("\u5df1\u4ea5\u58ec", "\u6b63\u8d22");
            this.put("\u5df1\u4ea5\u7532", "\u6b63\u5b98");
            this.put("\u5e9a\u5b50\u7678", "\u4f24\u5b98");
            this.put("\u5e9a\u4e11\u7678", "\u4f24\u5b98");
            this.put("\u5e9a\u4e11\u5df1", "\u6b63\u5370");
            this.put("\u5e9a\u4e11\u8f9b", "\u52ab\u8d22");
            this.put("\u5e9a\u5bc5\u4e19", "\u4e03\u6740");
            this.put("\u5e9a\u5bc5\u7532", "\u504f\u8d22");
            this.put("\u5e9a\u5bc5\u620a", "\u504f\u5370");
            this.put("\u5e9a\u536f\u4e59", "\u6b63\u8d22");
            this.put("\u5e9a\u8fb0\u4e59", "\u6b63\u8d22");
            this.put("\u5e9a\u8fb0\u620a", "\u504f\u5370");
            this.put("\u5e9a\u8fb0\u7678", "\u4f24\u5b98");
            this.put("\u5e9a\u5df3\u620a", "\u504f\u5370");
            this.put("\u5e9a\u5df3\u4e19", "\u4e03\u6740");
            this.put("\u5e9a\u5df3\u5e9a", "\u6bd4\u80a9");
            this.put("\u5e9a\u5348\u4e01", "\u6b63\u5b98");
            this.put("\u5e9a\u5348\u5df1", "\u6b63\u5370");
            this.put("\u5e9a\u672a\u4e59", "\u6b63\u8d22");
            this.put("\u5e9a\u672a\u5df1", "\u6b63\u5370");
            this.put("\u5e9a\u672a\u4e01", "\u6b63\u5b98");
            this.put("\u5e9a\u7533\u620a", "\u504f\u5370");
            this.put("\u5e9a\u7533\u5e9a", "\u6bd4\u80a9");
            this.put("\u5e9a\u7533\u58ec", "\u98df\u795e");
            this.put("\u5e9a\u9149\u8f9b", "\u52ab\u8d22");
            this.put("\u5e9a\u620c\u8f9b", "\u52ab\u8d22");
            this.put("\u5e9a\u620c\u620a", "\u504f\u5370");
            this.put("\u5e9a\u620c\u4e01", "\u6b63\u5b98");
            this.put("\u5e9a\u4ea5\u58ec", "\u98df\u795e");
            this.put("\u5e9a\u4ea5\u7532", "\u504f\u8d22");
            this.put("\u8f9b\u5b50\u7678", "\u98df\u795e");
            this.put("\u8f9b\u4e11\u7678", "\u98df\u795e");
            this.put("\u8f9b\u4e11\u5df1", "\u504f\u5370");
            this.put("\u8f9b\u4e11\u8f9b", "\u6bd4\u80a9");
            this.put("\u8f9b\u5bc5\u4e19", "\u6b63\u5b98");
            this.put("\u8f9b\u5bc5\u7532", "\u6b63\u8d22");
            this.put("\u8f9b\u5bc5\u620a", "\u6b63\u5370");
            this.put("\u8f9b\u536f\u4e59", "\u504f\u8d22");
            this.put("\u8f9b\u8fb0\u4e59", "\u504f\u8d22");
            this.put("\u8f9b\u8fb0\u620a", "\u6b63\u5370");
            this.put("\u8f9b\u8fb0\u7678", "\u98df\u795e");
            this.put("\u8f9b\u5df3\u620a", "\u6b63\u5370");
            this.put("\u8f9b\u5df3\u4e19", "\u6b63\u5b98");
            this.put("\u8f9b\u5df3\u5e9a", "\u52ab\u8d22");
            this.put("\u8f9b\u5348\u4e01", "\u4e03\u6740");
            this.put("\u8f9b\u5348\u5df1", "\u504f\u5370");
            this.put("\u8f9b\u672a\u4e59", "\u504f\u8d22");
            this.put("\u8f9b\u672a\u5df1", "\u504f\u5370");
            this.put("\u8f9b\u672a\u4e01", "\u4e03\u6740");
            this.put("\u8f9b\u7533\u620a", "\u6b63\u5370");
            this.put("\u8f9b\u7533\u5e9a", "\u52ab\u8d22");
            this.put("\u8f9b\u7533\u58ec", "\u4f24\u5b98");
            this.put("\u8f9b\u9149\u8f9b", "\u6bd4\u80a9");
            this.put("\u8f9b\u620c\u8f9b", "\u6bd4\u80a9");
            this.put("\u8f9b\u620c\u620a", "\u6b63\u5370");
            this.put("\u8f9b\u620c\u4e01", "\u4e03\u6740");
            this.put("\u8f9b\u4ea5\u58ec", "\u4f24\u5b98");
            this.put("\u8f9b\u4ea5\u7532", "\u6b63\u8d22");
            this.put("\u58ec\u5b50\u7678", "\u52ab\u8d22");
            this.put("\u58ec\u4e11\u7678", "\u52ab\u8d22");
            this.put("\u58ec\u4e11\u5df1", "\u6b63\u5b98");
            this.put("\u58ec\u4e11\u8f9b", "\u6b63\u5370");
            this.put("\u58ec\u5bc5\u4e19", "\u504f\u8d22");
            this.put("\u58ec\u5bc5\u7532", "\u98df\u795e");
            this.put("\u58ec\u5bc5\u620a", "\u4e03\u6740");
            this.put("\u58ec\u536f\u4e59", "\u4f24\u5b98");
            this.put("\u58ec\u8fb0\u4e59", "\u4f24\u5b98");
            this.put("\u58ec\u8fb0\u620a", "\u4e03\u6740");
            this.put("\u58ec\u8fb0\u7678", "\u52ab\u8d22");
            this.put("\u58ec\u5df3\u620a", "\u4e03\u6740");
            this.put("\u58ec\u5df3\u4e19", "\u504f\u8d22");
            this.put("\u58ec\u5df3\u5e9a", "\u504f\u5370");
            this.put("\u58ec\u5348\u4e01", "\u6b63\u8d22");
            this.put("\u58ec\u5348\u5df1", "\u6b63\u5b98");
            this.put("\u58ec\u672a\u4e59", "\u4f24\u5b98");
            this.put("\u58ec\u672a\u5df1", "\u6b63\u5b98");
            this.put("\u58ec\u672a\u4e01", "\u6b63\u8d22");
            this.put("\u58ec\u7533\u620a", "\u4e03\u6740");
            this.put("\u58ec\u7533\u5e9a", "\u504f\u5370");
            this.put("\u58ec\u7533\u58ec", "\u6bd4\u80a9");
            this.put("\u58ec\u9149\u8f9b", "\u6b63\u5370");
            this.put("\u58ec\u620c\u8f9b", "\u6b63\u5370");
            this.put("\u58ec\u620c\u620a", "\u4e03\u6740");
            this.put("\u58ec\u620c\u4e01", "\u6b63\u8d22");
            this.put("\u58ec\u4ea5\u58ec", "\u6bd4\u80a9");
            this.put("\u58ec\u4ea5\u7532", "\u98df\u795e");
            this.put("\u7678\u5b50\u7678", "\u6bd4\u80a9");
            this.put("\u7678\u4e11\u7678", "\u6bd4\u80a9");
            this.put("\u7678\u4e11\u5df1", "\u4e03\u6740");
            this.put("\u7678\u4e11\u8f9b", "\u504f\u5370");
            this.put("\u7678\u5bc5\u4e19", "\u6b63\u8d22");
            this.put("\u7678\u5bc5\u7532", "\u4f24\u5b98");
            this.put("\u7678\u5bc5\u620a", "\u6b63\u5b98");
            this.put("\u7678\u536f\u4e59", "\u98df\u795e");
            this.put("\u7678\u8fb0\u4e59", "\u98df\u795e");
            this.put("\u7678\u8fb0\u620a", "\u6b63\u5b98");
            this.put("\u7678\u8fb0\u7678", "\u6bd4\u80a9");
            this.put("\u7678\u5df3\u620a", "\u6b63\u5b98");
            this.put("\u7678\u5df3\u4e19", "\u6b63\u8d22");
            this.put("\u7678\u5df3\u5e9a", "\u6b63\u5370");
            this.put("\u7678\u5348\u4e01", "\u504f\u8d22");
            this.put("\u7678\u5348\u5df1", "\u4e03\u6740");
            this.put("\u7678\u672a\u4e59", "\u98df\u795e");
            this.put("\u7678\u672a\u5df1", "\u4e03\u6740");
            this.put("\u7678\u672a\u4e01", "\u504f\u8d22");
            this.put("\u7678\u7533\u620a", "\u6b63\u5b98");
            this.put("\u7678\u7533\u5e9a", "\u6b63\u5370");
            this.put("\u7678\u7533\u58ec", "\u52ab\u8d22");
            this.put("\u7678\u9149\u8f9b", "\u504f\u5370");
            this.put("\u7678\u620c\u8f9b", "\u504f\u5370");
            this.put("\u7678\u620c\u620a", "\u6b63\u5b98");
            this.put("\u7678\u620c\u4e01", "\u504f\u8d22");
            this.put("\u7678\u4ea5\u58ec", "\u52ab\u8d22");
            this.put("\u7678\u4ea5\u7532", "\u4f24\u5b98");
        }
    };
    public static final Map<String, List<String>> ZHI_HIDE_GAN = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u5b50", Collections.nCopies(1, "\u7678"));
            this.put("\u4e11", Arrays.asList("\u5df1", "\u7678", "\u8f9b"));
            this.put("\u5bc5", Arrays.asList("\u7532", "\u4e19", "\u620a"));
            this.put("\u536f", Collections.nCopies(1, "\u4e59"));
            this.put("\u8fb0", Arrays.asList("\u620a", "\u4e59", "\u7678"));
            this.put("\u5df3", Arrays.asList("\u4e19", "\u5e9a", "\u620a"));
            this.put("\u5348", Arrays.asList("\u4e01", "\u5df1"));
            this.put("\u672a", Arrays.asList("\u5df1", "\u4e01", "\u4e59"));
            this.put("\u7533", Arrays.asList("\u5e9a", "\u58ec", "\u620a"));
            this.put("\u9149", Collections.nCopies(1, "\u8f9b"));
            this.put("\u620c", Arrays.asList("\u620a", "\u8f9b", "\u4e01"));
            this.put("\u4ea5", Arrays.asList("\u58ec", "\u7532"));
        }
    };

    protected LunarUtil() {
    }

    public static int computeAddDays(int year, int month, int day) {
        int y = 1900;
        int m = 11;
        int diff = LunarUtil.getDaysOfMonth(y, m) - 11;
        m = LunarUtil.nextMonth(y, m);
        do {
            diff += LunarUtil.getDaysOfMonth(y, m);
            if ((m = LunarUtil.nextMonth(y, m)) != 1) continue;
            ++y;
        } while (y != year || m != month);
        return diff += day;
    }

    public static int nextMonth(int y, int m) {
        int n = Math.abs(m) + 1;
        if (m > 0) {
            int index = y - 1900 + 0;
            int v = LUNAR_MONTH[2 * index + 1];
            if ((v = v >> 4 & 0xF) == m) {
                n = -m;
            }
        }
        if (n == 13) {
            n = 1;
        }
        return n;
    }

    public static int getDaysOfMonth(int year, int month) {
        int d;
        block4: {
            int index;
            block5: {
                block3: {
                    index = year - 1900 + 0;
                    d = 30;
                    if (1 > month || month > 8) break block3;
                    int v = LUNAR_MONTH[2 * index];
                    int l = month - 1;
                    if ((v >> l & 1) != 1) break block4;
                    d = 29;
                    break block4;
                }
                if (9 > month || month > 12) break block5;
                int v = LUNAR_MONTH[2 * index + 1];
                int l = month - 9;
                if ((v >> l & 1) != 1) break block4;
                d = 29;
                break block4;
            }
            int v = LUNAR_MONTH[2 * index + 1];
            if ((v = v >> 4 & 0xF) != Math.abs(month)) {
                d = 0;
            } else {
                d = 29;
                for (int i : LEAP_MONTH_YEAR) {
                    if (i != index) continue;
                    d = 30;
                    break;
                }
            }
        }
        return d;
    }

    public static String convertTime(String hm) {
        if (null == hm) {
            return null;
        }
        if (hm.length() > 5) {
            hm = hm.substring(0, 5);
        }
        int x = 2;
        for (int i = 1; i < 22; i += 2) {
            if (hm.compareTo((i < 10 ? "0" : "") + i + ":00") >= 0 && hm.compareTo((i + 1 < 10 ? "0" : "") + (i + 1) + ":59") <= 0) {
                return ZHI[x];
            }
            ++x;
        }
        return ZHI[1];
    }
}

