/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Solar;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarWeek {
    private int year;
    private int month;
    private int day;
    private int start;

    public SolarWeek(int start) {
        this(new Date(), start);
    }

    public SolarWeek(Date date, int start) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        this.year = c.get(1);
        this.month = c.get(2) + 1;
        this.day = c.get(5);
        this.start = start;
    }

    public SolarWeek(Calendar calendar, int start) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.start = start;
    }

    public SolarWeek(int year, int month, int day, int start) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.start = start;
    }

    public static SolarWeek fromDate(Date date, int start) {
        return new SolarWeek(date, start);
    }

    public static SolarWeek fromCalendar(Calendar calendar, int start) {
        return new SolarWeek(calendar, start);
    }

    public static SolarWeek fromYmd(int year, int month, int day, int start) {
        return new SolarWeek(year, month, day, start);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getStart() {
        return this.start;
    }

    public int getIndex() {
        Calendar c = Calendar.getInstance();
        c.set(this.year, this.month - 1, 1);
        int firstDayWeek = c.get(7) - 1;
        return (int)Math.ceil((double)(this.day + firstDayWeek - this.start) / 7.0);
    }

    public SolarWeek next(int weeks, boolean separateMonth) {
        if (0 == weeks) {
            return new SolarWeek(this.year, this.month, this.day, this.start);
        }
        if (separateMonth) {
            int n;
            boolean plus;
            Calendar c = Calendar.getInstance();
            c.set(this.year, this.month - 1, this.day);
            SolarWeek week = new SolarWeek(c, this.start);
            int month = this.month;
            boolean bl = plus = n > 0;
            for (n = weeks; 0 != n; n -= plus ? 1 : -1) {
                c.add(5, plus ? 7 : -7);
                week = new SolarWeek(c, this.start);
                int weekMonth = week.getMonth();
                if (month == weekMonth) continue;
                int index = week.getIndex();
                if (plus) {
                    if (1 == index) {
                        Solar firstDay = week.getFirstDay();
                        week = new SolarWeek(firstDay.getYear(), firstDay.getMonth(), firstDay.getDay(), this.start);
                        weekMonth = week.getMonth();
                    } else {
                        c.set(week.getYear(), week.getMonth() - 1, 1);
                        week = new SolarWeek(c, this.start);
                    }
                } else {
                    int size = SolarUtil.getWeeksOfMonth(week.getYear(), week.getMonth(), this.start);
                    if (size == index) {
                        Solar firstDay = week.getFirstDay();
                        Solar lastDay = firstDay.next(6);
                        week = new SolarWeek(lastDay.getYear(), lastDay.getMonth(), lastDay.getDay(), this.start);
                        weekMonth = week.getMonth();
                    } else {
                        c.set(week.getYear(), week.getMonth() - 1, SolarUtil.getDaysOfMonth(week.getYear(), week.getMonth()));
                        week = new SolarWeek(c, this.start);
                    }
                }
                month = weekMonth;
            }
            return week;
        }
        Calendar c = Calendar.getInstance();
        c.set(this.year, this.month - 1, this.day);
        c.add(5, weeks * 7);
        return new SolarWeek(c, this.start);
    }

    public Solar getFirstDay() {
        Calendar c = Calendar.getInstance();
        c.set(this.year, this.month - 1, this.day);
        int week = c.get(7) - 1;
        int prev = week - this.start;
        if (prev < 0) {
            prev += 7;
        }
        c.add(5, -prev);
        return new Solar(c);
    }

    public Solar getFirstDayInMonth() {
        List<Solar> days = this.getDays();
        for (Solar day : days) {
            if (this.month != day.getMonth()) continue;
            return day;
        }
        return null;
    }

    public List<Solar> getDays() {
        Solar firstDay = this.getFirstDay();
        ArrayList<Solar> l = new ArrayList<Solar>();
        l.add(firstDay);
        for (int i = 1; i < 7; ++i) {
            l.add(firstDay.next(i));
        }
        return l;
    }

    public List<Solar> getDaysInMonth() {
        List<Solar> days = this.getDays();
        ArrayList<Solar> l = new ArrayList<Solar>();
        for (Solar day : days) {
            if (this.month != day.getMonth()) continue;
            l.add(day);
        }
        return l;
    }

    public String toString() {
        return this.year + "." + this.month + "." + this.getIndex();
    }

    public String toFullString() {
        return this.year + "\u5e74" + this.month + "\u6708\u7b2c" + this.getIndex() + "\u5468";
    }
}

