/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solar {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private Calendar calendar;

    public Solar() {
        this(new Date());
    }

    public Solar(int year, int month, int day) {
        this.calendar = Calendar.getInstance();
        this.calendar.set(year, month - 1, day);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = 0;
        this.minute = 0;
    }

    public Solar(int year, int month, int day, int hour, int minute) {
        this.calendar = Calendar.getInstance();
        this.calendar.set(year, month - 1, day, hour, minute);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
    }

    public Solar(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2) + 1;
        this.day = this.calendar.get(5);
        this.hour = this.calendar.get(11);
        this.minute = this.calendar.get(12);
    }

    public Solar(Calendar calendar) {
        this.calendar = calendar;
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
    }

    public static Solar fromDate(Date date) {
        return new Solar(date);
    }

    public static Solar fromCalendar(Calendar calendar) {
        return new Solar(calendar);
    }

    public static Solar fromYmd(int year, int month, int day) {
        return new Solar(year, month, day);
    }

    public static Solar fromYmdHm(int year, int month, int day, int hour, int minute) {
        return new Solar(year, month, day, hour, minute);
    }

    public boolean isLeapYear() {
        return SolarUtil.isLeapYear(this.year);
    }

    public int getWeek() {
        return this.calendar.get(7) - 1;
    }

    public String getWeekInChinese() {
        return SolarUtil.WEEK[this.getWeek()];
    }

    public List<String> getFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        String f = SolarUtil.FESTIVAL.get(this.month + "-" + this.day);
        if (null != f) {
            l.add(f);
        }
        int weekInMonth = this.calendar.get(4);
        int week = this.getWeek();
        if (0 == week) {
            --weekInMonth;
        }
        if (null != (f = SolarUtil.WEEK_FESTIVAL.get(this.month + "-" + weekInMonth + "-" + week))) {
            l.add(f);
        }
        return l;
    }

    public List<String> getOtherFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        List<String> fs = SolarUtil.OTHER_FESTIVAL.get(this.month + "-" + this.day);
        if (null != fs) {
            l.addAll(fs);
        }
        return l;
    }

    public String getXingzuo() {
        int index = 11;
        int m = this.month;
        int d = this.day;
        int y = m * 100 + d;
        if (y >= 321 && y <= 419) {
            index = 0;
        } else if (y >= 420 && y <= 520) {
            index = 1;
        } else if (y >= 521 && y <= 620) {
            index = 2;
        } else if (y >= 621 && y <= 722) {
            index = 3;
        } else if (y >= 723 && y <= 822) {
            index = 4;
        } else if (y >= 823 && y <= 922) {
            index = 5;
        } else if (y >= 923 && y <= 1022) {
            index = 6;
        } else if (y >= 1023 && y <= 1121) {
            index = 7;
        } else if (y >= 1122 && y <= 1221) {
            index = 8;
        } else if (y >= 1222 || y <= 119) {
            index = 9;
        } else if (y <= 218) {
            index = 10;
        }
        return SolarUtil.XINGZUO[index];
    }

    public String getXingZuo() {
        int index = 11;
        int m = this.month;
        int d = this.day;
        int y = m * 100 + d;
        if (y >= 321 && y <= 419) {
            index = 0;
        } else if (y >= 420 && y <= 520) {
            index = 1;
        } else if (y >= 521 && y <= 620) {
            index = 2;
        } else if (y >= 621 && y <= 722) {
            index = 3;
        } else if (y >= 723 && y <= 822) {
            index = 4;
        } else if (y >= 823 && y <= 922) {
            index = 5;
        } else if (y >= 923 && y <= 1022) {
            index = 6;
        } else if (y >= 1023 && y <= 1121) {
            index = 7;
        } else if (y >= 1122 && y <= 1221) {
            index = 8;
        } else if (y >= 1222 || y <= 119) {
            index = 9;
        } else if (y <= 218) {
            index = 10;
        }
        return SolarUtil.XINGZUO[index];
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public Lunar getLunar() {
        return new Lunar(this.calendar.getTime());
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String toString() {
        return this.year + "-" + (this.month < 10 ? "0" : "") + this.month + "-" + (this.day < 10 ? "0" : "") + this.day;
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this.toString());
        s.append(" ");
        s.append(this.hour < 10 ? "0" : "");
        s.append(this.hour);
        s.append(":");
        s.append(this.minute < 10 ? "0" : "");
        s.append(this.minute);
        if (this.isLeapYear()) {
            s.append(" ");
            s.append("\u95f0\u5e74");
        }
        s.append(" ");
        s.append("\u661f\u671f");
        s.append(this.getWeekInChinese());
        for (String f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        for (String f : this.getOtherFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        s.append(" ");
        s.append(this.getXingZuo());
        s.append("\u5ea7");
        return s.toString();
    }

    public Solar next(int days) {
        Calendar c = Calendar.getInstance();
        c.set(this.year, this.month - 1, this.day);
        c.add(5, days);
        return new Solar(c);
    }
}

