/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Solar;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lunar {
    private int year;
    private int month;
    private int day;
    private Solar solar;
    private int dayOffset;
    private int dayGanIndex;
    private int dayZhiIndex;
    private int hour;
    private int minute;

    public Lunar() {
        this(new Date());
    }

    public Lunar(int lunarYear, int lunarMonth, int lunarDay) {
        this(lunarYear, lunarMonth, lunarDay, 0, 0);
    }

    public Lunar(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute) {
        this.year = lunarYear;
        this.month = lunarMonth;
        this.day = lunarDay;
        this.hour = hour;
        this.minute = minute;
        this.dayOffset = LunarUtil.computeAddDays(this.year, this.month, this.day);
        int addDays = (this.dayOffset + 15) % 60;
        this.dayGanIndex = addDays % 10;
        this.dayZhiIndex = addDays % 12;
        this.solar = this.toSolar();
    }

    public Lunar(Date date) {
        int i;
        int lunarDay;
        int lunarMonth;
        int lunarYear;
        int startDay;
        int startMonth;
        int startYear;
        this.solar = new Solar(date);
        int y = this.solar.getYear();
        int m = this.solar.getMonth();
        int d = this.solar.getDay();
        if (y < 2000) {
            startYear = 1901;
            startMonth = 1;
            startDay = 1;
            lunarYear = 1900;
            lunarMonth = 11;
            lunarDay = 11;
        } else {
            startYear = 2000;
            startMonth = 1;
            startDay = 1;
            lunarYear = 1999;
            lunarMonth = 11;
            lunarDay = 25;
        }
        int diff = 0;
        for (i = startYear; i < y; ++i) {
            diff += 365;
            if (!SolarUtil.isLeapYear(i)) continue;
            ++diff;
        }
        for (i = startMonth; i < m; ++i) {
            diff += SolarUtil.getDaysOfMonth(y, i);
        }
        lunarDay += (diff += d - startDay);
        int lastDate = LunarUtil.getDaysOfMonth(lunarYear, lunarMonth);
        while (lunarDay > lastDate) {
            lunarDay -= lastDate;
            if ((lunarMonth = LunarUtil.nextMonth(lunarYear, lunarMonth)) == 1) {
                ++lunarYear;
            }
            lastDate = LunarUtil.getDaysOfMonth(lunarYear, lunarMonth);
        }
        this.year = lunarYear;
        this.month = lunarMonth;
        this.day = lunarDay;
        this.hour = this.solar.getHour();
        this.minute = this.solar.getMinute();
        this.dayOffset = LunarUtil.computeAddDays(this.year, this.month, this.day);
        int addDays = (this.dayOffset + 15) % 60;
        this.dayGanIndex = addDays % 10;
        this.dayZhiIndex = addDays % 12;
    }

    public static Lunar fromDate(Date date) {
        return new Lunar(date);
    }

    public static Lunar fromYmd(int lunarYear, int lunarMonth, int lunarDay) {
        return new Lunar(lunarYear, lunarMonth, lunarDay);
    }

    public static Lunar fromYmdHm(int lunarYear, int lunarMonth, int lunarDay, int hour, int minute) {
        return new Lunar(lunarYear, lunarMonth, lunarDay, hour, minute);
    }

    public String getGan() {
        return LunarUtil.GAN[(this.year - 4) % 10 + 1];
    }

    public String getYearGan() {
        return LunarUtil.GAN[(this.year - 4) % 10 + 1];
    }

    public String getZhi() {
        return LunarUtil.ZHI[(this.year - 4) % 12 + 1];
    }

    public String getYearZhi() {
        return LunarUtil.ZHI[(this.year - 4) % 12 + 1];
    }

    public String getYearInGanZhi() {
        return this.getYearGan() + this.getYearZhi();
    }

    public String getShengxiao() {
        return LunarUtil.SHENGXIAO[(this.year - 4) % 12 + 1];
    }

    public String getYearShengXiao() {
        return LunarUtil.SHENGXIAO[(this.year - 4) % 12 + 1];
    }

    public String getMonthShengXiao() {
        String zhi = this.getMonthZhi();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(zhi)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getDayShengXiao() {
        String zhi = this.getDayZhi();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(zhi)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getTimeShengXiao() {
        String zhi = this.getTimeZhi();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(zhi)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getYearInChinese() {
        String y = this.year + "";
        StringBuilder s = new StringBuilder();
        int j = y.length();
        for (int i = 0; i < j; ++i) {
            s.append(LunarUtil.NUMBER[y.charAt(i) - 48]);
        }
        return s.toString();
    }

    public String getMonthInChinese() {
        if (this.month > 0) {
            return LunarUtil.MONTH[this.month];
        }
        return "\u95f0" + LunarUtil.MONTH[-this.month];
    }

    public String getTimeZhi() {
        String time = (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute;
        return LunarUtil.convertTime(time);
    }

    public String getTimeGan() {
        String zhi = this.getTimeZhi();
        int j = LunarUtil.ZHI.length;
        for (int i = 1; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(zhi)) continue;
            return LunarUtil.GAN[1 + (i - 1) % 10];
        }
        return null;
    }

    public String getTimeInGanZhi() {
        String zhi = this.getTimeZhi();
        int j = LunarUtil.ZHI.length;
        for (int i = 1; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(zhi)) continue;
            return LunarUtil.GAN[1 + (i - 1) % 10] + zhi;
        }
        return zhi;
    }

    public String getSeason() {
        return LunarUtil.SEASON[Math.abs(this.month)];
    }

    public String getDayInChinese() {
        return LunarUtil.DAY[this.day];
    }

    public String getJie() {
        String s = "";
        int solarYear = this.solar.getYear();
        int solarMonth = this.solar.getMonth();
        int solarDay = this.solar.getDay();
        int index = 0;
        int ry = solarYear - 1901 + 1;
        while (ry >= LunarUtil.JIE_YEAR[solarMonth - 1][index]) {
            ++index;
        }
        int term = LunarUtil.JIE_MAP[solarMonth - 1][4 * index + ry % 4];
        if (ry == 121 && solarMonth == 4) {
            term = 5;
        }
        if (ry == 132 && solarMonth == 4) {
            term = 5;
        }
        if (ry == 194 && solarMonth == 6) {
            term = 6;
        }
        if (solarDay == term) {
            s = LunarUtil.JIE[solarMonth - 1];
        }
        return s;
    }

    public String getQi() {
        String s = "";
        int solarYear = this.solar.getYear();
        int solarMonth = this.solar.getMonth();
        int solarDay = this.solar.getDay();
        int index = 0;
        int ry = solarYear - 1901 + 1;
        while (ry >= LunarUtil.QI_YEAR[solarMonth - 1][index]) {
            ++index;
        }
        int term = LunarUtil.QI_MAP[solarMonth - 1][4 * index + ry % 4];
        if (ry == 171 && solarMonth == 3) {
            term = 21;
        }
        if (ry == 181 && solarMonth == 5) {
            term = 21;
        }
        if (solarDay == term) {
            s = LunarUtil.QI[solarMonth - 1];
        }
        return s;
    }

    public int getWeek() {
        return (this.dayOffset + 2) % 7;
    }

    public String getWeekInChinese() {
        return SolarUtil.WEEK[this.getWeek()];
    }

    public String getXiu() {
        return LunarUtil.XIU.get(this.getDayZhi() + this.getWeek());
    }

    public String getXiuLuck() {
        return LunarUtil.XIU_LUCK.get(this.getXiu());
    }

    public String getXiuSong() {
        return LunarUtil.XIU_SONG.get(this.getXiu());
    }

    public String getZheng() {
        return LunarUtil.ZHENG.get(this.getXiu());
    }

    public String getAnimal() {
        return LunarUtil.ANIMAL.get(this.getXiu());
    }

    public String getGong() {
        return LunarUtil.GONG.get(this.getXiu());
    }

    public String getShou() {
        return LunarUtil.SHOU.get(this.getGong());
    }

    public List<String> getFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        String f = LunarUtil.FESTIVAL.get(this.month + "-" + this.day);
        if (null != f) {
            l.add(f);
        }
        return l;
    }

    public List<String> getOtherFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        List<String> fs = LunarUtil.OTHER_FESTIVAL.get(this.month + "-" + this.day);
        if (null != fs) {
            l.addAll(fs);
        }
        return l;
    }

    private Solar toSolar() {
        Calendar c = Calendar.getInstance();
        c.set(1901, 0, 1);
        c.add(5, this.dayOffset);
        c.set(11, this.hour);
        c.set(12, this.minute);
        return new Solar(c);
    }

    public String getMonthInGanZhi() {
        return this.getMonthGan() + this.getMonthZhi();
    }

    public String getMonthGan() {
        int m = Math.abs(this.month) - 1;
        int yearGanIndex = (this.year - 4) % 10;
        int offset = (yearGanIndex % 5 + 1) * 2;
        return LunarUtil.GAN[(m + offset) % 10 + 1];
    }

    public String getMonthZhi() {
        int m = Math.abs(this.month) - 1;
        return LunarUtil.ZHI[(m + 2) % 12 + 1];
    }

    public String getDayInGanZhi() {
        return this.getDayGan() + this.getDayZhi();
    }

    public String getDayGan() {
        return LunarUtil.GAN[this.dayGanIndex + 1];
    }

    public String getDayZhi() {
        return LunarUtil.ZHI[this.dayZhiIndex + 1];
    }

    public String getPengZuGan() {
        return LunarUtil.PENGZU_GAN[this.dayGanIndex + 1];
    }

    public String getPengZuZhi() {
        return LunarUtil.PENGZU_ZHI[this.dayZhiIndex + 1];
    }

    public String getPositionXi() {
        return LunarUtil.POSITION_XI[this.dayGanIndex + 1];
    }

    public String getPositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionXi());
    }

    public String getPositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.dayGanIndex + 1];
    }

    public String getPositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYangGui());
    }

    public String getPositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.dayGanIndex + 1];
    }

    public String getPositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYinGui());
    }

    public String getPositionFu() {
        return LunarUtil.POSITION_FU[this.dayGanIndex + 1];
    }

    public String getPositionFuDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionFu());
    }

    public String getPositionCai() {
        return LunarUtil.POSITION_CAI[this.dayGanIndex + 1];
    }

    public String getPositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionCai());
    }

    public String getChong() {
        return LunarUtil.CHONG.get(this.getDayZhi());
    }

    public String getChongGan() {
        return LunarUtil.CHONG_GAN.get(this.getDayGan());
    }

    public String getChongGanTie() {
        return LunarUtil.CHONG_GAN_TIE.get(this.getDayGan());
    }

    public String getChongShengXiao() {
        String chong = this.getChong();
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(chong)) continue;
            return LunarUtil.SHENGXIAO[i];
        }
        return "";
    }

    public String getChongDesc() {
        return "(" + this.getChongGan() + this.getChong() + ")" + this.getChongShengXiao();
    }

    public String getSha() {
        return LunarUtil.SHA.get(this.getDayZhi());
    }

    public String getYearNaYin() {
        return LunarUtil.NAYIN.get(this.getYearInGanZhi());
    }

    public String getMonthNaYin() {
        return LunarUtil.NAYIN.get(this.getMonthInGanZhi());
    }

    public String getDayNaYin() {
        return LunarUtil.NAYIN.get(this.getDayInGanZhi());
    }

    public String getTimeNaYin() {
        return LunarUtil.NAYIN.get(this.getTimeInGanZhi());
    }

    public List<String> getBaZi() {
        ArrayList<String> l = new ArrayList<String>(4);
        String dayGan = this.getDayGan();
        int dayGanIndex = 1;
        int j = LunarUtil.GAN.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.GAN[i].equals(dayGan)) continue;
            dayGanIndex = i;
            break;
        }
        --dayGanIndex;
        dayGanIndex %= 5;
        String timeZhi = this.getTimeZhi();
        int timeZhiIndex = 1;
        int j2 = LunarUtil.ZHI.length;
        for (int i = 0; i < j2; ++i) {
            if (!LunarUtil.ZHI[i].equals(timeZhi)) continue;
            timeZhiIndex = i;
            break;
        }
        String timeGan = LunarUtil.GAN[(dayGanIndex * 12 + --timeZhiIndex) % 10 + 1];
        l.add(this.getYearInGanZhi());
        l.add(this.getMonthInGanZhi());
        l.add(this.getDayInGanZhi());
        l.add(timeGan + this.getTimeZhi());
        return l;
    }

    public List<String> getBaZiWuXing() {
        List<String> baZi = this.getBaZi();
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        for (String ganZhi : baZi) {
            String gan = ganZhi.substring(0, 1);
            String zhi = ganZhi.substring(1);
            l.add(LunarUtil.WU_XING_GAN.get(gan) + LunarUtil.WU_XING_ZHI.get(zhi));
        }
        return l;
    }

    public List<String> getBaZiNaYin() {
        List<String> baZi = this.getBaZi();
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        for (String ganZhi : baZi) {
            l.add(LunarUtil.NAYIN.get(ganZhi));
        }
        return l;
    }

    public List<String> getBaZiShiShenGan() {
        List<String> baZi = this.getBaZi();
        String yearGan = baZi.get(0).substring(0, 1);
        String monthGan = baZi.get(1).substring(0, 1);
        String dayGan = baZi.get(2).substring(0, 1);
        String timeGan = baZi.get(3).substring(0, 1);
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        l.add(LunarUtil.SHI_SHEN_GAN.get(dayGan + yearGan));
        l.add(LunarUtil.SHI_SHEN_GAN.get(dayGan + monthGan));
        l.add("\u65e5\u4e3b");
        l.add(LunarUtil.SHI_SHEN_GAN.get(dayGan + timeGan));
        return l;
    }

    public List<String> getBaZiShiShenZhi() {
        List<String> baZi = this.getBaZi();
        String dayGan = baZi.get(2).substring(0, 1);
        ArrayList<String> l = new ArrayList<String>(baZi.size());
        for (String ganZhi : baZi) {
            String zhi = ganZhi.substring(1);
            l.add(LunarUtil.SHI_SHEN_ZHI.get(dayGan + zhi + LunarUtil.ZHI_HIDE_GAN.get(zhi).get(0)));
        }
        return l;
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this.toString());
        s.append(" ");
        s.append(this.getYearInGanZhi());
        s.append("(");
        s.append(this.getYearShengXiao());
        s.append(")\u5e74 ");
        s.append(this.getMonthInGanZhi());
        s.append("(");
        s.append(this.getMonthShengXiao());
        s.append(")\u6708 ");
        s.append(this.getDayInGanZhi());
        s.append("(");
        s.append(this.getDayShengXiao());
        s.append(")\u65e5 ");
        s.append(this.getTimeZhi());
        s.append("(");
        s.append(this.getTimeShengXiao());
        s.append(")\u65f6 \u7eb3\u97f3[");
        s.append(this.getYearNaYin());
        s.append(" ");
        s.append(this.getMonthNaYin());
        s.append(" ");
        s.append(this.getDayNaYin());
        s.append(" ");
        s.append(this.getTimeNaYin());
        s.append("] \u661f\u671f");
        s.append(this.getWeekInChinese());
        for (String f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        for (String f : this.getOtherFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        String jq = this.getJie() + this.getQi();
        if (jq.length() > 0) {
            s.append(" [");
            s.append(jq);
            s.append("]");
        }
        s.append(" ");
        s.append(this.getGong());
        s.append("\u65b9");
        s.append(this.getShou());
        s.append(" \u661f\u5bbf[");
        s.append(this.getXiu());
        s.append(this.getZheng());
        s.append(this.getAnimal());
        s.append("](");
        s.append(this.getXiuLuck());
        s.append(") \u5f6d\u7956\u767e\u5fcc[");
        s.append(this.getPengZuGan());
        s.append(" ");
        s.append(this.getPengZuZhi());
        s.append("]");
        s.append(" \u559c\u795e\u65b9\u4f4d[");
        s.append(this.getPositionXi());
        s.append("](");
        s.append(this.getPositionXiDesc());
        s.append(")");
        s.append(" \u9633\u8d35\u795e\u65b9\u4f4d[");
        s.append(this.getPositionYangGui());
        s.append("](");
        s.append(this.getPositionYangGuiDesc());
        s.append(")");
        s.append(" \u9634\u8d35\u795e\u65b9\u4f4d[");
        s.append(this.getPositionYinGui());
        s.append("](");
        s.append(this.getPositionYinGuiDesc());
        s.append(")");
        s.append(" \u798f\u795e\u65b9\u4f4d[");
        s.append(this.getPositionFu());
        s.append("](");
        s.append(this.getPositionFuDesc());
        s.append(")");
        s.append(" \u8d22\u795e\u65b9\u4f4d[");
        s.append(this.getPositionCai());
        s.append("](");
        s.append(this.getPositionCaiDesc());
        s.append(")");
        s.append(" \u51b2[");
        s.append(this.getChongDesc());
        s.append("] \u715e[");
        s.append(this.getSha());
        s.append("]");
        return s.toString();
    }

    public String toString() {
        return this.getYearInChinese() + "\u5e74" + this.getMonthInChinese() + "\u6708" + this.getDayInChinese();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Solar getSolar() {
        return this.solar;
    }
}

