/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts.wrapper;

import cn.coder.struts.view.MultipartFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipartRequestWrapper {
    static final Logger logger = LoggerFactory.getLogger(MultipartRequestWrapper.class);
    private HttpServletRequest request;
    private HashMap<String, String> paras = new HashMap();
    private HashMap<String, MultipartFile> multipartFiles = new HashMap();
    private static ServletFileUpload upload;

    public MultipartRequestWrapper(HttpServletRequest req) {
        this.request = req;
        if (upload == null) {
            logger.debug("Init file upload");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            upload = new ServletFileUpload((FileItemFactory)factory);
        }
    }

    public void processRequest(processFile process) {
        try {
            FileItemIterator items = upload.getItemIterator(this.request);
            if (items != null) {
                while (items.hasNext()) {
                    FileItemStream stream = items.next();
                    if (stream.isFormField()) {
                        this.paras.put(stream.getFieldName(), Streams.asString((InputStream)stream.openStream(), (String)"utf-8"));
                        continue;
                    }
                    MultipartFile file = new MultipartFile(stream);
                    this.paras.put(file.getFieldName(), process.processMultipartFile(file));
                    this.multipartFiles.put(file.getFieldName(), file);
                }
            }
        }
        catch (IOException | FileUploadException e) {
            logger.error("Process request faild", e);
        }
    }

    public String getField(String name, String temp) {
        String str = this.paras.get(name);
        if (str == null) {
            return temp;
        }
        return str;
    }

    public MultipartFile getMultipartFile(String name) {
        return this.multipartFiles.get(name);
    }

    public void clear() {
        this.paras.clear();
        this.paras = null;
        for (MultipartFile file : this.multipartFiles.values()) {
            file.clear();
        }
        this.multipartFiles.clear();
        this.multipartFiles = null;
        this.request = null;
    }

    public static interface processFile {
        public String processMultipartFile(MultipartFile var1);
    }
}

