/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts.wrapper;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONWrapper {
    private static final String COMMA = ",";
    private static final String MARKS = "\"";
    private static final String COLON = ":";
    private static final String BRACKET_LEFT = "[";
    private static final String BRACKET_RIGHT = "]";
    private static final String BRACE_LEFT = "{";
    private static final String BRACE_RIGHT = "}";
    private static final String STR_VERSION_UID = "serialVersionUID";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    final StringBuilder json = new StringBuilder();

    public String write(Map<String, Object> jsonMap) {
        try {
            this.appendMap(jsonMap);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return this.json.toString();
    }

    private void appendMap(Map<?, ?> map) {
        this.json.append(BRACE_LEFT);
        Iterator<?> keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.appendObj(key, map.get(key), keys.hasNext());
        }
        JSONWrapper.checkLast(this.json);
        this.json.append(BRACE_RIGHT);
    }

    private void appendObj(String key, Object obj, boolean hasNext) {
        if (obj == null || STR_VERSION_UID.equals(key)) {
            return;
        }
        if (key != null) {
            this.json.append(MARKS).append(key).append(MARKS).append(COLON);
        }
        if (JSONWrapper.isNumber(obj)) {
            this.appendNum(obj);
        } else if (JSONWrapper.isString(obj)) {
            this.appendString(obj.toString());
        } else if (this.isDate(obj)) {
            this.appendDate(obj);
        } else if (JSONWrapper.isArray(obj)) {
            this.appendArray(obj);
        } else if (JSONWrapper.isList(obj)) {
            this.appendList((List)obj);
        } else if (JSONWrapper.isMap(obj)) {
            this.appendMap((Map)obj);
        } else {
            this.appendBean(obj);
        }
        if (hasNext) {
            this.json.append(COMMA);
        }
    }

    private void appendDate(Object obj) {
        this.json.append(MARKS).append(this.sdf.format((Date)obj)).append(MARKS);
    }

    private boolean isDate(Object obj) {
        return obj instanceof Date || obj instanceof Timestamp;
    }

    private void appendBean(Object obj) {
        this.json.append(BRACE_LEFT);
        Map<String, Object> map = JSONWrapper.getBeanValue(obj);
        Iterator<String> keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            this.appendObj(key, map.get(key), keys.hasNext());
        }
        JSONWrapper.checkLast(this.json);
        this.json.append(BRACE_RIGHT);
    }

    private static Map<String, Object> getBeanValue(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object obj2 = field.get(obj);
                field.setAccessible(false);
                if (obj2 == null) continue;
                map.put(field.getName(), obj2);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return map;
    }

    private void appendList(List<?> list) {
        this.json.append(BRACKET_LEFT);
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            this.appendObj(null, list.get(i), i != len - 1);
        }
        JSONWrapper.checkLast(this.json);
        this.json.append(BRACKET_RIGHT);
    }

    private void appendArray(Object obj) {
        this.json.append(BRACKET_LEFT);
        int len = Array.getLength(obj);
        for (int i = 0; i < len; ++i) {
            this.appendObj(null, Array.get(obj, i), i != len - 1);
        }
        JSONWrapper.checkLast(this.json);
        this.json.append(BRACKET_RIGHT);
    }

    private void appendNum(Object obj) {
        this.json.append(obj);
    }

    private void appendString(String str) {
        if (str.indexOf("\n") > -1) {
            str = str.replace("\n", "\\n");
        }
        if (str.indexOf("\r") > -1) {
            str = str.replace("\r", "\\r");
        }
        if (str.indexOf("\t") > -1) {
            str = str.replace("\t", "\\t");
        }
        if (str.indexOf(MARKS) > -1) {
            str = str.replace(MARKS, "\\\"");
        }
        this.json.append(MARKS).append(str).append(MARKS);
    }

    private static void checkLast(StringBuilder json2) {
        int len = json2.length();
        if (COMMA.equals(json2.substring(len - 1, len))) {
            json2.deleteCharAt(len - 1);
        }
    }

    private static boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    private static boolean isList(Object obj) {
        return obj instanceof List;
    }

    private static boolean isArray(Object obj) {
        return obj.getClass().isArray();
    }

    private static boolean isString(Object obj) {
        return obj instanceof CharSequence || obj instanceof Character;
    }

    private static boolean isNumber(Object obj) {
        return obj instanceof Integer || obj instanceof Boolean || obj instanceof Double || obj instanceof Long || obj instanceof Byte || obj instanceof Float || obj instanceof Short;
    }
}

