/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts.wrapper;

import cn.coder.struts.support.ActionSupport;
import cn.coder.struts.util.Assert;
import cn.coder.struts.util.BeanUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionWrapper {
    private final ArrayList<Method> startUpMappings = new ArrayList();
    private final HashMap<String, Method> urlMappings = new HashMap();
    private final HashMap<Method, ActionSupport> cachedBeans = new HashMap();

    public void put(String urlMapping, Method method) {
        this.urlMappings.put(urlMapping, method);
    }

    public void add(Method method) {
        this.startUpMappings.add(method);
    }

    public synchronized void clear() {
        this.startUpMappings.clear();
        this.urlMappings.clear();
        this.cachedBeans.clear();
    }

    public Set<String> getMappedUrls() {
        return this.urlMappings.keySet();
    }

    public void registerBean(String action, HashMap<Class<?>, Object> classes) throws ServletException {
        Method method = this.urlMappings.get(action);
        this.cachedBeans.put(method, (ActionSupport)this.createBean(method.getDeclaringClass(), classes));
    }

    public void runStartUp(HashMap<Class<?>, Object> classes) throws ServletException {
        if (!this.startUpMappings.isEmpty()) {
            for (Method method : this.startUpMappings) {
                Object obj = this.createBean(method.getDeclaringClass(), classes);
                try {
                    method.invoke(obj, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new ServletException("Run startup faild", (Throwable)e);
                }
            }
        }
    }

    private synchronized Object createBean(Class<?> clazz, HashMap<Class<?>, Object> classes) throws ServletException {
        try {
            Object obj = classes.get(clazz);
            if (obj == null) {
                obj = clazz.newInstance();
                classes.put(clazz, obj);
                Set<Field> fields = BeanUtils.getDeclaredFields(clazz);
                block4: for (Field field : fields) {
                    if (field.getAnnotation(Resource.class) == null) continue;
                    Set<Class<?>> keys = classes.keySet();
                    for (Class<?> cla : keys) {
                        if (!field.getType().isAssignableFrom(cla)) continue;
                        try {
                            BeanUtils.setValue(field, obj, this.createBean(cla, classes));
                            continue block4;
                        }
                        catch (SecurityException | SQLException e) {
                            throw new ServletException("Create bean faild", (Throwable)e);
                        }
                    }
                }
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException("Create controller faild", (Throwable)e);
        }
    }

    public Method getActionMethod(String servletPath) {
        return this.urlMappings.get(servletPath);
    }

    public Object execute(Method method, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        ActionSupport support = this.cachedBeans.get(method);
        Assert.notNull(support, "controller");
        try {
            support.setRequest(req);
            support.setResponse(res);
            Object object = method.invoke((Object)support, new Object[0]);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ServletException("Invoke method faild", (Throwable)e);
        }
        finally {
            support.clear();
        }
    }
}

