/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts.view;

import cn.coder.struts.util.FileUtils;
import cn.coder.struts.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.util.http.fileupload.FileItemStream;

public class MultipartFile {
    private String fileName;
    private String extension;
    private Long size;
    private InputStream inputStream;
    private String fieldName;
    private String contentType;

    public MultipartFile(FileItemStream stream) throws IOException {
        this.fileName = stream.getName();
        this.fieldName = stream.getFieldName();
        this.inputStream = stream.openStream();
        this.size = this.inputStream.available();
        this.contentType = stream.getContentType();
        if (StringUtils.isNotBlank(this.fileName)) {
            int last = this.fileName.lastIndexOf(".");
            this.extension = last > 0 ? this.fileName.substring(last).toLowerCase() : "";
        }
    }

    public boolean transferTo(File dest) {
        if (this.inputStream == null) {
            return false;
        }
        return FileUtils.saveFile(dest, this.inputStream);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Long getSize() {
        return this.size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isPic() {
        if (StringUtils.isEmpty(this.extension)) {
            return false;
        }
        return ".jpg".equals(this.extension) || ".png".equals(this.extension) || ".bmp".equals(this.extension) || ".gif".equals(this.extension) || ".jpeg".equals(this.extension);
    }

    public boolean isVedio() {
        if (StringUtils.isEmpty(this.extension)) {
            return false;
        }
        return ".avi".equals(this.extension) || ".mp4".equals(this.extension) || ".wmv".equals(this.extension) || ".flv".equals(this.extension) || ".mov".equals(this.extension);
    }

    public void clear() {
        this.fileName = null;
        this.extension = null;
        this.size = null;
        this.inputStream = null;
        this.fieldName = null;
        this.contentType = null;
    }
}

