/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts.util;

import cn.coder.struts.util.DateEx;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;

public class BeanUtils {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void setValue(Field field, Object obj, Object value) throws SQLException {
        if (Modifier.isFinal(field.getModifiers())) {
            return;
        }
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(obj, BeanUtils.toValue(field.getType(), value));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SQLException("Set value faild", e);
        }
    }

    private static Object toValue(Class<?> type, Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(type)) {
            return value;
        }
        switch (type.getName()) {
            case "java.lang.String": {
                if (value instanceof Timestamp) {
                    return sdf.format(value);
                }
                return value.toString();
            }
            case "int": 
            case "java.lang.Integer": {
                return "".equals(value) ? null : Integer.valueOf(Integer.parseInt(value.toString()));
            }
            case "long": 
            case "java.lang.Long": {
                return "".equals(value) ? null : Long.valueOf(Long.parseLong(value.toString()));
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return "".equals(value) ? null : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
            }
            case "java.util.Date": {
                return DateEx.toDate(value);
            }
        }
        throw new SQLException("Unkonwn field type " + type.getName());
    }

    public static Set<Field> getDeclaredFields(Class<?> clazz) {
        HashSet<Field> fieldList = new HashSet<Field>();
        BeanUtils.getDeclaredFields(clazz, fieldList);
        return fieldList;
    }

    private static void getDeclaredFields(Class<?> clazz, Set<Field> fieldList) {
        if (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                fieldList.add(field);
            }
            BeanUtils.getDeclaredFields(clazz.getSuperclass(), fieldList);
        }
    }
}

