/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts.support;

import cn.coder.struts.util.BeanUtils;
import cn.coder.struts.util.StringUtils;
import cn.coder.struts.view.MultipartFile;
import cn.coder.struts.wrapper.MultipartRequestWrapper;
import cn.coder.struts.wrapper.SessionWrapper;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionSupport
implements MultipartRequestWrapper.processFile {
    private static final Logger logger = LoggerFactory.getLogger(ActionSupport.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected boolean isMultipartRequest;
    private MultipartRequestWrapper multipartWrapper;

    public void setRequest(HttpServletRequest req2) {
        this.request = req2;
        this.isMultipartRequest = ServletFileUpload.isMultipartContent((HttpServletRequest)this.request);
        if (this.isMultipartRequest) {
            this.multipartWrapper = new MultipartRequestWrapper(this.request);
            this.multipartWrapper.processRequest(this);
            if (logger.isDebugEnabled()) {
                logger.debug("Process multipart request");
            }
        }
    }

    public void setResponse(HttpServletResponse res2) {
        this.response = res2;
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    protected HttpServletResponse getResponse() {
        return this.response;
    }

    protected String getParameter(String name) {
        String str;
        Object value = this.request.getAttribute(name);
        String string = str = value == null ? this.request.getParameter(name) : value.toString();
        if (this.isMultipartRequest) {
            str = this.multipartWrapper.getField(name, str);
        }
        return StringUtils.filterJSNull(str);
    }

    protected Object getSession(String name) {
        return this.request.getSession().getAttribute(name);
    }

    protected Object getSession(String name, String sId) {
        return SessionWrapper.getAttribute(name, sId);
    }

    protected void setSession(String name, Object value) {
        this.request.getSession().setAttribute(name, value);
    }

    protected String getSessionId() {
        return this.request.getSession().getId();
    }

    protected MultipartFile getMultipartFile(String name) {
        if (this.isMultipartRequest) {
            return this.multipartWrapper.getMultipartFile(name);
        }
        return null;
    }

    protected <T> T getPostData(Class<T> clazz) {
        try {
            T obj = clazz.newInstance();
            Set<Field> fields = BeanUtils.getDeclaredFields(clazz);
            for (Field field : fields) {
                String str = this.getParameter(field.getName());
                if (str == null) continue;
                BeanUtils.setValue(field, obj, str);
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException | SQLException e) {
            logger.error("getPostData faild", (Throwable)e);
            return null;
        }
    }

    protected String getRemoteAddr() {
        String ip = this.request.getRemoteAddr();
        if ("127.0.0.1".equals(ip)) {
            return this.request.getHeader("X-Real-IP");
        }
        return ip;
    }

    @Override
    public abstract String processMultipartFile(MultipartFile var1);

    public void clear() {
        this.request = null;
        this.response = null;
        this.isMultipartRequest = false;
        if (this.multipartWrapper != null) {
            this.multipartWrapper.clear();
            this.multipartWrapper = null;
        }
    }
}

