/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts;

import cn.coder.struts.support.ActionIntercepter;
import cn.coder.struts.support.WebInitializer;
import cn.coder.struts.util.ClassUtils;
import cn.coder.struts.wrapper.ActionWrapper;
import cn.coder.struts.wrapper.ResponseWrapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrutsFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(StrutsFilter.class);
    private ResponseWrapper wrapper;
    private ActionWrapper actionWrapper;
    private ArrayList<WebInitializer> initArray;
    private ArrayList<ActionIntercepter> filters;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initWebInitializer(filterConfig.getServletContext());
        this.initFilter(filterConfig.getServletContext());
        this.initAction(filterConfig.getServletContext());
        this.wrapper = new ResponseWrapper();
    }

    private void initFilter(ServletContext sc) {
        this.filters = (ArrayList)sc.getAttribute("Filters");
        sc.removeAttribute("Filters");
    }

    private void initWebInitializer(ServletContext sc) {
        Set InitializerClasses = (Set)sc.getAttribute("InitializerClasses");
        sc.removeAttribute("InitializerClasses");
        if (InitializerClasses != null && InitializerClasses.size() > 0) {
            this.initArray = new ArrayList();
            for (Class clazz : InitializerClasses) {
                try {
                    WebInitializer initObj = (WebInitializer)clazz.newInstance();
                    initObj.onStartup(sc);
                    this.initArray.add(initObj);
                }
                catch (Exception e) {
                    logger.error("WebInitializer start faild", (Throwable)e);
                }
            }
        }
    }

    private void initAction(ServletContext sc) throws ServletException {
        this.actionWrapper = (ActionWrapper)sc.getAttribute("ActionWrapper");
        sc.removeAttribute("ActionWrapper");
        HashMap classes = (HashMap)sc.getAttribute("Classes");
        sc.removeAttribute("Classes");
        FilterRegistration filter = sc.getFilterRegistration("StrutsFilter");
        Set<String> mappedUrls = this.actionWrapper.getMappedUrls();
        if (!mappedUrls.isEmpty()) {
            EnumSet<DispatcherType> dispatcherTypes = EnumSet.allOf(DispatcherType.class);
            dispatcherTypes.add(DispatcherType.REQUEST);
            dispatcherTypes.add(DispatcherType.FORWARD);
            for (String action : mappedUrls) {
                filter.addMappingForUrlPatterns(dispatcherTypes, true, new String[]{action});
                this.actionWrapper.registerBean(action, classes);
            }
        }
        this.actionWrapper.runStartUp(classes);
        classes.clear();
        logger.debug("Registered actions " + mappedUrls.size());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long start = System.currentTimeMillis();
        request.setCharacterEncoding("utf-8");
        response.setCharacterEncoding("utf-8");
        HttpServletRequest req = (HttpServletRequest)request;
        if (logger.isDebugEnabled()) {
            logger.debug("Request [{}]{}", (Object)req.getMethod(), (Object)req.getServletPath());
        }
        if (req.getMethod().equals("OPTIONS")) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse res = (HttpServletResponse)response;
        if (!this.checkFilter(req, res)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Action stoped by filter");
            }
            return;
        }
        Method method = this.actionWrapper.getActionMethod(req.getServletPath());
        if (method != null) {
            if (!ClassUtils.allowHttpMethod(method, req.getMethod())) {
                res.sendError(405, "Request method '" + req.getMethod() + "' not supported");
                if (logger.isDebugEnabled()) {
                    logger.debug("{} method not allowed", (Object)req.getMethod());
                }
                return;
            }
            Object result = this.actionWrapper.execute(method, req, res);
            if (result != null) {
                this.wrapper.doResponse(result, req, res);
            }
        } else {
            chain.doFilter(request, response);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Request finished with {}ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private boolean checkFilter(HttpServletRequest req, HttpServletResponse res) {
        if (this.filters == null || this.filters.isEmpty()) {
            return true;
        }
        for (ActionIntercepter intercepter : this.filters) {
            if (intercepter.intercept(req, res)) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        if (this.actionWrapper != null) {
            this.actionWrapper.clear();
            this.actionWrapper = null;
        }
        if (this.initArray != null) {
            for (WebInitializer webInitializer : this.initArray) {
                try {
                    webInitializer.destroy();
                }
                catch (Exception e) {
                    logger.error("WebInitializer destroy faild", (Throwable)e);
                }
            }
        }
        if (this.filters != null) {
            this.filters.clear();
            this.filters = null;
        }
        this.wrapper = null;
    }
}

